/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt;

import java.awt.EventQueue;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.grunt.GruntBuildTool;
import org.netbeans.modules.javascript.grunt.exec.GruntExecutable;
import org.netbeans.modules.javascript.grunt.file.GruntTasks;
import org.netbeans.modules.javascript.grunt.util.GruntUtils;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class GruntBuildToolSupport
implements BuildTools.BuildToolSupport {
    protected final Project project;
    @NullAllowed
    protected final FileObject gruntfile;
    protected final GruntTasks gruntTasks;

    public GruntBuildToolSupport(Project project, @NullAllowed FileObject gruntfile) {
        assert (project != null);
        this.project = project;
        this.gruntfile = gruntfile;
        this.gruntTasks = GruntBuildTool.forProject(project).getGruntTasks(gruntfile);
    }

    public String getIdentifier() {
        return "Grunt";
    }

    public String getBuildToolExecName() {
        return GruntExecutable.GRUNT_NAME;
    }

    public Project getProject() {
        return this.project;
    }

    public FileObject getWorkDir() {
        if (this.gruntfile == null) {
            return this.project.getProjectDirectory();
        }
        return this.gruntfile.getParent();
    }

    public Future<List<String>> getTasks() {
        return new TasksFuture(this.gruntTasks);
    }

    public void runTask(String ... args) {
        assert (!EventQueue.isDispatchThread());
        GruntExecutable grunt = this.getGruntExecutable();
        if (grunt != null) {
            GruntUtils.logUsageGruntBuild();
            grunt.run(args);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.gruntTasks.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.gruntTasks.removeChangeListener(listener);
    }

    @CheckForNull
    private GruntExecutable getGruntExecutable() {
        if (this.gruntfile == null) {
            return GruntExecutable.getDefault(this.project, true);
        }
        return GruntExecutable.getDefault(this.project, FileUtil.toFile((FileObject)this.gruntfile).getParentFile(), true);
    }

    private static final class TasksFuture
    implements Future<List<String>> {
        private final GruntTasks gruntTasks;

        public TasksFuture(GruntTasks gruntTasks) {
            assert (gruntTasks != null);
            this.gruntTasks = gruntTasks;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.gruntTasks.getTasks() != null;
        }

        @Override
        public List<String> get() throws InterruptedException, ExecutionException {
            try {
                return this.gruntTasks.loadTasks(null, null);
            }
            catch (TimeoutException ex) {
                assert (false);
                return null;
            }
        }

        @Override
        public List<String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.gruntTasks.loadTasks(timeout, unit);
        }
    }
}

