/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.typinghooks;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.web.indent.api.LexUtilities;
import org.netbeans.spi.editor.typinghooks.DeletedTextInterceptor;

public class HtmlDeletedTextInterceptor
implements DeletedTextInterceptor {
    public boolean beforeRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
        TokenSequence ts;
        Document doc = context.getDocument();
        int dotPos = context.getOffset();
        char ch = context.getText().charAt(0);
        if ((ch == '\'' || ch == '\"') && (ts = LexUtilities.getTokenSequence((BaseDocument)((BaseDocument)doc), (int)dotPos, (Language)HTMLTokenId.language())) != null) {
            char first;
            int diff = ts.move(dotPos);
            if (diff != 1) {
                return;
            }
            if (!ts.moveNext()) {
                return;
            }
            Token token = ts.token();
            if ((token.id() == HTMLTokenId.VALUE || token.id() == HTMLTokenId.VALUE_CSS || token.id() == HTMLTokenId.VALUE_JAVASCRIPT) && (first = token.text().charAt(0)) == ch) {
                doc.remove(dotPos - 1, 1);
            }
        }
    }

    public void afterRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
    }

    public void cancelled(DeletedTextInterceptor.Context context) {
    }

    public static final class Factory
    implements DeletedTextInterceptor.Factory {
        public DeletedTextInterceptor createDeletedTextInterceptor(MimePath mimePath) {
            return new HtmlDeletedTextInterceptor();
        }
    }
}

