/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import org.testng.ISuite;
import org.testng.SuiteResultCounts;
import org.testng.SuiteRunner;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.SuiteRunnerMap;
import org.testng.internal.Utils;
import org.testng.internal.thread.graph.IWorker;
import org.testng.xml.XmlSuite;

public class SuiteRunnerWorker
implements IWorker<ISuite> {
    private SuiteRunner m_suiteRunner;
    private Integer m_verbose;
    private String m_defaultSuiteName;
    private SuiteRunnerMap m_suiteRunnerMap;

    public SuiteRunnerWorker(ISuite iSuite, SuiteRunnerMap suiteRunnerMap, int n, String string) {
        this.m_suiteRunnerMap = suiteRunnerMap;
        this.m_suiteRunner = (SuiteRunner)iSuite;
        this.m_verbose = n;
        this.m_defaultSuiteName = string;
    }

    private void runSuite(SuiteRunnerMap suiteRunnerMap, XmlSuite xmlSuite) {
        Object object;
        if (this.m_verbose > 0) {
            object = "  " + (xmlSuite.getFileName() != null ? xmlSuite.getFileName() : this.m_defaultSuiteName) + '\n';
            Utils.log("TestNG", 0, "Running:\n" + (String)object);
        }
        object = (SuiteRunner)suiteRunnerMap.get(xmlSuite);
        ((SuiteRunner)object).run();
        if (xmlSuite.getVerbose() > 0) {
            SuiteResultCounts suiteResultCounts = new SuiteResultCounts();
            suiteResultCounts.calculateResultCounts(xmlSuite, suiteRunnerMap);
            StringBuilder stringBuilder = new StringBuilder("\n===============================================\n").append(xmlSuite.getName());
            stringBuilder.append("\nTotal tests run: ").append(suiteResultCounts.m_total).append(", Failures: ").append(suiteResultCounts.m_failed).append(", Skips: ").append(suiteResultCounts.m_skipped);
            if (suiteResultCounts.m_confFailures > 0 || suiteResultCounts.m_confSkips > 0) {
                stringBuilder.append("\nConfiguration Failures: ").append(suiteResultCounts.m_confFailures).append(", Skips: ").append(suiteResultCounts.m_confSkips);
            }
            stringBuilder.append("\n===============================================\n");
            System.out.println(stringBuilder.toString());
        }
    }

    @Override
    public void run() {
        this.runSuite(this.m_suiteRunnerMap, this.m_suiteRunner.getXmlSuite());
    }

    @Override
    public int compareTo(IWorker<ISuite> iWorker) {
        return 0;
    }

    @Override
    public List<ISuite> getTasks() {
        List<ISuite> list = Lists.newArrayList();
        list.add(this.m_suiteRunner);
        return list;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("name", this.m_suiteRunner.getName()).toString();
    }

    @Override
    public long getTimeOut() {
        return this.m_suiteRunner.getXmlSuite().getTimeOut(Long.MAX_VALUE);
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

