/*----------------------------------------------------------------------------*/
/* This file is generated by the templates/template.rb script and should not  */
/* be modified manually. See                                                  */
/* templates/src/diagnostic.c.erb                                             */
/* if you are looking to modify the                                           */
/* template                                                                   */
/*----------------------------------------------------------------------------*/

#include "prism/diagnostic.h"

#define PM_DIAGNOSTIC_ID_MAX 319

/** This struct holds the data for each diagnostic. */
typedef struct {
    /** The message associated with the diagnostic. */
    const char* message;

    /** The level associated with the diagnostic. */
    uint8_t level;
} pm_diagnostic_data_t;

/**
 * ## Message composition
 *
 * When composing an error message, use sentence fragments.
 *
 * Try describing the property of the code that caused the error, rather than
 * the rule that is being violated. It may help to use a fragment that completes
 * a sentence beginning, "the parser encountered (a) ...". If appropriate, add a
 * description of the rule violation (or other helpful context) after a
 * semicolon.
 *
 * For example:, instead of "control escape sequence cannot be doubled", prefer:
 *
 * > "invalid control escape sequence; control cannot be repeated"
 *
 * In some cases, where the failure is more general or syntax expectations are
 * violated, it may make more sense to use a fragment that completes a sentence
 * beginning, "the parser ...".
 *
 * For example:
 *
 * > "expected an expression after `(`"
 * > "cannot parse the expression"
 *
 * ## Message style guide
 *
 * - Use articles like "a", "an", and "the" when appropriate.
 *   - e.g., prefer "cannot parse the expression" to "cannot parse expression".
 * - Use the common name for tokens and nodes.
 *   - e.g., prefer "keyword splat" to "assoc splat"
 *   - e.g., prefer "embedded document" to "embdoc"
 * - Do not capitalize the initial word of the message.
 * - Use back ticks around token literals
 *   - e.g., "Expected a `=>` between the hash key and value"
 * - Do not use `.` or other punctuation at the end of the message.
 * - Do not use contractions like "can't". Prefer "cannot" to "can not".
 * - For tokens that can have multiple meanings, reference the token and its meaning.
 *   - e.g., "`*` splat argument" is clearer and more complete than "splat argument" or "`*` argument"
 *
 * ## Error names (PM_ERR_*)
 *
 * - When appropriate, prefer node name to token name.
 *   - e.g., prefer "SPLAT" to "STAR" in the context of argument parsing.
 * - Prefer token name to common name.
 *   - e.g., prefer "STAR" to "ASTERISK".
 * - Try to order the words in the name from more general to more specific,
 *   - e.g., "INVALID_NUMBER_DECIMAL" is better than "DECIMAL_INVALID_NUMBER".
 *   - When in doubt, look for similar patterns and name them so that they are grouped when lexically
 *     sorted. See PM_ERR_ARGUMENT_NO_FORWARDING_* for an example.
 *
 * ## Level
 *
 * For errors, they are:
 *
 * * `PM_ERROR_LEVEL_SYNTAX` - Errors that should raise SyntaxError.
 * * `PM_ERROR_LEVEL_ARGUMENT` - Errors that should raise ArgumentError.
 * * `PM_ERROR_LEVEL_LOAD` - Errors that should raise LoadError.
 *
 * For warnings, they are:
 *
 * * `PM_WARNING_LEVEL_DEFAULT` - Warnings that appear for `ruby -c -e 'code'`.
 * * `PM_WARNING_LEVEL_VERBOSE` - Warnings that appear with `-w`, as in `ruby -w -c -e 'code'`.
 */
static const pm_diagnostic_data_t diagnostic_messages[PM_DIAGNOSTIC_ID_MAX] = {
    // Special error that can be replaced
    [PM_ERR_CANNOT_PARSE_EXPRESSION]            = { "cannot parse the expression", PM_ERROR_LEVEL_SYNTAX },

    // Errors that should raise argument errors
    [PM_ERR_INVALID_ENCODING_MAGIC_COMMENT]     = { "unknown or invalid encoding in the magic comment", PM_ERROR_LEVEL_ARGUMENT },

    // Errors that should raise load errors
    [PM_ERR_SCRIPT_NOT_FOUND]                   = { "no Ruby script found in input", PM_ERROR_LEVEL_LOAD },

    // Errors that should raise syntax errors
    [PM_ERR_ALIAS_ARGUMENT]                     = { "invalid argument being passed to `alias`; expected a bare word, symbol, constant, or global variable", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ALIAS_ARGUMENT_NUMBERED_REFERENCE]  = { "invalid argument being passed to `alias`; can't make alias for the number variables", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_AMPAMPEQ_MULTI_ASSIGN]              = { "unexpected `&&=` in a multiple assignment", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_AFTER_BLOCK]               = { "unexpected argument after a block argument", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_AFTER_FORWARDING_ELLIPSES] = { "unexpected argument after `...`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_BARE_HASH]                 = { "unexpected bare hash argument", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_BLOCK_MULTI]               = { "both block arg and actual block given; only one block is allowed", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_CONFLICT_AMPERSAND]        = { "unexpected `&`; anonymous block parameter is also used within block", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_CONFLICT_STAR]             = { "unexpected `*`; anonymous rest parameter is also used within block", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_CONFLICT_STAR_STAR]        = { "unexpected `**`; anonymous keyword rest parameter is also used within block", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_FORMAL_CLASS]              = { "invalid formal argument; formal argument cannot be a class variable", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_FORMAL_CONSTANT]           = { "invalid formal argument; formal argument cannot be a constant", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_FORMAL_GLOBAL]             = { "invalid formal argument; formal argument cannot be a global variable", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_FORMAL_IVAR]               = { "invalid formal argument; formal argument cannot be an instance variable", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_FORWARDING_UNBOUND]        = { "unexpected `...` in an non-parenthesized call", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_NO_FORWARDING_AMPERSAND]   = { "unexpected `&`; no anonymous block parameter", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_NO_FORWARDING_ELLIPSES]    = { "unexpected ... when the parent method is not forwarding", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_NO_FORWARDING_STAR]        = { "unexpected `*`; no anonymous rest parameter", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_NO_FORWARDING_STAR_STAR]   = { "unexpected `**`; no anonymous keyword rest parameter", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_SPLAT_AFTER_ASSOC_SPLAT]   = { "unexpected `*` splat argument after a `**` keyword splat argument", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_SPLAT_AFTER_SPLAT]         = { "unexpected `*` splat argument after a `*` splat argument", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_TERM_PAREN]                = { "unexpected %s; expected a `)` to close the arguments", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARGUMENT_UNEXPECTED_BLOCK]          = { "unexpected '{' after a method call without parenthesis", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARRAY_ELEMENT]                      = { "expected an element for the array", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARRAY_EXPRESSION]                   = { "expected an expression for the array element", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARRAY_EXPRESSION_AFTER_STAR]        = { "expected an expression after `*` in the array", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARRAY_SEPARATOR]                    = { "unexpected %s; expected a `,` separator for the array elements", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ARRAY_TERM]                         = { "unexpected %s; expected a `]` to close the array", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_BEGIN_LONELY_ELSE]                  = { "unexpected `else` in `begin` block; else without rescue is useless", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_BEGIN_TERM]                         = { "expected an `end` to close the `begin` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_BEGIN_UPCASE_BRACE]                 = { "expected a `{` after `BEGIN`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_BEGIN_UPCASE_TERM]                  = { "expected a `}` to close the `BEGIN` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_BEGIN_UPCASE_TOPLEVEL]              = { "BEGIN is permitted only at toplevel", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_BLOCK_PARAM_LOCAL_VARIABLE]         = { "expected a local variable name in the block parameters", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_BLOCK_PARAM_PIPE_TERM]              = { "expected the block parameters to end with `|`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_BLOCK_TERM_BRACE]                   = { "expected a block beginning with `{` to end with `}`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_BLOCK_TERM_END]                     = { "expected a block beginning with `do` to end with `end`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CANNOT_PARSE_STRING_PART]           = { "cannot parse the string part", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CASE_EXPRESSION_AFTER_CASE]         = { "expected an expression after `case`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CASE_EXPRESSION_AFTER_WHEN]         = { "expected an expression after `when`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CASE_MATCH_MISSING_PREDICATE]       = { "expected a predicate for a case matching statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CASE_MISSING_CONDITIONS]            = { "expected a `when` or `in` clause after `case`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CASE_TERM]                          = { "expected an `end` to close the `case` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CLASS_IN_METHOD]                    = { "unexpected class definition in method body", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CLASS_NAME]                         = { "unexpected constant path after `class`; class/module name must be CONSTANT", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CLASS_SUPERCLASS]                   = { "expected a superclass after `<`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CLASS_TERM]                         = { "expected an `end` to close the `class` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CLASS_UNEXPECTED_END]               = { "unexpected `end`, expecting ';' or '\\n'", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CLASS_VARIABLE_BARE]                = { "'@@' without identifiers is not allowed as a class variable name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CONDITIONAL_ELSIF_PREDICATE]        = { "expected a predicate expression for the `elsif` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CONDITIONAL_IF_PREDICATE]           = { "expected a predicate expression for the `if` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CONDITIONAL_PREDICATE_TERM]         = { "expected `then` or `;` or '\\n'", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CONDITIONAL_TERM]                   = { "expected an `end` to close the conditional clause", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CONDITIONAL_TERM_ELSE]              = { "expected an `end` to close the `else` clause", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CONDITIONAL_UNLESS_PREDICATE]       = { "expected a predicate expression for the `unless` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CONDITIONAL_UNTIL_PREDICATE]        = { "expected a predicate expression for the `until` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CONDITIONAL_WHILE_PREDICATE]        = { "expected a predicate expression for the `while` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_CONSTANT_PATH_COLON_COLON_CONSTANT] = { "expected a constant after the `::` operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_DEF_ENDLESS]                        = { "could not parse the endless method body", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_DEF_ENDLESS_SETTER]                 = { "invalid method name; a setter method cannot be defined in an endless method definition", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_DEF_NAME]                           = { "unexpected %s; expected a method name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_DEF_PARAMS_TERM]                    = { "expected a delimiter to close the parameters", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_DEF_PARAMS_TERM_PAREN]              = { "unexpected %s; expected a `)` to close the parameters", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_DEF_RECEIVER]                       = { "expected a receiver for the method definition", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_DEF_RECEIVER_TERM]                  = { "expected a `.` or `::` after the receiver in a method definition", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_DEF_TERM]                           = { "expected an `end` to close the `def` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_DEFINED_EXPRESSION]                 = { "expected an expression after `defined?`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EMBDOC_TERM]                        = { "embedded document meets end of file", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EMBEXPR_END]                        = { "expected a `}` to close the embedded expression", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EMBVAR_INVALID]                     = { "invalid embedded variable", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_END_UPCASE_BRACE]                   = { "expected a `{` after `END`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_END_UPCASE_TERM]                    = { "expected a `}` to close the `END` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_CONTROL]             = { "Invalid escape character syntax", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_CONTROL_REPEAT]      = { "invalid control escape sequence; control cannot be repeated", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_HEXADECIMAL]         = { "invalid hex escape sequence", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_META]                = { "Invalid escape character syntax", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_META_REPEAT]         = { "invalid meta escape sequence; meta cannot be repeated", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_UNICODE]             = { "invalid Unicode escape sequence", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_UNICODE_CM_FLAGS]    = { "invalid Unicode escape sequence; Unicode cannot be combined with control or meta flags", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_UNICODE_LIST]        = { "invalid Unicode list: %.*s", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_UNICODE_LITERAL]     = { "invalid Unicode escape sequence; Multiple codepoints at single character literal are disallowed", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_UNICODE_LONG]        = { "invalid Unicode escape sequence; maximum length is 6 digits", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_UNICODE_SHORT]       = { "too short escape sequence: %.*s", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_ESCAPE_INVALID_UNICODE_TERM]        = { "unterminated Unicode escape", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_ARGUMENT]                    = { "unexpected %s; expected an argument", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_EOL_AFTER_STATEMENT]         = { "unexpected %s, expecting end-of-input", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_EXPRESSION_AFTER_AMPAMPEQ]   = { "expected an expression after `&&=`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_EXPRESSION_AFTER_PIPEPIPEEQ] = { "expected an expression after `||=`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_EXPRESSION_AFTER_COMMA]      = { "expected an expression after `,`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_EXPRESSION_AFTER_EQUAL]      = { "expected an expression after `=`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_EXPRESSION_AFTER_LESS_LESS]  = { "expected an expression after `<<`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_EXPRESSION_AFTER_LPAREN]     = { "expected an expression after `(`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_EXPRESSION_AFTER_OPERATOR]   = { "unexpected %s; expected an expression after the operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_EXPRESSION_AFTER_SPLAT]      = { "expected an expression after `*` splat in an argument", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_EXPRESSION_AFTER_SPLAT_HASH] = { "expected an expression after `**` in a hash", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_EXPRESSION_AFTER_STAR]       = { "expected an expression after `*`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_FOR_DELIMITER]               = { "unexpected %s; expected a 'do', newline, or ';' after the 'for' loop collection", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_IDENT_REQ_PARAMETER]         = { "expected an identifier for the required parameter", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_IN_DELIMITER]                = { "expected a delimiter after the patterns of an `in` clause", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_LPAREN_REQ_PARAMETER]        = { "expected a `(` to start a required parameter", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_MESSAGE]                     = { "unexpected %s; expecting a message to send to the receiver", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_RBRACKET]                    = { "expected a matching `]`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_RPAREN]                      = { "expected a matching `)`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_RPAREN_AFTER_MULTI]          = { "expected a `)` after multiple assignment", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_RPAREN_REQ_PARAMETER]        = { "expected a `)` to end a required parameter", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_SINGLETON_CLASS_DELIMITER]   = { "unexpected %s; expected a newline or a ';' after the singleton class", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_STRING_CONTENT]              = { "expected string content after opening string delimiter", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPECT_WHEN_DELIMITER]              = { "expected a delimiter after the predicates of a `when` clause", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPRESSION_BARE_HASH]               = { "unexpected bare hash in expression", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPRESSION_NOT_WRITABLE]            = { "unexpected '='; target cannot be written", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPRESSION_NOT_WRITABLE_ENCODING]   = { "Can't assign to __ENCODING__", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPRESSION_NOT_WRITABLE_FALSE]      = { "Can't assign to false", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPRESSION_NOT_WRITABLE_FILE]       = { "Can't assign to __FILE__", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPRESSION_NOT_WRITABLE_LINE]       = { "Can't assign to __LINE__", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPRESSION_NOT_WRITABLE_NIL]        = { "Can't assign to nil", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPRESSION_NOT_WRITABLE_NUMBERED]   = { "Can't assign to numbered parameter %.2s", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPRESSION_NOT_WRITABLE_SELF]       = { "Can't change the value of self", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_EXPRESSION_NOT_WRITABLE_TRUE]       = { "Can't assign to true", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_FLOAT_PARSE]                        = { "could not parse the float '%.*s'", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_FOR_COLLECTION]                     = { "expected a collection after the `in` in a `for` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_FOR_INDEX]                          = { "expected an index after `for`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_FOR_IN]                             = { "expected an `in` after the index in a `for` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_FOR_TERM]                           = { "expected an `end` to close the `for` loop", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_GLOBAL_VARIABLE_BARE]               = { "'$' without identifiers is not allowed as a global variable name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_HASH_EXPRESSION_AFTER_LABEL]        = { "expected an expression after the label in a hash", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_HASH_KEY]                           = { "unexpected %s, expecting '}' or a key in the hash literal", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_HASH_ROCKET]                        = { "expected a `=>` between the hash key and value", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_HASH_TERM]                          = { "expected a `}` to close the hash literal", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_HASH_VALUE]                         = { "unexpected %s; expected a value in the hash literal", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_HEREDOC_IDENTIFIER]                 = { "unterminated here document identifier", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_HEREDOC_TERM]                       = { "unterminated heredoc; can't find string \"%.*s\" anywhere before EOF", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INCOMPLETE_QUESTION_MARK]           = { "incomplete expression at `?`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INCOMPLETE_VARIABLE_CLASS_3_3]      = { "`%.*s' is not allowed as a class variable name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INCOMPLETE_VARIABLE_CLASS]          = { "'%.*s' is not allowed as a class variable name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INCOMPLETE_VARIABLE_INSTANCE_3_3]   = { "`%.*s' is not allowed as an instance variable name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INCOMPLETE_VARIABLE_INSTANCE]       = { "'%.*s' is not allowed as an instance variable name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INSTANCE_VARIABLE_BARE]             = { "'@' without identifiers is not allowed as an instance variable name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_BLOCK_EXIT]                 = { "Invalid %s", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_COMMA]                      = { "invalid comma", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_ESCAPE_CHARACTER]           = { "Invalid escape character syntax", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_FLOAT_EXPONENT]             = { "invalid exponent", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_LOCAL_VARIABLE_READ]        = { "identifier %.*s is not valid to get", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_LOCAL_VARIABLE_WRITE]       = { "identifier %.*s is not valid to set", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_NUMBER_BINARY]              = { "invalid binary number; numeric literal without digits", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_NUMBER_DECIMAL]             = { "invalid decimal number; numeric literal without digits", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_NUMBER_FRACTION]            = { "unexpected fraction part after numeric literal", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_NUMBER_HEXADECIMAL]         = { "invalid hexadecimal number; numeric literal without digits", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_NUMBER_OCTAL]               = { "invalid octal number; numeric literal without digits", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_NUMBER_UNDERSCORE_INNER]    = { "invalid underscore placement in number", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_NUMBER_UNDERSCORE_TRAILING] = { "trailing '_' in number", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_CHARACTER]                  = { "Invalid char '\\x%02X' in expression", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_MULTIBYTE_CHAR]             = { "invalid multibyte char (%s)", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_MULTIBYTE_CHARACTER]        = { "invalid multibyte character 0x%X", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_MULTIBYTE_ESCAPE]           = { "invalid multibyte escape: /%.*s/", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_PRINTABLE_CHARACTER]        = { "invalid character `%c`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_PERCENT]                    = { "unknown type of %string", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_PERCENT_EOF]                = { "unterminated quoted string meets end of file", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_RETRY_AFTER_ELSE]           = { "Invalid retry after else", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_RETRY_AFTER_ENSURE]         = { "Invalid retry after ensure", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_RETRY_WITHOUT_RESCUE]       = { "Invalid retry without rescue", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_SYMBOL]                     = { "invalid symbol", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_VARIABLE_GLOBAL_3_3]        = { "`%.*s' is not allowed as a global variable name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_VARIABLE_GLOBAL]            = { "'%.*s' is not allowed as a global variable name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_INVALID_YIELD]                      = { "Invalid yield", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_IT_NOT_ALLOWED_NUMBERED]            = { "'it' is not allowed when a numbered parameter is already used", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_IT_NOT_ALLOWED_ORDINARY]            = { "'it' is not allowed when an ordinary parameter is defined", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_LAMBDA_OPEN]                        = { "expected a `do` keyword or a `{` to open the lambda block", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_LAMBDA_TERM_BRACE]                  = { "expected a lambda block beginning with `{` to end with `}`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_LAMBDA_TERM_END]                    = { "expected a lambda block beginning with `do` to end with `end`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_LIST_I_LOWER_ELEMENT]               = { "expected a symbol in a `%i` list", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_LIST_I_LOWER_TERM]                  = { "unterminated list; expected a closing delimiter for the `%i`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_LIST_I_UPPER_ELEMENT]               = { "expected a symbol in a `%I` list", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_LIST_I_UPPER_TERM]                  = { "unterminated list; expected a closing delimiter for the `%I`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_LIST_W_LOWER_ELEMENT]               = { "expected a string in a `%w` list", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_LIST_W_LOWER_TERM]                  = { "unterminated list; expected a closing delimiter for the `%w`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_LIST_W_UPPER_ELEMENT]               = { "expected a string in a `%W` list", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_LIST_W_UPPER_TERM]                  = { "unterminated list; expected a closing delimiter for the `%W`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_MALLOC_FAILED]                      = { "failed to allocate memory", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_MIXED_ENCODING]                     = { "UTF-8 mixed within %s source", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_MODULE_IN_METHOD]                   = { "unexpected module definition in method body", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_MODULE_NAME]                        = { "unexpected constant path after `module`; class/module name must be CONSTANT", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_MODULE_TERM]                        = { "expected an `end` to close the `module` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_MULTI_ASSIGN_MULTI_SPLATS]          = { "multiple splats in multiple assignment", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_MULTI_ASSIGN_UNEXPECTED_REST]       = { "unexpected '%.*s' resulting in multiple splats in multiple assignment", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_NESTING_TOO_DEEP]                   = { "nesting too deep", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_NO_LOCAL_VARIABLE]                  = { "%.*s: no such local variable", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_NON_ASSOCIATIVE_OPERATOR]           = { "unexpected %s; %s is a non-associative operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_NOT_EXPRESSION]                     = { "expected an expression after `not`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_NUMBER_LITERAL_UNDERSCORE]          = { "number literal ending with a `_`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_NUMBERED_PARAMETER_INNER_BLOCK]     = { "numbered parameter is already used in inner block", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_NUMBERED_PARAMETER_IT]              = { "numbered parameters are not allowed when 'it' is already used", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_NUMBERED_PARAMETER_ORDINARY]        = { "numbered parameters are not allowed when an ordinary parameter is defined", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_NUMBERED_PARAMETER_OUTER_BLOCK]     = { "numbered parameter is already used in outer block", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_OPERATOR_MULTI_ASSIGN]              = { "unexpected operator for a multiple assignment", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_OPERATOR_WRITE_ARGUMENTS]           = { "unexpected operator after a call with arguments", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_OPERATOR_WRITE_BLOCK]               = { "unexpected operator after a call with a block", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_ASSOC_SPLAT_MULTI]        = { "unexpected multiple `**` splat parameters", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_BLOCK_MULTI]              = { "multiple block parameters; only one block is allowed", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_CIRCULAR]                 = { "circular argument reference - %.*s", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_FORWARDING_AFTER_REST]    = { "... after rest argument", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_METHOD_NAME]              = { "unexpected name for a parameter", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_NAME_DUPLICATED]          = { "duplicated argument name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_NO_DEFAULT]               = { "expected a default value for the parameter", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_NO_DEFAULT_KW]            = { "expected a default value for the keyword parameter", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_NUMBERED_RESERVED]        = { "%.2s is reserved for numbered parameters", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_ORDER]                    = { "unexpected parameter order", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_SPLAT_MULTI]              = { "unexpected multiple `*` splat parameters", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_STAR]                     = { "unexpected parameter `*`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_UNEXPECTED_FWD]           = { "unexpected `...` in parameters", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_WILD_LOOSE_COMMA]         = { "unexpected `,` in parameters", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PARAMETER_UNEXPECTED_NO_KW]         = { "unexpected **nil; no keywords marker disallowed after keywords", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_ARRAY_MULTIPLE_RESTS]       = { "unexpected multiple '*' rest patterns in an array pattern", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_CAPTURE_DUPLICATE]          = { "duplicated variable name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_EXPRESSION_AFTER_BRACKET]   = { "expected a pattern expression after the `[` operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_EXPRESSION_AFTER_COMMA]     = { "expected a pattern expression after `,`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_EXPRESSION_AFTER_HROCKET]   = { "expected a pattern expression after `=>`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_EXPRESSION_AFTER_IN]        = { "expected a pattern expression after the `in` keyword", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_EXPRESSION_AFTER_KEY]       = { "expected a pattern expression after the key", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_EXPRESSION_AFTER_PAREN]     = { "expected a pattern expression after the `(` operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_EXPRESSION_AFTER_PIN]       = { "expected a pattern expression after the `^` pin operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_EXPRESSION_AFTER_PIPE]      = { "expected a pattern expression after the `|` operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_EXPRESSION_AFTER_RANGE]     = { "expected a pattern expression after the range operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_EXPRESSION_AFTER_REST]      = { "unexpected pattern expression after the `**` expression", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_FIND_MISSING_INNER]         = { "find patterns need at least one required inner pattern", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_HASH_IMPLICIT]              = { "unexpected implicit hash in pattern; use '{' to delineate", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_HASH_KEY]                   = { "unexpected %s; expected a key in the hash pattern", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_HASH_KEY_DUPLICATE]         = { "duplicated key name", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_HASH_KEY_INTERPOLATED]      = { "symbol literal with interpolation is not allowed", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_HASH_KEY_LABEL]             = { "expected a label as the key in the hash pattern", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_HASH_KEY_LOCALS]            = { "key must be valid as local variables", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_IDENT_AFTER_HROCKET]        = { "expected an identifier after the `=>` operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_LABEL_AFTER_COMMA]          = { "expected a label after the `,` in the hash pattern", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_REST]                       = { "unexpected rest pattern", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_TERM_BRACE]                 = { "expected a `}` to close the pattern expression", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_TERM_BRACKET]               = { "expected a `]` to close the pattern expression", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PATTERN_TERM_PAREN]                 = { "expected a `)` to close the pattern expression", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_PIPEPIPEEQ_MULTI_ASSIGN]            = { "unexpected `||=` in a multiple assignment", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_REGEXP_ENCODING_OPTION_MISMATCH]    = { "regexp encoding option '%c' differs from source encoding '%s'", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_REGEXP_INCOMPAT_CHAR_ENCODING]      = { "incompatible character encoding: /%.*s/", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_REGEXP_NON_ESCAPED_MBC]             = { "/.../n has a non escaped non ASCII character in non ASCII-8BIT script: /%.*s/", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_REGEXP_INVALID_UNICODE_RANGE]       = { "invalid Unicode range: /%.*s/", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_REGEXP_PARSE_ERROR]                 = { "%s", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_REGEXP_UNKNOWN_OPTIONS]             = { "unknown regexp %s - %.*s", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_REGEXP_TERM]                        = { "unterminated regexp meets end of file; expected a closing delimiter", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_REGEXP_UTF8_CHAR_NON_UTF8_REGEXP]   = { "UTF-8 character in non UTF-8 regexp: /%s/", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_RESCUE_EXPRESSION]                  = { "expected a rescued expression", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_RESCUE_MODIFIER_VALUE]              = { "expected a value after the `rescue` modifier", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_RESCUE_TERM]                        = { "expected a closing delimiter for the `rescue` clause", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_RESCUE_VARIABLE]                    = { "expected an exception variable after `=>` in a rescue statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_RETURN_INVALID]                     = { "Invalid return in class/module body", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_SINGLETON_FOR_LITERALS]             = { "cannot define singleton method for literals", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_STATEMENT_ALIAS]                    = { "unexpected an `alias` at a non-statement position", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_STATEMENT_POSTEXE_END]              = { "unexpected an `END` at a non-statement position", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_STATEMENT_PREEXE_BEGIN]             = { "unexpected a `BEGIN` at a non-statement position", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_STATEMENT_UNDEF]                    = { "unexpected an `undef` at a non-statement position", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_STRING_CONCATENATION]               = { "expected a string for concatenation", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_STRING_INTERPOLATED_TERM]           = { "unterminated string; expected a closing delimiter for the interpolated string", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_STRING_LITERAL_EOF]                 = { "unterminated string meets end of file", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_STRING_LITERAL_TERM]                = { "unexpected %s, expected a string literal terminator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_SYMBOL_INVALID]                     = { "invalid symbol", PM_ERROR_LEVEL_SYNTAX }, // TODO expected symbol? prism.c ~9719
    [PM_ERR_SYMBOL_TERM_DYNAMIC]                = { "unterminated quoted string; expected a closing delimiter for the dynamic symbol", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_SYMBOL_TERM_INTERPOLATED]           = { "unterminated symbol; expected a closing delimiter for the interpolated symbol", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_TERNARY_COLON]                      = { "expected a `:` after the true expression of a ternary operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_TERNARY_EXPRESSION_FALSE]           = { "expected an expression after `:` in the ternary operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_TERNARY_EXPRESSION_TRUE]            = { "expected an expression after `?` in the ternary operator", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNARY_RECEIVER]                     = { "unexpected %s, expected a receiver for unary `%c`", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNARY_DISALLOWED]                   = { "unexpected %s; unary calls are not allowed in this context", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNDEF_ARGUMENT]                     = { "invalid argument being passed to `undef`; expected a bare word, constant, or symbol argument", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNEXPECTED_BLOCK_ARGUMENT]          = { "block argument should not be given", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNEXPECTED_INDEX_BLOCK]             = { "unexpected block arg given in index assignment; blocks are not allowed in index assignment expressions", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNEXPECTED_INDEX_KEYWORDS]          = { "unexpected keyword arg given in index assignment; keywords are not allowed in index assignment expressions", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNEXPECTED_LABEL]                   = { "unexpected label", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNEXPECTED_MULTI_WRITE]             = { "unexpected multiple assignment; multiple assignment is not allowed in this context", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNEXPECTED_RANGE_OPERATOR]          = { "unexpected range operator; .. and ... are non-associative and cannot be chained", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNEXPECTED_SAFE_NAVIGATION]         = { "&. inside multiple assignment destination", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNEXPECTED_TOKEN_CLOSE_CONTEXT]     = { "unexpected %s, assuming it is closing the parent %s", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNEXPECTED_TOKEN_IGNORE]            = { "unexpected %s, ignoring it", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_UNTIL_TERM]                         = { "expected an `end` to close the `until` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_VOID_EXPRESSION]                    = { "unexpected void value expression", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_WHILE_TERM]                         = { "expected an `end` to close the `while` statement", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_WRITE_TARGET_IN_METHOD]             = { "dynamic constant assignment", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_WRITE_TARGET_READONLY]              = { "Can't set variable %.*s", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_WRITE_TARGET_UNEXPECTED]            = { "unexpected write target", PM_ERROR_LEVEL_SYNTAX },
    [PM_ERR_XSTRING_TERM]                       = { "expected a closing delimiter for the `%x` or backtick string", PM_ERROR_LEVEL_SYNTAX },

    // Warnings
    [PM_WARN_AMBIGUOUS_BINARY_OPERATOR]         = { "'%s' after local variable or literal is interpreted as binary operator even though it seems like %s", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_AMBIGUOUS_FIRST_ARGUMENT_MINUS]    = { "ambiguous first argument; put parentheses or a space even after `-` operator", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_AMBIGUOUS_FIRST_ARGUMENT_PLUS]     = { "ambiguous first argument; put parentheses or a space even after `+` operator", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_AMBIGUOUS_PREFIX_AMPERSAND]        = { "ambiguous `&` has been interpreted as an argument prefix", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_AMBIGUOUS_PREFIX_STAR]             = { "ambiguous `*` has been interpreted as an argument prefix", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_AMBIGUOUS_PREFIX_STAR_STAR]        = { "ambiguous `**` has been interpreted as an argument prefix", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_AMBIGUOUS_SLASH]                   = { "ambiguous `/`; wrap regexp in parentheses or add a space after `/` operator", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_COMPARISON_AFTER_COMPARISON]       = { "comparison '%.*s' after comparison", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_DOT_DOT_DOT_EOL]                   = { "... at EOL, should be parenthesized?", PM_WARNING_LEVEL_DEFAULT },
    [PM_WARN_DUPLICATED_HASH_KEY]               = { "key %.*s is duplicated and overwritten on line %" PRIi32, PM_WARNING_LEVEL_DEFAULT },
    [PM_WARN_DUPLICATED_WHEN_CLAUSE]            = { "'when' clause on line %" PRIi32 " duplicates 'when' clause on line %" PRIi32 " and is ignored", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_EQUAL_IN_CONDITIONAL_3_3]          = { "found `= literal' in conditional, should be ==", PM_WARNING_LEVEL_DEFAULT },
    [PM_WARN_EQUAL_IN_CONDITIONAL]              = { "found '= literal' in conditional, should be ==", PM_WARNING_LEVEL_DEFAULT },
    [PM_WARN_END_IN_METHOD]                     = { "END in method; use at_exit", PM_WARNING_LEVEL_DEFAULT },
    [PM_WARN_FLOAT_OUT_OF_RANGE]                = { "Float %.*s%s out of range", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_IGNORED_FROZEN_STRING_LITERAL]     = { "'frozen_string_literal' is ignored after any tokens", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_INDENTATION_MISMATCH]              = { "mismatched indentations at '%.*s' with '%.*s' at %" PRIi32, PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_INTEGER_IN_FLIP_FLOP]              = { "integer literal in flip-flop", PM_WARNING_LEVEL_DEFAULT },
    [PM_WARN_INVALID_CHARACTER]                 = { "invalid character syntax; use %s%s%s", PM_WARNING_LEVEL_DEFAULT },
    [PM_WARN_INVALID_MAGIC_COMMENT_VALUE]       = { "invalid value for %.*s: %.*s", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_INVALID_NUMBERED_REFERENCE]        = { "'%.*s' is too big for a number variable, always nil", PM_WARNING_LEVEL_DEFAULT },
    [PM_WARN_KEYWORD_EOL]                       = { "`%.*s` at the end of line without an expression", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_LITERAL_IN_CONDITION_DEFAULT]      = { "%sliteral in %s", PM_WARNING_LEVEL_DEFAULT },
    [PM_WARN_LITERAL_IN_CONDITION_VERBOSE]      = { "%sliteral in %s", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_SHAREABLE_CONSTANT_VALUE_LINE]     = { "'shareable_constant_value' is ignored unless in comment-only line", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_SHEBANG_CARRIAGE_RETURN]           = { "shebang line ending with \\r may cause problems", PM_WARNING_LEVEL_DEFAULT },
    [PM_WARN_UNEXPECTED_CARRIAGE_RETURN]        = { "encountered \\r in middle of line, treated as a mere space", PM_WARNING_LEVEL_DEFAULT },
    [PM_WARN_UNREACHABLE_STATEMENT]             = { "statement not reached", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_UNUSED_LOCAL_VARIABLE]             = { "assigned but unused variable - %.*s", PM_WARNING_LEVEL_VERBOSE },
    [PM_WARN_VOID_STATEMENT]                    = { "possibly useless use of %.*s in void context", PM_WARNING_LEVEL_VERBOSE }
};

/**
 * Get the human-readable name of the given diagnostic ID.
 */
const char *
pm_diagnostic_id_human(pm_diagnostic_id_t diag_id) {
    switch (diag_id) {
        case PM_ERR_ALIAS_ARGUMENT: return "alias_argument";
        case PM_ERR_ALIAS_ARGUMENT_NUMBERED_REFERENCE: return "alias_argument_numbered_reference";
        case PM_ERR_AMPAMPEQ_MULTI_ASSIGN: return "ampampeq_multi_assign";
        case PM_ERR_ARGUMENT_AFTER_BLOCK: return "argument_after_block";
        case PM_ERR_ARGUMENT_AFTER_FORWARDING_ELLIPSES: return "argument_after_forwarding_ellipses";
        case PM_ERR_ARGUMENT_BARE_HASH: return "argument_bare_hash";
        case PM_ERR_ARGUMENT_BLOCK_FORWARDING: return "argument_block_forwarding";
        case PM_ERR_ARGUMENT_BLOCK_MULTI: return "argument_block_multi";
        case PM_ERR_ARGUMENT_CONFLICT_AMPERSAND: return "argument_conflict_ampersand";
        case PM_ERR_ARGUMENT_CONFLICT_STAR: return "argument_conflict_star";
        case PM_ERR_ARGUMENT_CONFLICT_STAR_STAR: return "argument_conflict_star_star";
        case PM_ERR_ARGUMENT_FORMAL_CLASS: return "argument_formal_class";
        case PM_ERR_ARGUMENT_FORMAL_CONSTANT: return "argument_formal_constant";
        case PM_ERR_ARGUMENT_FORMAL_GLOBAL: return "argument_formal_global";
        case PM_ERR_ARGUMENT_FORMAL_IVAR: return "argument_formal_ivar";
        case PM_ERR_ARGUMENT_FORWARDING_UNBOUND: return "argument_forwarding_unbound";
        case PM_ERR_ARGUMENT_NO_FORWARDING_AMPERSAND: return "argument_no_forwarding_ampersand";
        case PM_ERR_ARGUMENT_NO_FORWARDING_ELLIPSES: return "argument_no_forwarding_ellipses";
        case PM_ERR_ARGUMENT_NO_FORWARDING_STAR: return "argument_no_forwarding_star";
        case PM_ERR_ARGUMENT_NO_FORWARDING_STAR_STAR: return "argument_no_forwarding_star_star";
        case PM_ERR_ARGUMENT_SPLAT_AFTER_ASSOC_SPLAT: return "argument_splat_after_assoc_splat";
        case PM_ERR_ARGUMENT_SPLAT_AFTER_SPLAT: return "argument_splat_after_splat";
        case PM_ERR_ARGUMENT_TERM_PAREN: return "argument_term_paren";
        case PM_ERR_ARGUMENT_UNEXPECTED_BLOCK: return "argument_unexpected_block";
        case PM_ERR_ARRAY_ELEMENT: return "array_element";
        case PM_ERR_ARRAY_EXPRESSION: return "array_expression";
        case PM_ERR_ARRAY_EXPRESSION_AFTER_STAR: return "array_expression_after_star";
        case PM_ERR_ARRAY_SEPARATOR: return "array_separator";
        case PM_ERR_ARRAY_TERM: return "array_term";
        case PM_ERR_BEGIN_LONELY_ELSE: return "begin_lonely_else";
        case PM_ERR_BEGIN_TERM: return "begin_term";
        case PM_ERR_BEGIN_UPCASE_BRACE: return "begin_upcase_brace";
        case PM_ERR_BEGIN_UPCASE_TERM: return "begin_upcase_term";
        case PM_ERR_BEGIN_UPCASE_TOPLEVEL: return "begin_upcase_toplevel";
        case PM_ERR_BLOCK_PARAM_LOCAL_VARIABLE: return "block_param_local_variable";
        case PM_ERR_BLOCK_PARAM_PIPE_TERM: return "block_param_pipe_term";
        case PM_ERR_BLOCK_TERM_BRACE: return "block_term_brace";
        case PM_ERR_BLOCK_TERM_END: return "block_term_end";
        case PM_ERR_CANNOT_PARSE_EXPRESSION: return "cannot_parse_expression";
        case PM_ERR_CANNOT_PARSE_STRING_PART: return "cannot_parse_string_part";
        case PM_ERR_CASE_EXPRESSION_AFTER_CASE: return "case_expression_after_case";
        case PM_ERR_CASE_EXPRESSION_AFTER_WHEN: return "case_expression_after_when";
        case PM_ERR_CASE_MATCH_MISSING_PREDICATE: return "case_match_missing_predicate";
        case PM_ERR_CASE_MISSING_CONDITIONS: return "case_missing_conditions";
        case PM_ERR_CASE_TERM: return "case_term";
        case PM_ERR_CLASS_IN_METHOD: return "class_in_method";
        case PM_ERR_CLASS_NAME: return "class_name";
        case PM_ERR_CLASS_SUPERCLASS: return "class_superclass";
        case PM_ERR_CLASS_TERM: return "class_term";
        case PM_ERR_CLASS_UNEXPECTED_END: return "class_unexpected_end";
        case PM_ERR_CLASS_VARIABLE_BARE: return "class_variable_bare";
        case PM_ERR_CONDITIONAL_ELSIF_PREDICATE: return "conditional_elsif_predicate";
        case PM_ERR_CONDITIONAL_IF_PREDICATE: return "conditional_if_predicate";
        case PM_ERR_CONDITIONAL_PREDICATE_TERM: return "conditional_predicate_term";
        case PM_ERR_CONDITIONAL_TERM: return "conditional_term";
        case PM_ERR_CONDITIONAL_TERM_ELSE: return "conditional_term_else";
        case PM_ERR_CONDITIONAL_UNLESS_PREDICATE: return "conditional_unless_predicate";
        case PM_ERR_CONDITIONAL_UNTIL_PREDICATE: return "conditional_until_predicate";
        case PM_ERR_CONDITIONAL_WHILE_PREDICATE: return "conditional_while_predicate";
        case PM_ERR_CONSTANT_PATH_COLON_COLON_CONSTANT: return "constant_path_colon_colon_constant";
        case PM_ERR_DEF_ENDLESS: return "def_endless";
        case PM_ERR_DEF_ENDLESS_SETTER: return "def_endless_setter";
        case PM_ERR_DEF_NAME: return "def_name";
        case PM_ERR_DEF_PARAMS_TERM: return "def_params_term";
        case PM_ERR_DEF_PARAMS_TERM_PAREN: return "def_params_term_paren";
        case PM_ERR_DEF_RECEIVER: return "def_receiver";
        case PM_ERR_DEF_RECEIVER_TERM: return "def_receiver_term";
        case PM_ERR_DEF_TERM: return "def_term";
        case PM_ERR_DEFINED_EXPRESSION: return "defined_expression";
        case PM_ERR_EMBDOC_TERM: return "embdoc_term";
        case PM_ERR_EMBEXPR_END: return "embexpr_end";
        case PM_ERR_EMBVAR_INVALID: return "embvar_invalid";
        case PM_ERR_END_UPCASE_BRACE: return "end_upcase_brace";
        case PM_ERR_END_UPCASE_TERM: return "end_upcase_term";
        case PM_ERR_ESCAPE_INVALID_CONTROL: return "escape_invalid_control";
        case PM_ERR_ESCAPE_INVALID_CONTROL_REPEAT: return "escape_invalid_control_repeat";
        case PM_ERR_ESCAPE_INVALID_HEXADECIMAL: return "escape_invalid_hexadecimal";
        case PM_ERR_ESCAPE_INVALID_META: return "escape_invalid_meta";
        case PM_ERR_ESCAPE_INVALID_META_REPEAT: return "escape_invalid_meta_repeat";
        case PM_ERR_ESCAPE_INVALID_UNICODE: return "escape_invalid_unicode";
        case PM_ERR_ESCAPE_INVALID_UNICODE_CM_FLAGS: return "escape_invalid_unicode_cm_flags";
        case PM_ERR_ESCAPE_INVALID_UNICODE_LIST: return "escape_invalid_unicode_list";
        case PM_ERR_ESCAPE_INVALID_UNICODE_LITERAL: return "escape_invalid_unicode_literal";
        case PM_ERR_ESCAPE_INVALID_UNICODE_LONG: return "escape_invalid_unicode_long";
        case PM_ERR_ESCAPE_INVALID_UNICODE_SHORT: return "escape_invalid_unicode_short";
        case PM_ERR_ESCAPE_INVALID_UNICODE_TERM: return "escape_invalid_unicode_term";
        case PM_ERR_EXPECT_ARGUMENT: return "expect_argument";
        case PM_ERR_EXPECT_EOL_AFTER_STATEMENT: return "expect_eol_after_statement";
        case PM_ERR_EXPECT_EXPRESSION_AFTER_AMPAMPEQ: return "expect_expression_after_ampampeq";
        case PM_ERR_EXPECT_EXPRESSION_AFTER_COMMA: return "expect_expression_after_comma";
        case PM_ERR_EXPECT_EXPRESSION_AFTER_EQUAL: return "expect_expression_after_equal";
        case PM_ERR_EXPECT_EXPRESSION_AFTER_LESS_LESS: return "expect_expression_after_less_less";
        case PM_ERR_EXPECT_EXPRESSION_AFTER_LPAREN: return "expect_expression_after_lparen";
        case PM_ERR_EXPECT_EXPRESSION_AFTER_OPERATOR: return "expect_expression_after_operator";
        case PM_ERR_EXPECT_EXPRESSION_AFTER_PIPEPIPEEQ: return "expect_expression_after_pipepipeeq";
        case PM_ERR_EXPECT_EXPRESSION_AFTER_QUESTION: return "expect_expression_after_question";
        case PM_ERR_EXPECT_EXPRESSION_AFTER_SPLAT: return "expect_expression_after_splat";
        case PM_ERR_EXPECT_EXPRESSION_AFTER_SPLAT_HASH: return "expect_expression_after_splat_hash";
        case PM_ERR_EXPECT_EXPRESSION_AFTER_STAR: return "expect_expression_after_star";
        case PM_ERR_EXPECT_FOR_DELIMITER: return "expect_for_delimiter";
        case PM_ERR_EXPECT_IDENT_REQ_PARAMETER: return "expect_ident_req_parameter";
        case PM_ERR_EXPECT_IN_DELIMITER: return "expect_in_delimiter";
        case PM_ERR_EXPECT_LPAREN_REQ_PARAMETER: return "expect_lparen_req_parameter";
        case PM_ERR_EXPECT_MESSAGE: return "expect_message";
        case PM_ERR_EXPECT_RBRACKET: return "expect_rbracket";
        case PM_ERR_EXPECT_RPAREN: return "expect_rparen";
        case PM_ERR_EXPECT_RPAREN_AFTER_MULTI: return "expect_rparen_after_multi";
        case PM_ERR_EXPECT_RPAREN_REQ_PARAMETER: return "expect_rparen_req_parameter";
        case PM_ERR_EXPECT_SINGLETON_CLASS_DELIMITER: return "expect_singleton_class_delimiter";
        case PM_ERR_EXPECT_STRING_CONTENT: return "expect_string_content";
        case PM_ERR_EXPECT_WHEN_DELIMITER: return "expect_when_delimiter";
        case PM_ERR_EXPRESSION_BARE_HASH: return "expression_bare_hash";
        case PM_ERR_EXPRESSION_NOT_WRITABLE: return "expression_not_writable";
        case PM_ERR_EXPRESSION_NOT_WRITABLE_ENCODING: return "expression_not_writable_encoding";
        case PM_ERR_EXPRESSION_NOT_WRITABLE_FALSE: return "expression_not_writable_false";
        case PM_ERR_EXPRESSION_NOT_WRITABLE_FILE: return "expression_not_writable_file";
        case PM_ERR_EXPRESSION_NOT_WRITABLE_LINE: return "expression_not_writable_line";
        case PM_ERR_EXPRESSION_NOT_WRITABLE_NIL: return "expression_not_writable_nil";
        case PM_ERR_EXPRESSION_NOT_WRITABLE_NUMBERED: return "expression_not_writable_numbered";
        case PM_ERR_EXPRESSION_NOT_WRITABLE_SELF: return "expression_not_writable_self";
        case PM_ERR_EXPRESSION_NOT_WRITABLE_TRUE: return "expression_not_writable_true";
        case PM_ERR_FLOAT_PARSE: return "float_parse";
        case PM_ERR_FOR_COLLECTION: return "for_collection";
        case PM_ERR_FOR_IN: return "for_in";
        case PM_ERR_FOR_INDEX: return "for_index";
        case PM_ERR_FOR_TERM: return "for_term";
        case PM_ERR_GLOBAL_VARIABLE_BARE: return "global_variable_bare";
        case PM_ERR_HASH_EXPRESSION_AFTER_LABEL: return "hash_expression_after_label";
        case PM_ERR_HASH_KEY: return "hash_key";
        case PM_ERR_HASH_ROCKET: return "hash_rocket";
        case PM_ERR_HASH_TERM: return "hash_term";
        case PM_ERR_HASH_VALUE: return "hash_value";
        case PM_ERR_HEREDOC_IDENTIFIER: return "heredoc_identifier";
        case PM_ERR_HEREDOC_TERM: return "heredoc_term";
        case PM_ERR_INCOMPLETE_QUESTION_MARK: return "incomplete_question_mark";
        case PM_ERR_INCOMPLETE_VARIABLE_CLASS: return "incomplete_variable_class";
        case PM_ERR_INCOMPLETE_VARIABLE_CLASS_3_3: return "incomplete_variable_class_3_3";
        case PM_ERR_INCOMPLETE_VARIABLE_INSTANCE: return "incomplete_variable_instance";
        case PM_ERR_INCOMPLETE_VARIABLE_INSTANCE_3_3: return "incomplete_variable_instance_3_3";
        case PM_ERR_INSTANCE_VARIABLE_BARE: return "instance_variable_bare";
        case PM_ERR_INVALID_BLOCK_EXIT: return "invalid_block_exit";
        case PM_ERR_INVALID_CHARACTER: return "invalid_character";
        case PM_ERR_INVALID_COMMA: return "invalid_comma";
        case PM_ERR_INVALID_ENCODING_MAGIC_COMMENT: return "invalid_encoding_magic_comment";
        case PM_ERR_INVALID_ESCAPE_CHARACTER: return "invalid_escape_character";
        case PM_ERR_INVALID_FLOAT_EXPONENT: return "invalid_float_exponent";
        case PM_ERR_INVALID_LOCAL_VARIABLE_READ: return "invalid_local_variable_read";
        case PM_ERR_INVALID_LOCAL_VARIABLE_WRITE: return "invalid_local_variable_write";
        case PM_ERR_INVALID_MULTIBYTE_CHAR: return "invalid_multibyte_char";
        case PM_ERR_INVALID_MULTIBYTE_CHARACTER: return "invalid_multibyte_character";
        case PM_ERR_INVALID_MULTIBYTE_ESCAPE: return "invalid_multibyte_escape";
        case PM_ERR_INVALID_NUMBER_BINARY: return "invalid_number_binary";
        case PM_ERR_INVALID_NUMBER_DECIMAL: return "invalid_number_decimal";
        case PM_ERR_INVALID_NUMBER_FRACTION: return "invalid_number_fraction";
        case PM_ERR_INVALID_NUMBER_HEXADECIMAL: return "invalid_number_hexadecimal";
        case PM_ERR_INVALID_NUMBER_OCTAL: return "invalid_number_octal";
        case PM_ERR_INVALID_NUMBER_UNDERSCORE_INNER: return "invalid_number_underscore_inner";
        case PM_ERR_INVALID_NUMBER_UNDERSCORE_TRAILING: return "invalid_number_underscore_trailing";
        case PM_ERR_INVALID_PERCENT: return "invalid_percent";
        case PM_ERR_INVALID_PERCENT_EOF: return "invalid_percent_eof";
        case PM_ERR_INVALID_PRINTABLE_CHARACTER: return "invalid_printable_character";
        case PM_ERR_INVALID_RETRY_AFTER_ELSE: return "invalid_retry_after_else";
        case PM_ERR_INVALID_RETRY_AFTER_ENSURE: return "invalid_retry_after_ensure";
        case PM_ERR_INVALID_RETRY_WITHOUT_RESCUE: return "invalid_retry_without_rescue";
        case PM_ERR_INVALID_SYMBOL: return "invalid_symbol";
        case PM_ERR_INVALID_VARIABLE_GLOBAL: return "invalid_variable_global";
        case PM_ERR_INVALID_VARIABLE_GLOBAL_3_3: return "invalid_variable_global_3_3";
        case PM_ERR_INVALID_YIELD: return "invalid_yield";
        case PM_ERR_IT_NOT_ALLOWED_NUMBERED: return "it_not_allowed_numbered";
        case PM_ERR_IT_NOT_ALLOWED_ORDINARY: return "it_not_allowed_ordinary";
        case PM_ERR_LAMBDA_OPEN: return "lambda_open";
        case PM_ERR_LAMBDA_TERM_BRACE: return "lambda_term_brace";
        case PM_ERR_LAMBDA_TERM_END: return "lambda_term_end";
        case PM_ERR_LIST_I_LOWER_ELEMENT: return "list_i_lower_element";
        case PM_ERR_LIST_I_LOWER_TERM: return "list_i_lower_term";
        case PM_ERR_LIST_I_UPPER_ELEMENT: return "list_i_upper_element";
        case PM_ERR_LIST_I_UPPER_TERM: return "list_i_upper_term";
        case PM_ERR_LIST_W_LOWER_ELEMENT: return "list_w_lower_element";
        case PM_ERR_LIST_W_LOWER_TERM: return "list_w_lower_term";
        case PM_ERR_LIST_W_UPPER_ELEMENT: return "list_w_upper_element";
        case PM_ERR_LIST_W_UPPER_TERM: return "list_w_upper_term";
        case PM_ERR_MALLOC_FAILED: return "malloc_failed";
        case PM_ERR_MIXED_ENCODING: return "mixed_encoding";
        case PM_ERR_MODULE_IN_METHOD: return "module_in_method";
        case PM_ERR_MODULE_NAME: return "module_name";
        case PM_ERR_MODULE_TERM: return "module_term";
        case PM_ERR_MULTI_ASSIGN_MULTI_SPLATS: return "multi_assign_multi_splats";
        case PM_ERR_MULTI_ASSIGN_UNEXPECTED_REST: return "multi_assign_unexpected_rest";
        case PM_ERR_NESTING_TOO_DEEP: return "nesting_too_deep";
        case PM_ERR_NO_LOCAL_VARIABLE: return "no_local_variable";
        case PM_ERR_NON_ASSOCIATIVE_OPERATOR: return "non_associative_operator";
        case PM_ERR_NOT_EXPRESSION: return "not_expression";
        case PM_ERR_NUMBER_LITERAL_UNDERSCORE: return "number_literal_underscore";
        case PM_ERR_NUMBERED_PARAMETER_INNER_BLOCK: return "numbered_parameter_inner_block";
        case PM_ERR_NUMBERED_PARAMETER_IT: return "numbered_parameter_it";
        case PM_ERR_NUMBERED_PARAMETER_ORDINARY: return "numbered_parameter_ordinary";
        case PM_ERR_NUMBERED_PARAMETER_OUTER_BLOCK: return "numbered_parameter_outer_block";
        case PM_ERR_OPERATOR_MULTI_ASSIGN: return "operator_multi_assign";
        case PM_ERR_OPERATOR_WRITE_ARGUMENTS: return "operator_write_arguments";
        case PM_ERR_OPERATOR_WRITE_BLOCK: return "operator_write_block";
        case PM_ERR_PARAMETER_ASSOC_SPLAT_MULTI: return "parameter_assoc_splat_multi";
        case PM_ERR_PARAMETER_BLOCK_MULTI: return "parameter_block_multi";
        case PM_ERR_PARAMETER_CIRCULAR: return "parameter_circular";
        case PM_ERR_PARAMETER_FORWARDING_AFTER_REST: return "parameter_forwarding_after_rest";
        case PM_ERR_PARAMETER_METHOD_NAME: return "parameter_method_name";
        case PM_ERR_PARAMETER_NAME_DUPLICATED: return "parameter_name_duplicated";
        case PM_ERR_PARAMETER_NO_DEFAULT: return "parameter_no_default";
        case PM_ERR_PARAMETER_NO_DEFAULT_KW: return "parameter_no_default_kw";
        case PM_ERR_PARAMETER_NUMBERED_RESERVED: return "parameter_numbered_reserved";
        case PM_ERR_PARAMETER_ORDER: return "parameter_order";
        case PM_ERR_PARAMETER_SPLAT_MULTI: return "parameter_splat_multi";
        case PM_ERR_PARAMETER_STAR: return "parameter_star";
        case PM_ERR_PARAMETER_UNEXPECTED_FWD: return "parameter_unexpected_fwd";
        case PM_ERR_PARAMETER_UNEXPECTED_NO_KW: return "parameter_unexpected_no_kw";
        case PM_ERR_PARAMETER_WILD_LOOSE_COMMA: return "parameter_wild_loose_comma";
        case PM_ERR_PATTERN_ARRAY_MULTIPLE_RESTS: return "pattern_array_multiple_rests";
        case PM_ERR_PATTERN_CAPTURE_DUPLICATE: return "pattern_capture_duplicate";
        case PM_ERR_PATTERN_EXPRESSION_AFTER_BRACKET: return "pattern_expression_after_bracket";
        case PM_ERR_PATTERN_EXPRESSION_AFTER_COMMA: return "pattern_expression_after_comma";
        case PM_ERR_PATTERN_EXPRESSION_AFTER_HROCKET: return "pattern_expression_after_hrocket";
        case PM_ERR_PATTERN_EXPRESSION_AFTER_IN: return "pattern_expression_after_in";
        case PM_ERR_PATTERN_EXPRESSION_AFTER_KEY: return "pattern_expression_after_key";
        case PM_ERR_PATTERN_EXPRESSION_AFTER_PAREN: return "pattern_expression_after_paren";
        case PM_ERR_PATTERN_EXPRESSION_AFTER_PIN: return "pattern_expression_after_pin";
        case PM_ERR_PATTERN_EXPRESSION_AFTER_PIPE: return "pattern_expression_after_pipe";
        case PM_ERR_PATTERN_EXPRESSION_AFTER_RANGE: return "pattern_expression_after_range";
        case PM_ERR_PATTERN_EXPRESSION_AFTER_REST: return "pattern_expression_after_rest";
        case PM_ERR_PATTERN_FIND_MISSING_INNER: return "pattern_find_missing_inner";
        case PM_ERR_PATTERN_HASH_IMPLICIT: return "pattern_hash_implicit";
        case PM_ERR_PATTERN_HASH_KEY: return "pattern_hash_key";
        case PM_ERR_PATTERN_HASH_KEY_DUPLICATE: return "pattern_hash_key_duplicate";
        case PM_ERR_PATTERN_HASH_KEY_INTERPOLATED: return "pattern_hash_key_interpolated";
        case PM_ERR_PATTERN_HASH_KEY_LABEL: return "pattern_hash_key_label";
        case PM_ERR_PATTERN_HASH_KEY_LOCALS: return "pattern_hash_key_locals";
        case PM_ERR_PATTERN_IDENT_AFTER_HROCKET: return "pattern_ident_after_hrocket";
        case PM_ERR_PATTERN_LABEL_AFTER_COMMA: return "pattern_label_after_comma";
        case PM_ERR_PATTERN_REST: return "pattern_rest";
        case PM_ERR_PATTERN_TERM_BRACE: return "pattern_term_brace";
        case PM_ERR_PATTERN_TERM_BRACKET: return "pattern_term_bracket";
        case PM_ERR_PATTERN_TERM_PAREN: return "pattern_term_paren";
        case PM_ERR_PIPEPIPEEQ_MULTI_ASSIGN: return "pipepipeeq_multi_assign";
        case PM_ERR_REGEXP_ENCODING_OPTION_MISMATCH: return "regexp_encoding_option_mismatch";
        case PM_ERR_REGEXP_INCOMPAT_CHAR_ENCODING: return "regexp_incompat_char_encoding";
        case PM_ERR_REGEXP_INVALID_UNICODE_RANGE: return "regexp_invalid_unicode_range";
        case PM_ERR_REGEXP_NON_ESCAPED_MBC: return "regexp_non_escaped_mbc";
        case PM_ERR_REGEXP_PARSE_ERROR: return "regexp_parse_error";
        case PM_ERR_REGEXP_TERM: return "regexp_term";
        case PM_ERR_REGEXP_UNKNOWN_OPTIONS: return "regexp_unknown_options";
        case PM_ERR_REGEXP_UTF8_CHAR_NON_UTF8_REGEXP: return "regexp_utf8_char_non_utf8_regexp";
        case PM_ERR_RESCUE_EXPRESSION: return "rescue_expression";
        case PM_ERR_RESCUE_MODIFIER_VALUE: return "rescue_modifier_value";
        case PM_ERR_RESCUE_TERM: return "rescue_term";
        case PM_ERR_RESCUE_VARIABLE: return "rescue_variable";
        case PM_ERR_RETURN_INVALID: return "return_invalid";
        case PM_ERR_SCRIPT_NOT_FOUND: return "script_not_found";
        case PM_ERR_SINGLETON_FOR_LITERALS: return "singleton_for_literals";
        case PM_ERR_STATEMENT_ALIAS: return "statement_alias";
        case PM_ERR_STATEMENT_POSTEXE_END: return "statement_postexe_end";
        case PM_ERR_STATEMENT_PREEXE_BEGIN: return "statement_preexe_begin";
        case PM_ERR_STATEMENT_UNDEF: return "statement_undef";
        case PM_ERR_STRING_CONCATENATION: return "string_concatenation";
        case PM_ERR_STRING_INTERPOLATED_TERM: return "string_interpolated_term";
        case PM_ERR_STRING_LITERAL_EOF: return "string_literal_eof";
        case PM_ERR_STRING_LITERAL_TERM: return "string_literal_term";
        case PM_ERR_SYMBOL_INVALID: return "symbol_invalid";
        case PM_ERR_SYMBOL_TERM_DYNAMIC: return "symbol_term_dynamic";
        case PM_ERR_SYMBOL_TERM_INTERPOLATED: return "symbol_term_interpolated";
        case PM_ERR_TERNARY_COLON: return "ternary_colon";
        case PM_ERR_TERNARY_EXPRESSION_FALSE: return "ternary_expression_false";
        case PM_ERR_TERNARY_EXPRESSION_TRUE: return "ternary_expression_true";
        case PM_ERR_UNARY_DISALLOWED: return "unary_disallowed";
        case PM_ERR_UNARY_RECEIVER: return "unary_receiver";
        case PM_ERR_UNDEF_ARGUMENT: return "undef_argument";
        case PM_ERR_UNEXPECTED_BLOCK_ARGUMENT: return "unexpected_block_argument";
        case PM_ERR_UNEXPECTED_INDEX_BLOCK: return "unexpected_index_block";
        case PM_ERR_UNEXPECTED_INDEX_KEYWORDS: return "unexpected_index_keywords";
        case PM_ERR_UNEXPECTED_LABEL: return "unexpected_label";
        case PM_ERR_UNEXPECTED_MULTI_WRITE: return "unexpected_multi_write";
        case PM_ERR_UNEXPECTED_RANGE_OPERATOR: return "unexpected_range_operator";
        case PM_ERR_UNEXPECTED_SAFE_NAVIGATION: return "unexpected_safe_navigation";
        case PM_ERR_UNEXPECTED_TOKEN_CLOSE_CONTEXT: return "unexpected_token_close_context";
        case PM_ERR_UNEXPECTED_TOKEN_IGNORE: return "unexpected_token_ignore";
        case PM_ERR_UNTIL_TERM: return "until_term";
        case PM_ERR_VOID_EXPRESSION: return "void_expression";
        case PM_ERR_WHILE_TERM: return "while_term";
        case PM_ERR_WRITE_TARGET_IN_METHOD: return "write_target_in_method";
        case PM_ERR_WRITE_TARGET_READONLY: return "write_target_readonly";
        case PM_ERR_WRITE_TARGET_UNEXPECTED: return "write_target_unexpected";
        case PM_ERR_XSTRING_TERM: return "xstring_term";
        case PM_WARN_AMBIGUOUS_BINARY_OPERATOR: return "ambiguous_binary_operator";
        case PM_WARN_AMBIGUOUS_FIRST_ARGUMENT_MINUS: return "ambiguous_first_argument_minus";
        case PM_WARN_AMBIGUOUS_FIRST_ARGUMENT_PLUS: return "ambiguous_first_argument_plus";
        case PM_WARN_AMBIGUOUS_PREFIX_AMPERSAND: return "ambiguous_prefix_ampersand";
        case PM_WARN_AMBIGUOUS_PREFIX_STAR: return "ambiguous_prefix_star";
        case PM_WARN_AMBIGUOUS_PREFIX_STAR_STAR: return "ambiguous_prefix_star_star";
        case PM_WARN_AMBIGUOUS_SLASH: return "ambiguous_slash";
        case PM_WARN_COMPARISON_AFTER_COMPARISON: return "comparison_after_comparison";
        case PM_WARN_DOT_DOT_DOT_EOL: return "dot_dot_dot_eol";
        case PM_WARN_EQUAL_IN_CONDITIONAL: return "equal_in_conditional";
        case PM_WARN_EQUAL_IN_CONDITIONAL_3_3: return "equal_in_conditional_3_3";
        case PM_WARN_END_IN_METHOD: return "end_in_method";
        case PM_WARN_DUPLICATED_HASH_KEY: return "duplicated_hash_key";
        case PM_WARN_DUPLICATED_WHEN_CLAUSE: return "duplicated_when_clause";
        case PM_WARN_FLOAT_OUT_OF_RANGE: return "float_out_of_range";
        case PM_WARN_IGNORED_FROZEN_STRING_LITERAL: return "ignored_frozen_string_literal";
        case PM_WARN_INDENTATION_MISMATCH: return "indentation_mismatch";
        case PM_WARN_INTEGER_IN_FLIP_FLOP: return "integer_in_flip_flop";
        case PM_WARN_INVALID_CHARACTER: return "invalid_character";
        case PM_WARN_INVALID_MAGIC_COMMENT_VALUE: return "invalid_magic_comment_value";
        case PM_WARN_INVALID_NUMBERED_REFERENCE: return "invalid_numbered_reference";
        case PM_WARN_KEYWORD_EOL: return "keyword_eol";
        case PM_WARN_LITERAL_IN_CONDITION_DEFAULT: return "literal_in_condition_default";
        case PM_WARN_LITERAL_IN_CONDITION_VERBOSE: return "literal_in_condition_verbose";
        case PM_WARN_SHAREABLE_CONSTANT_VALUE_LINE: return "shareable_constant_value_line";
        case PM_WARN_SHEBANG_CARRIAGE_RETURN: return "shebang_carriage_return";
        case PM_WARN_UNEXPECTED_CARRIAGE_RETURN: return "unexpected_carriage_return";
        case PM_WARN_UNREACHABLE_STATEMENT: return "unreachable_statement";
        case PM_WARN_UNUSED_LOCAL_VARIABLE: return "unused_local_variable";
        case PM_WARN_VOID_STATEMENT: return "void_statement";
    }

    assert(false && "unreachable");
    return "";
}

static inline const char *
pm_diagnostic_message(pm_diagnostic_id_t diag_id) {
    assert(diag_id < PM_DIAGNOSTIC_ID_MAX);

    const char *message = diagnostic_messages[diag_id].message;
    assert(message);

    return message;
}

static inline uint8_t
pm_diagnostic_level(pm_diagnostic_id_t diag_id) {
    assert(diag_id < PM_DIAGNOSTIC_ID_MAX);

    return (uint8_t) diagnostic_messages[diag_id].level;
}

/**
 * Append an error to the given list of diagnostic.
 */
bool
pm_diagnostic_list_append(pm_list_t *list, const uint8_t *start, const uint8_t *end, pm_diagnostic_id_t diag_id) {
    pm_diagnostic_t *diagnostic = (pm_diagnostic_t *) xcalloc(1, sizeof(pm_diagnostic_t));
    if (diagnostic == NULL) return false;

    *diagnostic = (pm_diagnostic_t) {
        .location = { start, end },
        .diag_id = diag_id,
        .message = pm_diagnostic_message(diag_id),
        .owned = false,
        .level = pm_diagnostic_level(diag_id)
    };

    pm_list_append(list, (pm_list_node_t *) diagnostic);
    return true;
}

/**
 * Append a diagnostic to the given list of diagnostics that is using a format
 * string for its message.
 */
bool
pm_diagnostic_list_append_format(pm_list_t *list, const uint8_t *start, const uint8_t *end, pm_diagnostic_id_t diag_id, ...) {
    va_list arguments;
    va_start(arguments, diag_id);

    const char *format = pm_diagnostic_message(diag_id);
    int result = vsnprintf(NULL, 0, format, arguments);
    va_end(arguments);

    if (result < 0) {
        return false;
    }

    pm_diagnostic_t *diagnostic = (pm_diagnostic_t *) xcalloc(1, sizeof(pm_diagnostic_t));
    if (diagnostic == NULL) {
        return false;
    }

    size_t length = (size_t) (result + 1);
    char *message = (char *) xmalloc(length);
    if (message == NULL) {
        xfree(diagnostic);
        return false;
    }

    va_start(arguments, diag_id);
    vsnprintf(message, length, format, arguments);
    va_end(arguments);

    *diagnostic = (pm_diagnostic_t) {
        .location = { start, end },
        .diag_id = diag_id,
        .message = message,
        .owned = true,
        .level = pm_diagnostic_level(diag_id)
    };

    pm_list_append(list, (pm_list_node_t *) diagnostic);
    return true;
}

/**
 * Deallocate the internal state of the given diagnostic list.
 */
void
pm_diagnostic_list_free(pm_list_t *list) {
    pm_diagnostic_t *node = (pm_diagnostic_t *) list->head;

    while (node != NULL) {
        pm_diagnostic_t *next = (pm_diagnostic_t *) node->node.next;

        if (node->owned) xfree((void *) node->message);
        xfree(node);

        node = next;
    }
}
