/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;

public interface ResourceStore {
    default public Resource create(ResourceServer resourceServer, String name, String owner) {
        return this.create(resourceServer, null, name, owner);
    }

    public Resource create(ResourceServer var1, String var2, String var3, String var4);

    public void delete(String var1);

    public Resource findById(ResourceServer var1, String var2);

    default public List<Resource> findByOwner(ResourceServer resourceServer, String ownerId) {
        LinkedList<Resource> list = new LinkedList<Resource>();
        this.findByOwner(resourceServer, ownerId, list::add);
        return list;
    }

    public void findByOwner(ResourceServer var1, String var2, Consumer<Resource> var3);

    public List<Resource> findByResourceServer(ResourceServer var1);

    public List<Resource> find(ResourceServer var1, Map<Resource.FilterOption, String[]> var2, Integer var3, Integer var4);

    default public List<Resource> findByScopes(ResourceServer resourceServer, Set<Scope> scopes) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        this.findByScopes(resourceServer, scopes, result::add);
        return result;
    }

    public void findByScopes(ResourceServer var1, Set<Scope> var2, Consumer<Resource> var3);

    default public Resource findByName(ResourceServer resourceServer, String name) {
        return this.findByName(resourceServer, name, resourceServer.getClientId());
    }

    public Resource findByName(ResourceServer var1, String var2, String var3);

    default public List<Resource> findByType(ResourceServer resourceServer, String type) {
        LinkedList<Resource> list = new LinkedList<Resource>();
        this.findByType(resourceServer, type, list::add);
        return list;
    }

    public void findByType(ResourceServer var1, String var2, Consumer<Resource> var3);

    public void findByType(ResourceServer var1, String var2, String var3, Consumer<Resource> var4);

    public void findByTypeInstance(ResourceServer var1, String var2, Consumer<Resource> var3);
}

