/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.partialimport.ClientRolesPartialImport;
import org.keycloak.partialimport.PartialImport;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.partialimport.RealmRolesPartialImport;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ServicesLogger;

public class RolesPartialImport
implements PartialImport<RolesRepresentation> {
    private Set<RoleRepresentation> realmRolesToOverwrite;
    private Set<RoleRepresentation> realmRolesToSkip;
    private Map<String, Set<RoleRepresentation>> clientRolesToOverwrite;
    private Map<String, Set<RoleRepresentation>> clientRolesToSkip;
    private final RealmRolesPartialImport realmRolesPI = new RealmRolesPartialImport();
    private final ClientRolesPartialImport clientRolesPI = new ClientRolesPartialImport();
    private RoleRepresentation newDefaultRole;

    @Override
    public void prepare(PartialImportRepresentation rep, RealmModel realm, KeycloakSession session) {
        this.prepareRealmRoles(rep, realm, session);
        this.prepareClientRoles(rep, realm, session);
    }

    private void prepareRealmRoles(PartialImportRepresentation rep, RealmModel realm, KeycloakSession session) {
        if (!rep.hasRealmRoles()) {
            return;
        }
        this.realmRolesPI.prepare(rep, realm, session);
        this.realmRolesToOverwrite = this.realmRolesPI.getToOverwrite();
        if (this.realmRolesToOverwrite.size() > 0) {
            String defaultRoleName = realm.getDefaultRole().getName();
            for (RoleRepresentation representation : this.realmRolesToOverwrite) {
                if (!Objects.equals(defaultRoleName, representation.getName())) continue;
                this.newDefaultRole = representation;
                break;
            }
        }
        this.realmRolesToSkip = this.realmRolesPI.getToSkip();
    }

    private void prepareClientRoles(PartialImportRepresentation rep, RealmModel realm, KeycloakSession session) {
        if (!rep.hasClientRoles()) {
            return;
        }
        this.clientRolesPI.prepare(rep, realm, session);
        this.clientRolesToOverwrite = this.clientRolesPI.getToOverwrite();
        this.clientRolesToSkip = this.clientRolesPI.getToSkip();
    }

    @Override
    public void removeOverwrites(RealmModel realm, KeycloakSession session) {
        this.deleteClientRoleOverwrites(realm);
        this.deleteRealmRoleOverwrites(realm, session);
    }

    @Override
    public PartialImportResults doImport(PartialImportRepresentation rep, RealmModel realm, KeycloakSession session) {
        PartialImportResults results = new PartialImportResults();
        if (!rep.hasRealmRoles() && !rep.hasClientRoles()) {
            return results;
        }
        this.removeRealmRoleSkips(results, rep, realm, session);
        this.removeClientRoleSkips(results, rep, realm);
        if (rep.hasRealmRoles()) {
            this.setUniqueIds(rep.getRoles().getRealm());
        }
        if (rep.hasClientRoles()) {
            this.setUniqueIds(rep.getRoles().getClient());
        }
        if (this.newDefaultRole != null) {
            RoleModel defaultRole = RepresentationToModel.createRole((RealmModel)realm, (RoleRepresentation)this.newDefaultRole);
            realm.setDefaultRole(defaultRole);
        }
        try {
            RepresentationToModel.importRoles((RolesRepresentation)rep.getRoles(), (RealmModel)realm);
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.roleImportError(e);
            throw ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.realmRoleAdds(results, rep, realm, session);
        this.clientRoleAdds(results, rep, realm);
        this.addResultsForOverwrittenRealmRoles(results, realm, session);
        this.addResultsForOverwrittenClientRoles(results, realm);
        return results;
    }

    private void setUniqueIds(List<RoleRepresentation> realmRoles) {
        for (RoleRepresentation realmRole : realmRoles) {
            realmRole.setId(KeycloakModelUtils.generateId());
        }
    }

    private void setUniqueIds(Map<String, List<RoleRepresentation>> clientRoles) {
        for (String clientId : clientRoles.keySet()) {
            for (RoleRepresentation clientRole : clientRoles.get(clientId)) {
                clientRole.setId(KeycloakModelUtils.generateId());
            }
        }
    }

    private void removeRealmRoleSkips(PartialImportResults results, PartialImportRepresentation rep, RealmModel realm, KeycloakSession session) {
        if (this.isEmpty(this.realmRolesToSkip)) {
            return;
        }
        for (RoleRepresentation roleRep : this.realmRolesToSkip) {
            rep.getRoles().getRealm().remove(roleRep);
            String modelId = this.realmRolesPI.getModelId(realm, session, roleRep);
            results.addResult(this.realmRolesPI.skipped(modelId, roleRep));
        }
    }

    private void removeClientRoleSkips(PartialImportResults results, PartialImportRepresentation rep, RealmModel realm) {
        if (this.isEmpty(this.clientRolesToSkip)) {
            return;
        }
        for (String clientId : this.clientRolesToSkip.keySet()) {
            for (RoleRepresentation roleRep : this.clientRolesToSkip.get(clientId)) {
                ((List)rep.getRoles().getClient().get(clientId)).remove(roleRep);
                String modelId = this.clientRolesPI.getModelId(realm, clientId);
                results.addResult(this.clientRolesPI.skipped(clientId, modelId, roleRep));
            }
        }
    }

    private void deleteRealmRoleOverwrites(RealmModel realm, KeycloakSession session) {
        if (this.isEmpty(this.realmRolesToOverwrite)) {
            return;
        }
        for (RoleRepresentation roleRep : this.realmRolesToOverwrite) {
            this.realmRolesPI.remove(realm, session, roleRep);
        }
    }

    private void addResultsForOverwrittenRealmRoles(PartialImportResults results, RealmModel realm, KeycloakSession session) {
        if (this.isEmpty(this.realmRolesToOverwrite)) {
            return;
        }
        for (RoleRepresentation roleRep : this.realmRolesToOverwrite) {
            String modelId = this.realmRolesPI.getModelId(realm, session, roleRep);
            results.addResult(this.realmRolesPI.overwritten(modelId, roleRep));
        }
    }

    private void deleteClientRoleOverwrites(RealmModel realm) {
        if (this.isEmpty(this.clientRolesToOverwrite)) {
            return;
        }
        for (String clientId : this.clientRolesToOverwrite.keySet()) {
            for (RoleRepresentation roleRep : this.clientRolesToOverwrite.get(clientId)) {
                this.clientRolesPI.deleteRole(realm, clientId, roleRep);
            }
        }
    }

    private void addResultsForOverwrittenClientRoles(PartialImportResults results, RealmModel realm) {
        if (this.isEmpty(this.clientRolesToOverwrite)) {
            return;
        }
        for (String clientId : this.clientRolesToOverwrite.keySet()) {
            for (RoleRepresentation roleRep : this.clientRolesToOverwrite.get(clientId)) {
                String modelId = this.clientRolesPI.getModelId(realm, clientId);
                results.addResult(this.clientRolesPI.overwritten(clientId, modelId, roleRep));
            }
        }
    }

    private boolean isEmpty(Set set) {
        return set == null || set.isEmpty();
    }

    private boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    private void realmRoleAdds(PartialImportResults results, PartialImportRepresentation rep, RealmModel realm, KeycloakSession session) {
        if (!rep.hasRealmRoles()) {
            return;
        }
        for (RoleRepresentation roleRep : rep.getRoles().getRealm()) {
            if (this.realmRolesToOverwrite.contains(roleRep) || this.realmRolesToSkip.contains(roleRep)) continue;
            String modelId = this.realmRolesPI.getModelId(realm, session, roleRep);
            results.addResult(this.realmRolesPI.added(modelId, roleRep));
        }
    }

    private void clientRoleAdds(PartialImportResults results, PartialImportRepresentation rep, RealmModel realm) {
        if (!rep.hasClientRoles()) {
            return;
        }
        Map<String, List<RoleRepresentation>> repList = this.clientRolesPI.getRepList(rep);
        for (String clientId : repList.keySet()) {
            for (RoleRepresentation roleRep : repList.get(clientId)) {
                if (this.clientRolesToOverwrite.get(clientId).contains(roleRep) || this.clientRolesToSkip.get(clientId).contains(roleRep)) continue;
                String modelId = this.clientRolesPI.getModelId(realm, clientId);
                results.addResult(this.clientRolesPI.added(clientId, modelId, roleRep));
            }
        }
    }
}

