/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.OsmDataSessionImporter;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;

public class MarkerSessionImporter
implements SessionLayerImporter {
    @Override
    public Layer load(Element elem, SessionReader.ImportSupport support, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        String version = elem.getAttribute("version");
        if (!"0.1".equals(version)) {
            throw new IllegalDataException(I18n.tr("Version ''{0}'' of meta data for marker layer is not supported. Expected: 0.1", version));
        }
        String fileStr = OsmDataSessionImporter.extractFileName(elem, support);
        try (InputStream in = support.getInputStream(fileStr);){
            GpxImporter.GpxImporterData importData = GpxImporter.loadLayers(in, support.getFile(fileStr), support.getLayerName(), progressMonitor);
            support.addPostLayersTask(importData.getPostLayerTask());
            importData.getGpxLayer().destroy();
            MarkerLayer markerLayer = importData.getMarkerLayer();
            return markerLayer;
        }
    }
}

