/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Tile multiple input images into a single output image.


This filter will tile multiple images using a user-specified layout.
The tile sizes will be large enough to accommodate the largest image
for each tile. The layout is specified with the SetLayout method. The
layout has the same dimension as the output image. If all entries of
the layout are positive, the tiled output will contain the exact
number of tiles. If the layout contains a 0 in the last dimension, the
filter will compute a size that will accommodate all of the images.
Empty tiles are filled with the value specified with the SetDefault
value method. The input images must have a dimension less than or
equal to the output image. The output image have a larger dimension
than the input images. This filter can be used to create a volume from
a series of inputs by specifying a layout of 1,1,0.


See:
 itk::simple::Tile for the procedural interface


C++ includes: sitkTileImageFilter.h
*/
public class TileImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected TileImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.TileImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(TileImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(TileImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::TileImageFilter::~TileImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_TileImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::TileImageFilter::TileImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  TileImageFilter() {
    this(SimpleITKJNI.new_TileImageFilter(), true);
  }

  /**
Self&amp; itk::simple::TileImageFilter::SetLayout(std::vector&lt; uint32_t &gt; Layout)

Set/Get the layout of the tiles. If the last Layout value is 0, the
filter will compute a value that will accommodate all of the images.

*/
public  void setLayout(VectorUInt32 Layout) {
    SimpleITKJNI.TileImageFilter_setLayout(swigCPtr, this, VectorUInt32.getCPtr(Layout), Layout);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::TileImageFilter::GetLayout() const

Set/Get the layout of the tiles. If the last Layout value is 0, the
filter will compute a value that will accommodate all of the images.

*/
public  VectorUInt32 getLayout() {
    return new VectorUInt32(SimpleITKJNI.TileImageFilter_getLayout(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::TileImageFilter::SetDefaultPixelValue(double DefaultPixelValue)

Set the pixel value for locations that are not covered by an input
image. The default default pixel value is Zero.

*/
public  void setDefaultPixelValue(double DefaultPixelValue) {
    SimpleITKJNI.TileImageFilter_setDefaultPixelValue(swigCPtr, this, DefaultPixelValue);
  }

  /**
double itk::simple::TileImageFilter::GetDefaultPixelValue() const

Get the pixel value for locations that are not covered by an input
image.

*/
public  double getDefaultPixelValue() {
    return SimpleITKJNI.TileImageFilter_getDefaultPixelValue(swigCPtr, this);
  }

  /**
std::string itk::simple::TileImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.TileImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::TileImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.TileImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::TileImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(VectorOfImage images) {
    return new Image(SimpleITKJNI.TileImageFilter_execute__SWIG_0(swigCPtr, this, VectorOfImage.getCPtr(images), images), true);
  }

  /**
Image itk::simple::TileImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.TileImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::TileImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.TileImageFilter_execute__SWIG_2(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::TileImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.TileImageFilter_execute__SWIG_3(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  /**
Image itk::simple::TileImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.TileImageFilter_execute__SWIG_4(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  /**
Image itk::simple::TileImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.TileImageFilter_execute__SWIG_5(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

}
