/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Convert a LabelMap to a binary image.


LabelMapToBinaryImageFilter to a binary image. All the objects in the image are used as
foreground. The background values of the original binary image can be
restored by passing this image to the filter with the
SetBackgroundImage() method.

This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 LabelMapToLabelImageFilter , LabelMapMaskImageFilter

 itk::simple::LabelMapToBinary for the procedural interface

 itk::LabelMapToBinaryImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelMapToBinaryImageFilter.h
*/
public class LabelMapToBinaryImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelMapToBinaryImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelMapToBinaryImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelMapToBinaryImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelMapToBinaryImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelMapToBinaryImageFilter::~LabelMapToBinaryImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelMapToBinaryImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelMapToBinaryImageFilter::LabelMapToBinaryImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelMapToBinaryImageFilter() {
    this(SimpleITKJNI.new_LabelMapToBinaryImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LabelMapToBinaryImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.LabelMapToBinaryImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::LabelMapToBinaryImageFilter::GetBackgroundValue() const

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.LabelMapToBinaryImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelMapToBinaryImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::max() .

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.LabelMapToBinaryImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::LabelMapToBinaryImageFilter::GetForegroundValue() const

Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::max() .

*/
public  double getForegroundValue() {
    return SimpleITKJNI.LabelMapToBinaryImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelMapToBinaryImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelMapToBinaryImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelMapToBinaryImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelMapToBinaryImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LabelMapToBinaryImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.LabelMapToBinaryImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
