/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the gradient of an image by convolution with the first
derivative of a Gaussian.


This filter is implemented using the recursive gaussian filters.

This filter supports both scalar and vector pixel types within the
input image, including VectorImage type.
See:
 itk::simple::GradientRecursiveGaussian for the procedural interface

 itk::GradientRecursiveGaussianImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGradientRecursiveGaussianImageFilter.h
*/
public class GradientRecursiveGaussianImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GradientRecursiveGaussianImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GradientRecursiveGaussianImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GradientRecursiveGaussianImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GradientRecursiveGaussianImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GradientRecursiveGaussianImageFilter::~GradientRecursiveGaussianImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GradientRecursiveGaussianImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GradientRecursiveGaussianImageFilter::GradientRecursiveGaussianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GradientRecursiveGaussianImageFilter() {
    this(SimpleITKJNI.new_GradientRecursiveGaussianImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GradientRecursiveGaussianImageFilter::SetSigma(double Sigma)

Set/Get the Sigma value. Sigma is measured in the units of image
spacing.

*/
public  void setSigma(double Sigma) {
    SimpleITKJNI.GradientRecursiveGaussianImageFilter_setSigma(swigCPtr, this, Sigma);
  }

  /**
double itk::simple::GradientRecursiveGaussianImageFilter::GetSigma() const

Get the value of Sigma along the first dimension.

*/
public  double getSigma() {
    return SimpleITKJNI.GradientRecursiveGaussianImageFilter_getSigma(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GradientRecursiveGaussianImageFilter::SetNormalizeAcrossScale(bool NormalizeAcrossScale)

Define which normalization factor will be used for the Gaussian
See:
 RecursiveGaussianImageFilter::SetNormalizeAcrossScale


*/
public  void setNormalizeAcrossScale(boolean NormalizeAcrossScale) {
    SimpleITKJNI.GradientRecursiveGaussianImageFilter_setNormalizeAcrossScale(swigCPtr, this, NormalizeAcrossScale);
  }

  /**
Self&amp; itk::simple::GradientRecursiveGaussianImageFilter::NormalizeAcrossScaleOn()

Set the value of NormalizeAcrossScale to true or false respectfully.

*/
public  void normalizeAcrossScaleOn() {
    SimpleITKJNI.GradientRecursiveGaussianImageFilter_normalizeAcrossScaleOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GradientRecursiveGaussianImageFilter::NormalizeAcrossScaleOff()
*/
public  void normalizeAcrossScaleOff() {
    SimpleITKJNI.GradientRecursiveGaussianImageFilter_normalizeAcrossScaleOff(swigCPtr, this);
  }

  /**
bool itk::simple::GradientRecursiveGaussianImageFilter::GetNormalizeAcrossScale() const

Define which normalization factor will be used for the Gaussian
See:
 RecursiveGaussianImageFilter::SetNormalizeAcrossScale


*/
public  boolean getNormalizeAcrossScale() {
    return SimpleITKJNI.GradientRecursiveGaussianImageFilter_getNormalizeAcrossScale(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GradientRecursiveGaussianImageFilter::SetUseImageDirection(bool UseImageDirection)

The UseImageDirection flag determines whether the gradients are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the gradients are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.

*/
public  void setUseImageDirection(boolean UseImageDirection) {
    SimpleITKJNI.GradientRecursiveGaussianImageFilter_setUseImageDirection(swigCPtr, this, UseImageDirection);
  }

  /**
Self&amp; itk::simple::GradientRecursiveGaussianImageFilter::UseImageDirectionOn()

Set the value of UseImageDirection to true or false respectfully.

*/
public  void useImageDirectionOn() {
    SimpleITKJNI.GradientRecursiveGaussianImageFilter_useImageDirectionOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GradientRecursiveGaussianImageFilter::UseImageDirectionOff()
*/
public  void useImageDirectionOff() {
    SimpleITKJNI.GradientRecursiveGaussianImageFilter_useImageDirectionOff(swigCPtr, this);
  }

  /**
bool itk::simple::GradientRecursiveGaussianImageFilter::GetUseImageDirection() const

The UseImageDirection flag determines whether the gradients are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the gradients are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.

*/
public  boolean getUseImageDirection() {
    return SimpleITKJNI.GradientRecursiveGaussianImageFilter_getUseImageDirection(swigCPtr, this);
  }

  /**
std::string itk::simple::GradientRecursiveGaussianImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GradientRecursiveGaussianImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GradientRecursiveGaussianImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GradientRecursiveGaussianImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GradientRecursiveGaussianImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.GradientRecursiveGaussianImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
