/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).


The Gaussian operator used here was described by Tony Lindeberg
(Discrete Scale-Space Theory and the Scale-Space Primal Sketch.
Dissertation. Royal Institute of Technology, Stockholm, Sweden. May
1991.) The Gaussian kernel used here was designed so that smoothing
and derivative operations commute after discretization.

The variance or standard deviation (sigma) will be evaluated as pixel
units if SetUseImageSpacing is off (false) or as physical units if
SetUseImageSpacing is on (true, default). The variance can be set
independently in each dimension.

When the Gaussian kernel is small, this filter tends to run faster
than itk::RecursiveGaussianImageFilter .


See:
 GaussianOperator

 Image

 Neighborhood

 NeighborhoodOperator

 RecursiveGaussianImageFilter

 itk::simple::DiscreteGaussian for the procedural interface

 itk::DiscreteGaussianImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDiscreteGaussianImageFilter.h
*/
public class DiscreteGaussianImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected DiscreteGaussianImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.DiscreteGaussianImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DiscreteGaussianImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(DiscreteGaussianImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::DiscreteGaussianImageFilter::~DiscreteGaussianImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_DiscreteGaussianImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::DiscreteGaussianImageFilter::DiscreteGaussianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  DiscreteGaussianImageFilter() {
    this(SimpleITKJNI.new_DiscreteGaussianImageFilter(), true);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianImageFilter::SetVariance(std::vector&lt; double &gt; Variance)
*/
public  void setVariance(VectorDouble Variance) {
    SimpleITKJNI.DiscreteGaussianImageFilter_setVariance__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(Variance), Variance);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianImageFilter::SetVariance(std::vector&lt; double &gt; Variance)
*/
public  void setVariance(double value) {
    SimpleITKJNI.DiscreteGaussianImageFilter_setVariance__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::DiscreteGaussianImageFilter::GetVariance() const

The variance for the discrete Gaussian kernel. Sets the variance
independently for each dimension, but see also SetVariance(const double v) . The default is 0.0 in each dimension. If UseImageSpacing is true,
the units are the physical units of your image. If UseImageSpacing is
false then the units are pixels.

*/
public  VectorDouble getVariance() {
    return new VectorDouble(SimpleITKJNI.DiscreteGaussianImageFilter_getVariance(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianImageFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.

*/
public  void setMaximumKernelWidth(long MaximumKernelWidth) {
    SimpleITKJNI.DiscreteGaussianImageFilter_setMaximumKernelWidth(swigCPtr, this, MaximumKernelWidth);
  }

  /**
unsigned int itk::simple::DiscreteGaussianImageFilter::GetMaximumKernelWidth() const

Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.

*/
public  long getMaximumKernelWidth() {
    return SimpleITKJNI.DiscreteGaussianImageFilter_getMaximumKernelWidth(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianImageFilter::SetMaximumError(std::vector&lt; double &gt; MaximumError)
*/
public  void setMaximumError(VectorDouble MaximumError) {
    SimpleITKJNI.DiscreteGaussianImageFilter_setMaximumError__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(MaximumError), MaximumError);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianImageFilter::SetMaximumError(std::vector&lt; double &gt; MaximumError)
*/
public  void setMaximumError(double value) {
    SimpleITKJNI.DiscreteGaussianImageFilter_setMaximumError__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::DiscreteGaussianImageFilter::GetMaximumError() const

The algorithm will size the discrete kernel so that the error
resulting from truncation of the kernel is no greater than
MaximumError. The default is 0.01 in each dimension.

*/
public  VectorDouble getMaximumError() {
    return new VectorDouble(SimpleITKJNI.DiscreteGaussianImageFilter_getMaximumError(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to take the image spacing
information into account and to specify the Gaussian variance in real
world units; use Off to ignore the image spacing and to specify the
Gaussian variance in voxel units. Default is On.

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.DiscreteGaussianImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.DiscreteGaussianImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.DiscreteGaussianImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::DiscreteGaussianImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to take the image spacing
information into account and to specify the Gaussian variance in real
world units; use Off to ignore the image spacing and to specify the
Gaussian variance in voxel units. Default is On.

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.DiscreteGaussianImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
std::string itk::simple::DiscreteGaussianImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.DiscreteGaussianImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::DiscreteGaussianImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.DiscreteGaussianImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::DiscreteGaussianImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.DiscreteGaussianImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
