/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;

public class VectorUInt16
extends AbstractList<Integer>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorUInt16(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorUInt16 vectorUInt16) {
        return vectorUInt16 == null ? 0L : vectorUInt16.swigCPtr;
    }

    protected static long swigRelease(VectorUInt16 vectorUInt16) {
        long l = 0L;
        if (vectorUInt16 != null) {
            if (!vectorUInt16.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorUInt16.swigCPtr;
            vectorUInt16.swigCMemOwn = false;
            vectorUInt16.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorUInt16(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorUInt16(int[] nArray) {
        this();
        this.reserve(nArray.length);
        for (int n : nArray) {
            this.add(n);
        }
    }

    public VectorUInt16(Iterable<Integer> iterable) {
        this();
        for (int n : iterable) {
            this.add(n);
        }
    }

    @Override
    public Integer get(int n) {
        return this.doGet(n);
    }

    @Override
    public Integer set(int n, Integer n2) {
        return this.doSet(n, n2);
    }

    @Override
    public boolean add(Integer n) {
        ++this.modCount;
        this.doAdd(n);
        return true;
    }

    @Override
    public void add(int n, Integer n2) {
        ++this.modCount;
        this.doAdd(n, n2);
    }

    @Override
    public Integer remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public VectorUInt16() {
        this(SimpleITKJNI.new_VectorUInt16__SWIG_0(), true);
    }

    public VectorUInt16(VectorUInt16 vectorUInt16) {
        this(SimpleITKJNI.new_VectorUInt16__SWIG_1(VectorUInt16.getCPtr(vectorUInt16), vectorUInt16), true);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorUInt16_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorUInt16_clear(this.swigCPtr, this);
    }

    public VectorUInt16(int n, int n2) {
        this(SimpleITKJNI.new_VectorUInt16__SWIG_2(n, n2), true);
    }

    private int doCapacity() {
        return SimpleITKJNI.VectorUInt16_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        SimpleITKJNI.VectorUInt16_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return SimpleITKJNI.VectorUInt16_doSize(this.swigCPtr, this);
    }

    private void doAdd(int n) {
        SimpleITKJNI.VectorUInt16_doAdd__SWIG_0(this.swigCPtr, this, n);
    }

    private void doAdd(int n, int n2) {
        SimpleITKJNI.VectorUInt16_doAdd__SWIG_1(this.swigCPtr, this, n, n2);
    }

    private int doRemove(int n) {
        return SimpleITKJNI.VectorUInt16_doRemove(this.swigCPtr, this, n);
    }

    private int doGet(int n) {
        return SimpleITKJNI.VectorUInt16_doGet(this.swigCPtr, this, n);
    }

    private int doSet(int n, int n2) {
        return SimpleITKJNI.VectorUInt16_doSet(this.swigCPtr, this, n, n2);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorUInt16_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

