/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.statistics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.gephi.desktop.statistics.StatisticsCategory;
import org.gephi.desktop.statistics.api.StatisticsControllerUI;
import org.gephi.desktop.statistics.api.StatisticsModelUI;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.components.JSqueezeBoxPanel;
import org.openide.util.Lookup;

public class AvailableStatisticsChooser
extends JPanel {
    private final JSqueezeBoxPanel squeezeBoxPanel = new JSqueezeBoxPanel();
    private final Map<JCheckBox, StatisticsUI> uiMap = new HashMap<JCheckBox, StatisticsUI>();
    private JPanel metricsPanel;

    public AvailableStatisticsChooser() {
        this.initComponents();
        this.metricsPanel.add((Component)this.squeezeBoxPanel, "Center");
    }

    public void setup(StatisticsModelUI model, StatisticsCategory[] categories) {
        Arrays.sort(categories, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer p1 = ((StatisticsCategory)o1).getPosition();
                Integer p2 = ((StatisticsCategory)o2).getPosition();
                return p1.compareTo(p2);
            }
        });
        StatisticsUI[] statisticsUIs = Lookup.getDefault().lookupAll(StatisticsUI.class).toArray(new StatisticsUI[0]);
        for (StatisticsCategory category : categories) {
            MigLayout migLayout = new MigLayout("insets 0 0 0 0");
            migLayout.setColumnConstraints((Object)"[grow,fill]");
            migLayout.setRowConstraints((Object)"[min!]");
            JPanel innerPanel = new JPanel((LayoutManager)migLayout);
            ArrayList<StatisticsUI> uis = new ArrayList<StatisticsUI>();
            for (StatisticsUI sui : statisticsUIs) {
                if (!sui.getCategory().equals(category.getName())) continue;
                uis.add(sui);
            }
            Collections.sort(uis, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Integer p1 = ((StatisticsUI)o1).getPosition();
                    Integer p2 = ((StatisticsUI)o2).getPosition();
                    return p1.compareTo(p2);
                }
            });
            for (StatisticsUI sui : uis) {
                JCheckBox checkBox = new JCheckBox(sui.getDisplayName());
                checkBox.setOpaque(false);
                checkBox.setSelected(model.isStatisticsUIVisible(sui));
                this.uiMap.put(checkBox, sui);
                innerPanel.add((Component)checkBox, "wrap");
            }
            if (uis.size() <= 0) continue;
            this.squeezeBoxPanel.addPanel(innerPanel, category.getName());
        }
    }

    public void unsetup() {
        StatisticsControllerUI controller = (StatisticsControllerUI)Lookup.getDefault().lookup(StatisticsControllerUI.class);
        for (Map.Entry<JCheckBox, StatisticsUI> entry : this.uiMap.entrySet()) {
            controller.setStatisticsUIVisible(entry.getValue(), entry.getKey().isSelected());
        }
    }

    private void initComponents() {
        this.metricsPanel = new JPanel();
        this.metricsPanel.setLayout(new BorderLayout());
        this.metricsPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.metricsPanel, -1, 396, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.metricsPanel, -1, 433, Short.MAX_VALUE).addContainerGap()));
        this.add((Component)this.metricsPanel, "Center");
    }
}

