# LinearAlgebraForCAP, single 14
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("linearalgebraforcap14.tst");

# doc/_Chapter_Examples_and_Tests.xml:646-667
gap> LoadPackage( "LinearAlgebraForCAP", false );
true
gap> Q := HomalgFieldOfRationals();;
gap> Qmat := MatrixCategory( Q );;
gap> a := MatrixCategoryObject( Qmat, 3 );;
gap> b := MatrixCategoryObject( Qmat, 4 );;
gap> homalg_matrix := HomalgMatrix( [ [ 1, 0, 0, 0 ],
>                                   [ 0, 1, 0, -1 ],
>                                   [ -1, 0, 2, 1 ] ], 3, 4, Q );;
gap> alpha := VectorSpaceMorphism( a, homalg_matrix, b );;
gap> beta := SomeReductionBySplitEpiSummand( alpha );;
gap> IsWellDefinedForMorphisms( beta );
true
gap> Dimension( Source( beta ) );
0
gap> Dimension( Range( beta ) );
1
gap> gamma := SomeReductionBySplitEpiSummand_MorphismFromInputRange( alpha );;
gap> Display( EntriesOfHomalgMatrixAsListList( UnderlyingMatrix( gamma ) ) );
[ [ 0 ], [ 1 ], [ -1/2 ], [ 1 ] ]

#
gap> STOP_TEST("linearalgebraforcap14.tst", 1);
