/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.link.CollisionDetector;

public class SummaryEdgeView
extends EdgeView {
    private static final int CHILD_XCTRL = 20;
    private static final int XCTRL = 4;

    public SummaryEdgeView(NodeView source, NodeView target, Component paintedComponent) {
        super(source, target, paintedComponent);
    }

    @Override
    protected void draw(Graphics2D g) {
        Shape graph = this.update();
        g.draw(graph);
    }

    private Shape update() {
        boolean isTopOrLeft = this.getTarget().isTopOrLeft();
        int sign = isTopOrLeft ? -1 : 1;
        int xctrl = this.getMap().getZoomed(sign * 4);
        int childXctrl = this.getMap().getZoomed(sign * 20);
        GeneralPath path = new GeneralPath(0, 5);
        if (this.getSource().usesHorizontalLayout()) {
            int startY = isTopOrLeft ? Math.min(this.shapeStart.y, this.end.y - childXctrl) : Math.max(this.shapeStart.y, this.end.y - childXctrl);
            path.moveTo(this.shapeStart.x, startY);
            path.lineTo(this.shapeStart.x, startY + xctrl);
            path.curveTo(this.shapeStart.x, startY + 2 * xctrl, this.end.x, startY, this.end.x, this.end.y);
        } else {
            int startX = isTopOrLeft ? Math.min(this.shapeStart.x, this.end.x - childXctrl) : Math.max(this.shapeStart.x, this.end.x - childXctrl);
            path.moveTo(startX, this.shapeStart.y);
            path.lineTo(startX + xctrl, this.shapeStart.y);
            path.curveTo(startX + 2 * xctrl, this.shapeStart.y, startX, this.end.y, this.end.x, this.end.y);
        }
        return path;
    }

    @Override
    public boolean detectCollision(Point p) {
        Shape graph = this.update();
        return new CollisionDetector().detectCollision(p, graph);
    }
}

