/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JViewport;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewScrollPane;
import org.freeplane.view.swing.map.NodeView;

class MapScroller {
    private static final String KEEP_SELECTED_NODE_VISIBLE_PROPERTY = "keepSelectedNodeVisible";
    private NodeView anchor;
    private Point anchorContentLocation;
    private float anchorHorizontalPoint;
    private float anchorVerticalPoint;
    private NodeView scrolledNode = null;
    private ScrollingDirective scrollingDirective = ScrollingDirective.DONE;
    private boolean showsSelectedAfterScroll = false;
    private boolean slowScroll;
    private int extraWidth;
    private final MapView map;
    private boolean scrollsNodeTreeToVisible;

    MapScroller(MapView map) {
        this.map = map;
        this.anchorContentLocation = null;
        this.anchor = null;
    }

    void anchorToNode(NodeView view, float horizontalPoint, float verticalPoint) {
        if (view != null && view.getMainView() != null) {
            if (this.scrollingDirective == ScrollingDirective.DONE || view.isRoot() || this.anchor == null) {
                this.anchor = view;
            } else if (!this.anchor.isRoot() && this.anchor != view && !this.anchor.isAncestorOf(view)) {
                NodeModel lastAnchor = this.anchor.getNode();
                NodeModel newAnchor = view.getNode();
                NodeRelativePath nodeRelativePath = new NodeRelativePath(lastAnchor, newAnchor);
                NodeModel commonAncestor = nodeRelativePath.commonAncestor();
                NodeView newAnchorView = view.getMap().getNodeView(commonAncestor);
                if (newAnchorView != null) {
                    this.anchor = newAnchorView;
                }
            }
            this.anchorHorizontalPoint = horizontalPoint;
            this.anchorVerticalPoint = verticalPoint;
            this.anchorContentLocation = this.getAnchorCenterPoint();
            if (this.scrolledNode == null) {
                this.scrolledNode = this.anchor;
                this.scrollingDirective = ScrollingDirective.ANCHOR;
                this.extraWidth = 0;
                this.keepShowingSelectedAfterScroll();
            }
        }
    }

    void scrollBy(int x, int y) {
        JViewport mapViewport = (JViewport)this.map.getParent();
        if (mapViewport != null) {
            Point currentPoint = mapViewport.getViewPosition();
            currentPoint.translate(x, y);
            if (currentPoint.getX() < 0.0) {
                currentPoint.setLocation(0.0, currentPoint.getY());
            }
            if (currentPoint.getY() < 0.0) {
                currentPoint.setLocation(currentPoint.getX(), 0.0);
            }
            double maxX = this.map.getSize().getWidth() - mapViewport.getExtentSize().getWidth();
            double maxY = this.map.getSize().getHeight() - mapViewport.getExtentSize().getHeight();
            if (currentPoint.getX() > maxX) {
                currentPoint.setLocation(maxX, currentPoint.getY());
            }
            if (currentPoint.getY() > maxY) {
                currentPoint.setLocation(currentPoint.getX(), maxY);
            }
            mapViewport.setViewPosition(currentPoint);
        }
    }

    void scrollNode(NodeView nodeView, IMapSelection.NodePosition position, boolean slowScroll) {
        this.showsSelectedAfterScroll = false;
        this.scrollNode(nodeView, ScrollingDirective.of(position), slowScroll);
    }

    void scrollNodeToCenter(NodeView node, boolean slow) {
        this.scrollNode(node, ScrollingDirective.SCROLL_NODE_TO_CENTER, slow);
    }

    boolean shouldScrollSlowly() {
        return ResourceController.getResourceController().getBooleanProperty("slow_scroll_selected_node");
    }

    private void scrollNode(NodeView node, ScrollingDirective scrollingDirective, boolean slowScroll) {
        if (node != null) {
            this.slowScroll = slowScroll;
            this.scrolledNode = node;
            this.scrollingDirective = scrollingDirective;
            if (this.map.isDisplayable() && this.map.isFrameLayoutCompleted() && this.map.isValid()) {
                if (slowScroll) {
                    this.startSlowScrolling();
                }
                this.scrollNodeNow();
            }
        }
    }

    private Rectangle calculateOptimalVisibleRectangle() {
        JViewport viewPort = (JViewport)this.map.getParent();
        Dimension extentSize = viewPort.getExtentSize();
        JComponent content = this.scrolledNode.getContent();
        Point contentLocation = new Point();
        UITools.convertPointToAncestor((Component)content, contentLocation, this.map);
        Rectangle rect = new Rectangle(contentLocation.x + content.getWidth() / 2 - extentSize.width / 2, contentLocation.y + content.getHeight() / 2 - extentSize.height / 2, extentSize.width, extentSize.height);
        int distanceToMargin = (extentSize.width - content.getWidth()) / 2 - 10;
        int distanceToMarginY = (extentSize.height - content.getHeight()) / 2 - 10;
        switch (this.scrollingDirective.ordinal()) {
            case 5: {
                rect.x += distanceToMargin;
                rect.y += distanceToMarginY;
                break;
            }
            case 7: {
                rect.x += distanceToMargin;
                rect.y -= distanceToMarginY;
                break;
            }
            case 6: {
                rect.y += distanceToMarginY;
                rect.x -= distanceToMargin;
                break;
            }
            case 8: {
                rect.x -= distanceToMargin;
                rect.y -= distanceToMarginY;
                break;
            }
            case 1: {
                rect.x += distanceToMargin;
                break;
            }
            case 3: {
                rect.y += distanceToMarginY;
                break;
            }
            case 2: {
                rect.x -= distanceToMargin;
                break;
            }
            case 4: {
                rect.y -= distanceToMarginY;
                break;
            }
            case 9: {
                Rectangle innerBounds = this.map.getInnerBounds();
                if (innerBounds.width <= extentSize.width && this.map.getModeController().shouldCenterCompactMaps()) {
                    rect.x = innerBounds.x - (extentSize.width - innerBounds.width) / 2;
                    break;
                }
                NodeView root = this.map.getRoot();
                boolean outlineLayoutSet = this.map.isOutlineLayoutSet();
                if (outlineLayoutSet || root.usesHorizontalLayout()) break;
                boolean scrollToTheLeft = false;
                List<NodeModel> children = root.getNode().getChildren();
                if (!children.isEmpty()) {
                    scrollToTheLeft = true;
                    for (NodeModel node : children) {
                        if (!node.isTopOrLeft(root.getNode())) continue;
                        scrollToTheLeft = false;
                        break;
                    }
                }
                if (!scrollToTheLeft) break;
                rect.x += (extentSize.width - content.getWidth()) / 2 - 10;
                break;
            }
        }
        return rect;
    }

    private void scrollNodeNow() {
        Rectangle rect = this.calculateOptimalVisibleRectangle();
        this.map.scrollRectToVisible(rect);
        this.scrolledNode = null;
        this.scrollingDirective = ScrollingDirective.DONE;
        this.slowScroll = false;
        this.anchor = null;
        this.anchorContentLocation = this.getAnchorCenterPoint();
    }

    private void startSlowScrolling() {
        MapViewScrollPane.MapViewPort viewPort = (MapViewScrollPane.MapViewPort)this.map.getParent();
        viewPort.startSlowScrolling(20);
    }

    private Point getAnchorCenterPoint() {
        if (!this.map.isDisplayable()) {
            return null;
        }
        MainView mainView = this.getAnchor().getMainView();
        int referenceWidth = mainView.getWidth();
        int referenceHeight = mainView.getHeight();
        JViewport viewPort = (JViewport)this.map.getParent();
        Point anchorCenterPoint = new Point((int)((float)referenceWidth * this.anchorHorizontalPoint) - viewPort.getWidth() / 2, (int)((float)referenceHeight * this.anchorVerticalPoint) - viewPort.getHeight() / 2);
        UITools.convertPointToAncestor((Component)mainView, anchorCenterPoint, viewPort);
        return anchorCenterPoint;
    }

    private NodeView getAnchor() {
        return this.anchor != null ? this.anchor : this.map.getRoot();
    }

    void scrollNodeToVisible(NodeView node) {
        this.scrollNodeToVisible(node, 0);
    }

    private void scrollNodeToVisible(NodeView node, int extraWidth) {
        if (node == null) {
            return;
        }
        if (this.scrollingDirective == ScrollingDirective.DONE || this.scrollingDirective == ScrollingDirective.ANCHOR) {
            this.scrollingDirective = ScrollingDirective.MAKE_NODE_VISIBLE;
            this.showsSelectedAfterScroll = false;
        }
        if (this.scrolledNode != null && this.scrollingDirective != ScrollingDirective.MAKE_NODE_VISIBLE) {
            if (node != this.scrolledNode) {
                if (this.scrollingDirective == ScrollingDirective.SCROLL_TO_BEST_ROOT_POSITION && !node.isRoot()) {
                    this.showsSelectedAfterScroll = true;
                    return;
                }
                this.scrollNode(node, this.scrollingDirective, false);
            }
            return;
        }
        if (!this.map.isValid()) {
            this.scrolledNode = node;
            this.scrollingDirective = ScrollingDirective.MAKE_NODE_VISIBLE;
            this.extraWidth = extraWidth;
            return;
        }
        int HORIZ_SPACE = 10;
        int HORIZ_SPACE2 = 20;
        int VERT_SPACE = 5;
        int VERT_SPACE2 = 10;
        JComponent nodeContent = node.getContent();
        int width = nodeContent.getWidth();
        if (extraWidth < 0) {
            nodeContent.scrollRectToVisible(new Rectangle(-10 + extraWidth, -5, (width -= extraWidth) + 20, nodeContent.getHeight() + 10));
        } else {
            nodeContent.scrollRectToVisible(new Rectangle(-10, -5, (width += extraWidth) + 20, nodeContent.getHeight() + 10));
        }
        this.scrollingDirective = ScrollingDirective.DONE;
        this.scrolledNode = null;
    }

    void scrollToRootNode() {
        this.scrollNode(this.map.getRoot(), ScrollingDirective.SCROLL_TO_BEST_ROOT_POSITION, false);
    }

    void scrollView() {
        NodeView scrolledNode;
        JViewport vp = (JViewport)this.map.getParent();
        Point viewPosition = vp.getViewPosition();
        Point oldAnchorContentLocation = this.anchorContentLocation;
        Point newAnchorContentLocation = this.getAnchorCenterPoint();
        if (oldAnchorContentLocation != null && (this.slowScroll || this.scrollingDirective == ScrollingDirective.DONE || this.scrollingDirective == ScrollingDirective.MAKE_NODE_VISIBLE || this.scrollingDirective == ScrollingDirective.ANCHOR)) {
            int deltaX = newAnchorContentLocation.x - oldAnchorContentLocation.x;
            int deltaY = newAnchorContentLocation.y - oldAnchorContentLocation.y;
            if (deltaX != 0 || deltaY != 0) {
                viewPosition.x += deltaX;
                viewPosition.y += deltaY;
                vp.setViewPosition(viewPosition);
            }
        }
        if ((scrolledNode = this.scrolledNode) != null && this.scrollingDirective != ScrollingDirective.MAKE_NODE_VISIBLE && this.scrollingDirective != ScrollingDirective.ANCHOR) {
            this.scrollNode(scrolledNode, this.scrollingDirective, this.slowScroll);
        }
        if (this.scrollsNodeTreeToVisible) {
            this.scrollNodeTreeToVisible(scrolledNode, this.slowScroll);
        }
        this.showSelectedAfterScroll();
        if (scrolledNode != null && this.scrollingDirective == ScrollingDirective.MAKE_NODE_VISIBLE) {
            this.scrollNodeToVisible(scrolledNode, this.extraWidth);
        }
        this.scrolledNode = null;
        this.scrollingDirective = ScrollingDirective.DONE;
        this.anchor = null;
        this.anchorVerticalPoint = 0.5f;
        this.anchorHorizontalPoint = 0.5f;
        this.anchorContentLocation = this.getAnchorCenterPoint();
    }

    private void showSelectedAfterScroll() {
        if (this.showsSelectedAfterScroll) {
            this.showsSelectedAfterScroll = false;
            this.scrollNodeToVisible(this.map.getSelectionEnd(), 0);
        }
    }

    void setAnchorContentLocation() {
        if (this.scrollingDirective == ScrollingDirective.SCROLL_TO_BEST_ROOT_POSITION) {
            this.scrollView();
        } else {
            this.anchorContentLocation = this.getAnchorCenterPoint();
        }
    }

    void scrollNodeTreeToVisible(NodeView node, boolean slow) {
        int topGap;
        int lackingHeight;
        int leftGap;
        if (!this.map.isValid()) {
            this.scrolledNode = node;
            this.scrollsNodeTreeToVisible = true;
            this.slowScroll = slow;
            return;
        }
        MapViewScrollPane.MapViewPort viewport = (MapViewScrollPane.MapViewPort)this.map.getParent();
        Rectangle visibleRect = viewport.getViewRect();
        Rectangle requiredRectangle = new Rectangle(node.getSize());
        int margin = 30;
        int spaceToCut = node.getSpaceAround() - margin;
        requiredRectangle.x += spaceToCut;
        requiredRectangle.y += spaceToCut;
        requiredRectangle.width -= 2 * spaceToCut;
        requiredRectangle.height -= 2 * spaceToCut;
        Rectangle contentBounds = node.getContent().getBounds();
        int lackingWidth = requiredRectangle.width - visibleRect.width;
        if (lackingWidth > 0 && (leftGap = contentBounds.x - requiredRectangle.x - margin) > 0) {
            int rightGap = requiredRectangle.x + requiredRectangle.width - contentBounds.x - contentBounds.width - margin;
            requiredRectangle.width = visibleRect.width;
            requiredRectangle.x += lackingWidth * leftGap / (leftGap + rightGap);
        }
        if ((lackingHeight = requiredRectangle.height - visibleRect.height) > 0 && (topGap = contentBounds.y - requiredRectangle.y - margin) > 0) {
            int bottomGap = requiredRectangle.y + requiredRectangle.height - contentBounds.y - contentBounds.height - margin;
            requiredRectangle.height = visibleRect.height;
            requiredRectangle.y += lackingHeight * topGap / (topGap + bottomGap);
        }
        this.keepShowingSelectedAfterScroll();
        if (slow) {
            this.startSlowScrolling();
        }
        this.scrollsNodeTreeToVisible = false;
        node.scrollRectToVisible(requiredRectangle);
        this.showSelectedAfterScroll();
    }

    void anchorToRoot() {
        NodeView root = this.map.getRoot();
        if (this.anchor != null && !this.anchor.equals(root)) {
            this.anchorToNode(root, 0.0f, 0.0f);
        }
    }

    boolean isShowsSelectedAfterScroll() {
        return this.showsSelectedAfterScroll;
    }

    void setShowsSelectedAfterScroll(boolean showSelectedAfterScroll) {
        this.showsSelectedAfterScroll = showSelectedAfterScroll;
    }

    private void keepShowingSelectedAfterScroll() {
        if (!this.showsSelectedAfterScroll && ResourceController.getResourceController().getBooleanProperty(KEEP_SELECTED_NODE_VISIBLE_PROPERTY)) {
            JComponent selectionEndContent = this.map.getSelectionEnd().getContent();
            Rectangle selectionEndVisibleRectangle = selectionEndContent.getVisibleRect();
            this.showsSelectedAfterScroll = selectionEndVisibleRectangle.width > 0 && selectionEndVisibleRectangle.height > 0;
        }
    }

    private static enum ScrollingDirective {
        SCROLL_NODE_TO_CENTER(IMapSelection.NodePosition.CENTER),
        SCROLL_NODE_TO_LEFT_MARGIN(IMapSelection.NodePosition.LEFT),
        SCROLL_NODE_TO_RIGHT_MARGIN(IMapSelection.NodePosition.RIGHT),
        SCROLL_NODE_TO_TOP_MARGIN(IMapSelection.NodePosition.TOP),
        SCROLL_NODE_TO_BOTTOM_MARGIN(IMapSelection.NodePosition.BOTTOM),
        SCROLL_NODE_TO_TOP_LEFT_CORNER(IMapSelection.NodePosition.TOP_LEFT),
        SCROLL_NODE_TO_TOP_RIGHT_CORNER(IMapSelection.NodePosition.TOP_RIGHT),
        SCROLL_NODE_TO_BOTTOM_LEFT_CORNER(IMapSelection.NodePosition.BOTTOM_LEFT),
        SCROLL_NODE_TO_BOTTOM_RIGHT_CORNER(IMapSelection.NodePosition.BOTTOM_RIGHT),
        SCROLL_TO_BEST_ROOT_POSITION,
        MAKE_NODE_VISIBLE,
        DONE,
        ANCHOR;


        public static ScrollingDirective of(IMapSelection.NodePosition position) {
            return CompanionObject.positionDirectiveMapping[position.ordinal()];
        }

        private ScrollingDirective() {
        }

        private ScrollingDirective(IMapSelection.NodePosition position) {
            CompanionObject.positionDirectiveMapping[position.ordinal()] = this;
        }

        private static class CompanionObject {
            private static final ScrollingDirective[] positionDirectiveMapping = new ScrollingDirective[IMapSelection.NodePosition.values().length];

            private CompanionObject() {
            }
        }
    }
}

