/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.engine.openai;

import java.util.Locale;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.engine.LegacyAISettings;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModel;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIProperties;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.utils.CommonUtils;

public class OpenAiConfigurator
implements IObjectPropertyConfigurator<AIEngine, LegacyAISettings<OpenAIProperties>> {
    private static final String API_KEY_URL = "https://platform.openai.com/account/api-keys";
    protected String token = "";
    protected String model = "";
    private String temperature = "0.0";
    private boolean logQuery = false;
    @Nullable
    protected Text tokenText;
    private Text temperatureText;
    private Combo modelCombo;
    private Button logQueryCheck;

    public void createControl(@NotNull Composite parent, AIEngine object, @NotNull Runnable propertyChangeListener) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        composite.setLayoutData((Object)new GridData(768));
        this.createConnectionParameters(composite);
        this.createModelParameters(composite);
        this.createAdditionalSettings(composite);
        UIUtils.syncExec(this::applySettings);
    }

    public void loadSettings(@NotNull LegacyAISettings<OpenAIProperties> configuration) {
        this.token = CommonUtils.toString((Object)((OpenAIProperties)configuration.getProperties()).getToken());
        this.model = this.readModel(configuration).getName();
        this.temperature = CommonUtils.toString((Object)((OpenAIProperties)configuration.getProperties()).getTemperature(), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean((Object)((OpenAIProperties)configuration.getProperties()).isLoggingEnabled());
        this.applySettings();
    }

    public void saveSettings(@NotNull LegacyAISettings<OpenAIProperties> configuration) {
        ((OpenAIProperties)configuration.getProperties()).setToken(this.token);
        ((OpenAIProperties)configuration.getProperties()).setModel(this.model);
        ((OpenAIProperties)configuration.getProperties()).setTemperature(Double.parseDouble(this.temperature));
        ((OpenAIProperties)configuration.getProperties()).setLoggingEnabled(this.logQuery);
    }

    public void resetSettings(@NotNull LegacyAISettings<OpenAIProperties> openAIPropertiesLegacyAISettings) {
    }

    protected void createAdditionalSettings(@NotNull Composite parent) {
        this.logQueryCheck = UIUtils.createCheckbox((Composite)parent, (String)"Write GPT queries to debug log", (String)"Write GPT queries with metadata info in debug logs", (boolean)false, (int)2);
        this.logQueryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenAiConfigurator.this.logQuery = OpenAiConfigurator.this.logQueryCheck.getSelection();
            }
        });
    }

    protected void createModelParameters(@NotNull Composite parent) {
        if (this.isUsesModel()) {
            this.modelCombo = UIUtils.createLabelCombo((Composite)parent, (String)AIUIMessages.gpt_preference_page_combo_engine, (int)8);
            OpenAIModel[] openAIModelArray = this.getSupportedGPTModels();
            int n = openAIModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                OpenAIModel model = openAIModelArray[n2];
                if (model.getDeprecationReplacementModel() == null) {
                    this.modelCombo.add(model.getName());
                }
                ++n2;
            }
            this.modelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OpenAiConfigurator.this.model = OpenAiConfigurator.this.modelCombo.getText();
                }
            });
        }
        this.temperatureText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        UIUtils.createInfoLabel((Composite)parent, (String)"Lower temperatures give more precise results", (int)768, (int)2);
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(e -> {
            String string = this.temperature = this.temperatureText.getText();
        });
    }

    @NotNull
    protected OpenAIModel[] getSupportedGPTModels() {
        return OpenAIModel.values();
    }

    protected void createConnectionParameters(@NotNull Composite parent) {
        this.tokenText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_selector_token, (String)"", (int)0x400800);
        this.tokenText.setLayoutData((Object)new GridData(768));
        this.tokenText.addModifyListener(e -> {
            String string = this.token = this.tokenText.getText();
        });
        this.tokenText.setMessage("API access token");
        this.createURLInfoLink(parent);
    }

    protected void createURLInfoLink(@NotNull Composite parent) {
        Link link = UIUtils.createLink((Composite)parent, (String)NLS.bind((String)AIUIMessages.gpt_preference_page_token_info, (Object)this.getApiKeyURL()), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.openWebBrowser((String)OpenAiConfigurator.this.getApiKeyURL());
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        link.setLayoutData((Object)gd);
    }

    protected String getApiKeyURL() {
        return API_KEY_URL;
    }

    private OpenAIModel readModel(@NotNull LegacyAISettings<OpenAIProperties> configuration) {
        return OpenAIModel.getByName((String)CommonUtils.toString((Object)((OpenAIProperties)configuration.getProperties()).getModel(), (String)this.getDefaultModel()));
    }

    protected String getDefaultModel() {
        return OpenAIModel.GPT_TURBO.getName();
    }

    protected void applySettings() {
        if (this.tokenText != null) {
            this.tokenText.setText(this.token);
        }
        if (this.isUsesModel()) {
            this.modelCombo.setText(this.model);
        }
        this.temperatureText.setText(this.temperature);
        this.logQueryCheck.setSelection(this.logQuery);
    }

    protected boolean isUsesModel() {
        return true;
    }

    public boolean isComplete() {
        return this.tokenText == null || !this.tokenText.getText().isEmpty();
    }
}

