/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.engine.copilot;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.engine.LegacyAISettings;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotClient;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotProperties;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceAuth;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.engine.copilot.CopilotMessages;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.utils.CommonUtils;

public class CopilotConfigurator
implements IObjectPropertyConfigurator<AIEngine, LegacyAISettings<CopilotProperties>> {
    private static final Log log = Log.getLog(CopilotConfigurator.class);
    @Nullable
    protected Text tokenText;
    private Text temperatureText;
    private Combo modelCombo;
    private Button logQueryCheck;
    private Text accessTokenText;
    private String accessToken;
    protected String token = "";
    protected String model = "";
    private String temperature = "0.0";
    private boolean logQuery = false;

    public void createControl(@NotNull Composite parent, AIEngine object, @NotNull Runnable propertyChangeListener) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)3);
        composite.setLayoutData((Object)new GridData(768));
        this.createConnectionParameters(composite);
        this.createModelParameters(composite);
        this.createAdditionalSettings(composite);
        UIUtils.syncExec(this::applySettings);
    }

    public void loadSettings(@NotNull LegacyAISettings<CopilotProperties> configuration) {
        this.token = CommonUtils.toString((Object)((CopilotProperties)configuration.getProperties()).getToken());
        this.model = CommonUtils.toString((Object)((CopilotProperties)configuration.getProperties()).getModel());
        this.temperature = CommonUtils.toString((Object)((CopilotProperties)configuration.getProperties()).getTemperature(), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean((Object)((CopilotProperties)configuration.getProperties()).isLoggingEnabled());
        this.accessToken = CommonUtils.toString((Object)((CopilotProperties)configuration.getProperties()).getToken(), (String)"");
        this.accessTokenText.setText(this.accessToken);
        this.populateModelsCombo(false);
        this.applySettings();
    }

    private void populateModelsCombo(boolean forceRefresh) {
        List models = null;
        try {
            models = (List)UIUtils.runWithMonitor(monitor -> CopilotClient.getModels((DBRProgressMonitor)monitor, (String)this.accessToken, (boolean)forceRefresh));
        }
        catch (DBException e) {
            log.error((Object)"Error reading model list", (Throwable)e);
        }
        if (!CommonUtils.isEmpty((Collection)models)) {
            this.modelCombo.setItems(models.toArray(new String[0]));
            this.modelCombo.select(0);
            int i = 0;
            while (i < this.modelCombo.getItemCount()) {
                if (this.modelCombo.getItem(i).equals(this.model)) {
                    this.modelCombo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    public void saveSettings(@NotNull LegacyAISettings<CopilotProperties> copilotSettings) {
        ((CopilotProperties)copilotSettings.getProperties()).setToken(this.accessToken);
        ((CopilotProperties)copilotSettings.getProperties()).setModel(this.model);
        ((CopilotProperties)copilotSettings.getProperties()).setTemperature(Double.parseDouble(this.temperature));
        ((CopilotProperties)copilotSettings.getProperties()).setLoggingEnabled(this.logQuery);
    }

    public void resetSettings(@NotNull LegacyAISettings<CopilotProperties> copilotPropertiesLegacyAISettings) {
    }

    public boolean isComplete() {
        return true;
    }

    @NotNull
    protected OpenAIModel[] getSupportedGPTModels() {
        return new OpenAIModel[]{OpenAIModel.GPT_4, OpenAIModel.GPT_TURBO};
    }

    private void createModelParameters(@NotNull Composite parent) {
        this.modelCombo = UIUtils.createLabelCombo((Composite)parent, (String)AIUIMessages.gpt_preference_page_combo_engine, (int)8);
        OpenAIModel[] openAIModelArray = this.getSupportedGPTModels();
        int n = openAIModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            OpenAIModel model = openAIModelArray[n2];
            if (model.getDeprecationReplacementModel() == null) {
                this.modelCombo.add(model.getName());
            }
            ++n2;
        }
        this.modelCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String string = this.model = this.modelCombo.getText();
        }));
        UIUtils.createDialogButton((Composite)parent, (String)AIUIMessages.gpt_preference_page_refresh_models, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.populateModelsCombo(true)));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.temperatureText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.setLayoutData((Object)gridData);
        UIUtils.createInfoLabel((Composite)parent, (String)"Lower temperatures give more precise results", (int)768, (int)3);
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(e -> {
            String string = this.temperature = this.temperatureText.getText();
        });
    }

    private void createAdditionalSettings(@NotNull Composite parent) {
        this.logQueryCheck = UIUtils.createCheckbox((Composite)parent, (String)"Write GPT queries to debug log", (String)"Write GPT queries with metadata info in debug logs", (boolean)false, (int)2);
        this.logQueryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CopilotConfigurator.this.logQuery = CopilotConfigurator.this.logQueryCheck.getSelection();
            }
        });
    }

    private void applySettings() {
        if (this.tokenText != null) {
            this.tokenText.setText(this.token);
        }
        this.modelCombo.setText(this.model);
        this.temperatureText.setText(this.temperature);
        this.logQueryCheck.setSelection(this.logQuery);
    }

    private void createConnectionParameters(@NotNull Composite parent) {
        this.accessTokenText = UIUtils.createLabelText((Composite)parent, (String)CopilotMessages.copilot_access_token, (String)"", (int)0x400800);
        this.accessTokenText.setLayoutData((Object)new GridData(768));
        this.accessTokenText.addModifyListener(e -> {
            String string = this.accessToken = this.accessTokenText.getText();
        });
        this.accessTokenText.setMessage(CopilotMessages.copilot_preference_page_token_info);
        UIUtils.createDialogButton((Composite)parent, (String)CopilotMessages.copilot_access_token_authorize, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
            try {
                this.accessToken = (String)UIUtils.runWithDialog(monitor -> {
                    CompletableFuture<Void> future = new CompletableFuture<Void>();
                    try {
                        String string = this.acquireAccessToken(monitor, future);
                        return string;
                    }
                    finally {
                        future.complete(null);
                    }
                });
            }
            catch (DBException ex) {
                DBWorkbench.getPlatformUI().showError(CopilotMessages.oauth_auth_title, NLS.bind((String)CopilotMessages.oauth_auth_error_message, (Object)ex.getMessage()), (Throwable)ex);
                return;
            }
            UIUtils.showMessageBox((Shell)UIUtils.getActiveShell(), (String)CopilotMessages.oauth_auth_title, (String)CopilotMessages.oauth_auth_success_message, (int)2);
            if (this.accessTokenText != null && !this.accessTokenText.isDisposed()) {
                this.accessTokenText.setText(this.accessToken);
                this.accessTokenText = UIUtils.recreateTextControl((Text)this.accessTokenText, (int)2048);
            }
            this.populateModelsCombo(true);
        }));
    }

    @NotNull
    private String acquireAccessToken(@NotNull DBRProgressMonitor monitor, @NotNull CompletableFuture<Void> future) throws DBException {
        UIServiceAuth service = (UIServiceAuth)DBWorkbench.getService(UIServiceAuth.class);
        if (service == null) {
            throw new DBException("No authentication service available");
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (CopilotClient client = new CopilotClient();){
                monitor.subTask("Requesting device code");
                CopilotClient.DeviceCodeResponse deviceCodeResponse = client.requestDeviceCode(monitor);
                service.showCodePopup(URI.create(deviceCodeResponse.verificationUri()), deviceCodeResponse.userCode(), future);
                monitor.subTask("Awaiting access token");
                return client.requestAccessToken(monitor, deviceCodeResponse, future);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedException e) {
            throw new DBException("Authorization was interrupted", (Throwable)e);
        }
    }
}

