/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.controls;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIActivator;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseObjectsSelectorPanel;

public class ScopeSelectorDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.AIScopeSelectorDialog";
    private final DBRRunnableContext runnableContext;
    private final DBPDataSourceContainer dataSourceContainer;
    private DatabaseObjectsSelectorPanel selectorPanel;
    private List<? extends DBNNode> selectedNodes;

    public ScopeSelectorDialog(@NotNull Shell parentShell, @NotNull DBRRunnableContext runnableContext, @NotNull DBPDataSourceContainer container, @NotNull List<? extends DBNNode> selectedNodes) {
        super(parentShell, "Select objects to include in completion scope", null);
        this.runnableContext = runnableContext;
        this.dataSourceContainer = container;
        this.selectedNodes = selectedNodes;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)AIUIActivator.getDefault().getDialogSettings(), (String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        this.selectorPanel = new DatabaseObjectsSelectorPanel(dialogArea, true, this.runnableContext){

            protected DBPProject getSelectedProject() {
                return ScopeSelectorDialog.this.dataSourceContainer.getProject();
            }

            protected DBNNode getRootNode() {
                return this.getProject().getNavigatorModel().getNodeByObject((DBSObject)ScopeSelectorDialog.this.dataSourceContainer);
            }

            protected boolean isDatabaseFolderVisible(DBNDatabaseFolder folder) {
                Class childrenClass = folder.getChildrenClass();
                if (childrenClass == null) {
                    return false;
                }
                return DBSEntity.class.isAssignableFrom(childrenClass) || DBSEntityContainer.class.isAssignableFrom(childrenClass);
            }

            protected boolean isDatabaseObjectVisible(DBSObject obj) {
                return DBSEntity.class.isInstance(obj);
            }
        };
        this.selectorPanel.getNavigatorTree().getViewer().expandToLevel(2);
        this.selectorPanel.checkNodes(this.selectedNodes, true);
        this.selectorPanel.setSelection(this.selectedNodes);
        return dialogArea;
    }

    protected void okPressed() {
        this.selectedNodes = this.selectorPanel.getCheckedNodes();
        this.selectedNodes.removeIf(n -> {
            DBNDatabaseNode dbn;
            return !(n instanceof DBNDatabaseNode) || !((dbn = (DBNDatabaseNode)n).getObject() instanceof DBSEntity) && !(dbn.getObject() instanceof DBSEntityContainer);
        });
        this.selectedNodes.removeIf(n -> this.selectedNodes.contains(n.getParentNode()));
        super.okPressed();
    }

    public List<? extends DBNNode> getSelectedNodes() {
        return this.selectedNodes;
    }
}

