﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/inspector2/model/CodeFilePath.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Inspector2
{
namespace Model
{

  /**
   * <p>Contains information on the code vulnerability identified in your Lambda
   * function.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CodeVulnerabilityDetails">AWS
   * API Reference</a></p>
   */
  class CodeVulnerabilityDetails
  {
  public:
    AWS_INSPECTOR2_API CodeVulnerabilityDetails() = default;
    AWS_INSPECTOR2_API CodeVulnerabilityDetails(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API CodeVulnerabilityDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The Common Weakness Enumeration (CWE) item associated with the detected
     * vulnerability.</p>
     */
    inline const Aws::Vector<Aws::String>& GetCwes() const { return m_cwes; }
    inline bool CwesHasBeenSet() const { return m_cwesHasBeenSet; }
    template<typename CwesT = Aws::Vector<Aws::String>>
    void SetCwes(CwesT&& value) { m_cwesHasBeenSet = true; m_cwes = std::forward<CwesT>(value); }
    template<typename CwesT = Aws::Vector<Aws::String>>
    CodeVulnerabilityDetails& WithCwes(CwesT&& value) { SetCwes(std::forward<CwesT>(value)); return *this;}
    template<typename CwesT = Aws::String>
    CodeVulnerabilityDetails& AddCwes(CwesT&& value) { m_cwesHasBeenSet = true; m_cwes.emplace_back(std::forward<CwesT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The ID for the Amazon CodeGuru detector associated with the finding. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru
     * Detector Library</a>.</p>
     */
    inline const Aws::String& GetDetectorId() const { return m_detectorId; }
    inline bool DetectorIdHasBeenSet() const { return m_detectorIdHasBeenSet; }
    template<typename DetectorIdT = Aws::String>
    void SetDetectorId(DetectorIdT&& value) { m_detectorIdHasBeenSet = true; m_detectorId = std::forward<DetectorIdT>(value); }
    template<typename DetectorIdT = Aws::String>
    CodeVulnerabilityDetails& WithDetectorId(DetectorIdT&& value) { SetDetectorId(std::forward<DetectorIdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of the detector used to identify the code vulnerability. For more
     * information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector
     * Library</a>.</p>
     */
    inline const Aws::String& GetDetectorName() const { return m_detectorName; }
    inline bool DetectorNameHasBeenSet() const { return m_detectorNameHasBeenSet; }
    template<typename DetectorNameT = Aws::String>
    void SetDetectorName(DetectorNameT&& value) { m_detectorNameHasBeenSet = true; m_detectorName = std::forward<DetectorNameT>(value); }
    template<typename DetectorNameT = Aws::String>
    CodeVulnerabilityDetails& WithDetectorName(DetectorNameT&& value) { SetDetectorName(std::forward<DetectorNameT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The detector tag associated with the vulnerability. Detector tags group
     * related vulnerabilities by common themes or tactics. For a list of available
     * tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java
     * tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python
     * tags</a>. </p>
     */
    inline const Aws::Vector<Aws::String>& GetDetectorTags() const { return m_detectorTags; }
    inline bool DetectorTagsHasBeenSet() const { return m_detectorTagsHasBeenSet; }
    template<typename DetectorTagsT = Aws::Vector<Aws::String>>
    void SetDetectorTags(DetectorTagsT&& value) { m_detectorTagsHasBeenSet = true; m_detectorTags = std::forward<DetectorTagsT>(value); }
    template<typename DetectorTagsT = Aws::Vector<Aws::String>>
    CodeVulnerabilityDetails& WithDetectorTags(DetectorTagsT&& value) { SetDetectorTags(std::forward<DetectorTagsT>(value)); return *this;}
    template<typename DetectorTagsT = Aws::String>
    CodeVulnerabilityDetails& AddDetectorTags(DetectorTagsT&& value) { m_detectorTagsHasBeenSet = true; m_detectorTags.emplace_back(std::forward<DetectorTagsT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>Contains information on where the code vulnerability is located in your
     * code.</p>
     */
    inline const CodeFilePath& GetFilePath() const { return m_filePath; }
    inline bool FilePathHasBeenSet() const { return m_filePathHasBeenSet; }
    template<typename FilePathT = CodeFilePath>
    void SetFilePath(FilePathT&& value) { m_filePathHasBeenSet = true; m_filePath = std::forward<FilePathT>(value); }
    template<typename FilePathT = CodeFilePath>
    CodeVulnerabilityDetails& WithFilePath(FilePathT&& value) { SetFilePath(std::forward<FilePathT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A URL containing supporting documentation about the code vulnerability
     * detected.</p>
     */
    inline const Aws::Vector<Aws::String>& GetReferenceUrls() const { return m_referenceUrls; }
    inline bool ReferenceUrlsHasBeenSet() const { return m_referenceUrlsHasBeenSet; }
    template<typename ReferenceUrlsT = Aws::Vector<Aws::String>>
    void SetReferenceUrls(ReferenceUrlsT&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = std::forward<ReferenceUrlsT>(value); }
    template<typename ReferenceUrlsT = Aws::Vector<Aws::String>>
    CodeVulnerabilityDetails& WithReferenceUrls(ReferenceUrlsT&& value) { SetReferenceUrls(std::forward<ReferenceUrlsT>(value)); return *this;}
    template<typename ReferenceUrlsT = Aws::String>
    CodeVulnerabilityDetails& AddReferenceUrls(ReferenceUrlsT&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.emplace_back(std::forward<ReferenceUrlsT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The identifier for a rule that was used to detect the code vulnerability.</p>
     */
    inline const Aws::String& GetRuleId() const { return m_ruleId; }
    inline bool RuleIdHasBeenSet() const { return m_ruleIdHasBeenSet; }
    template<typename RuleIdT = Aws::String>
    void SetRuleId(RuleIdT&& value) { m_ruleIdHasBeenSet = true; m_ruleId = std::forward<RuleIdT>(value); }
    template<typename RuleIdT = Aws::String>
    CodeVulnerabilityDetails& WithRuleId(RuleIdT&& value) { SetRuleId(std::forward<RuleIdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) of the Lambda layer that the code
     * vulnerability was detected in.</p>
     */
    inline const Aws::String& GetSourceLambdaLayerArn() const { return m_sourceLambdaLayerArn; }
    inline bool SourceLambdaLayerArnHasBeenSet() const { return m_sourceLambdaLayerArnHasBeenSet; }
    template<typename SourceLambdaLayerArnT = Aws::String>
    void SetSourceLambdaLayerArn(SourceLambdaLayerArnT&& value) { m_sourceLambdaLayerArnHasBeenSet = true; m_sourceLambdaLayerArn = std::forward<SourceLambdaLayerArnT>(value); }
    template<typename SourceLambdaLayerArnT = Aws::String>
    CodeVulnerabilityDetails& WithSourceLambdaLayerArn(SourceLambdaLayerArnT&& value) { SetSourceLambdaLayerArn(std::forward<SourceLambdaLayerArnT>(value)); return *this;}
    ///@}
  private:

    Aws::Vector<Aws::String> m_cwes;
    bool m_cwesHasBeenSet = false;

    Aws::String m_detectorId;
    bool m_detectorIdHasBeenSet = false;

    Aws::String m_detectorName;
    bool m_detectorNameHasBeenSet = false;

    Aws::Vector<Aws::String> m_detectorTags;
    bool m_detectorTagsHasBeenSet = false;

    CodeFilePath m_filePath;
    bool m_filePathHasBeenSet = false;

    Aws::Vector<Aws::String> m_referenceUrls;
    bool m_referenceUrlsHasBeenSet = false;

    Aws::String m_ruleId;
    bool m_ruleIdHasBeenSet = false;

    Aws::String m_sourceLambdaLayerArn;
    bool m_sourceLambdaLayerArnHasBeenSet = false;
  };

} // namespace Model
} // namespace Inspector2
} // namespace Aws
