/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.concurrent.Executor;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardThreadExecutor;
import org.apache.coyote.ProtocolHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public class ThreadLocalLeakPreventionListener
implements LifecycleListener,
ContainerListener {
    private static final Log log = LogFactory.getLog(ThreadLocalLeakPreventionListener.class);
    private volatile boolean serverStopping = false;
    protected static final StringManager sm = StringManager.getManager(ThreadLocalLeakPreventionListener.class);

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            Lifecycle lifecycle = lifecycleEvent.getLifecycle();
            if ("after_start".equals(lifecycleEvent.getType()) && lifecycle instanceof Server) {
                Server server = (Server)lifecycle;
                this.registerListenersForServer(server);
            }
            if ("before_stop".equals(lifecycleEvent.getType()) && lifecycle instanceof Server) {
                this.serverStopping = true;
            }
            if ("after_stop".equals(lifecycleEvent.getType()) && lifecycle instanceof Context) {
                this.stopIdleThreads((Context)lifecycle);
            }
        }
        catch (Exception exception) {
            String string = sm.getString("threadLocalLeakPreventionListener.lifecycleEvent.error", new Object[]{lifecycleEvent});
            log.error((Object)string, (Throwable)exception);
        }
    }

    @Override
    public void containerEvent(ContainerEvent containerEvent) {
        try {
            String string = containerEvent.getType();
            if ("addChild".equals(string)) {
                this.processContainerAddChild(containerEvent.getContainer(), (Container)containerEvent.getData());
            } else if ("removeChild".equals(string)) {
                this.processContainerRemoveChild(containerEvent.getContainer(), (Container)containerEvent.getData());
            }
        }
        catch (Exception exception) {
            String string = sm.getString("threadLocalLeakPreventionListener.containerEvent.error", new Object[]{containerEvent});
            log.error((Object)string, (Throwable)exception);
        }
    }

    private void registerListenersForServer(Server server) {
        for (Service service : server.findServices()) {
            Engine engine = service.getContainer();
            if (engine == null) continue;
            engine.addContainerListener(this);
            this.registerListenersForEngine(engine);
        }
    }

    private void registerListenersForEngine(Engine engine) {
        for (Container container : engine.findChildren()) {
            Host host = (Host)container;
            host.addContainerListener(this);
            this.registerListenersForHost(host);
        }
    }

    private void registerListenersForHost(Host host) {
        for (Container container : host.findChildren()) {
            Context context = (Context)container;
            this.registerContextListener(context);
        }
    }

    private void registerContextListener(Context context) {
        context.addLifecycleListener(this);
    }

    protected void processContainerAddChild(Container container, Container container2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process addChild[parent=" + container + ",child=" + container2 + "]"));
        }
        if (container2 instanceof Context) {
            this.registerContextListener((Context)container2);
        } else if (container2 instanceof Engine) {
            this.registerListenersForEngine((Engine)container2);
        } else if (container2 instanceof Host) {
            this.registerListenersForHost((Host)container2);
        }
    }

    protected void processContainerRemoveChild(Container container, Container container2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process removeChild[parent=" + container + ",child=" + container2 + "]"));
        }
        if (container2 instanceof Context) {
            Context context = (Context)container2;
            context.removeLifecycleListener(this);
        } else if (container2 instanceof Host || container2 instanceof Engine) {
            container2.removeContainerListener(this);
        }
    }

    private void stopIdleThreads(Context context) {
        if (this.serverStopping) {
            return;
        }
        if (!(context instanceof StandardContext) || !((StandardContext)context).getRenewThreadsWhenStoppingContext()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Not renewing threads when the context is stopping. It is not configured to do it.");
            }
            return;
        }
        Engine engine = (Engine)context.getParent().getParent();
        Service service = engine.getService();
        Connector[] connectorArray = service.findConnectors();
        if (connectorArray != null) {
            for (Connector connector : connectorArray) {
                Object object;
                ProtocolHandler protocolHandler = connector.getProtocolHandler();
                Executor executor = null;
                if (protocolHandler != null) {
                    executor = protocolHandler.getExecutor();
                }
                if (executor instanceof ThreadPoolExecutor) {
                    object = (ThreadPoolExecutor)executor;
                    object.contextStopping();
                    continue;
                }
                if (!(executor instanceof StandardThreadExecutor)) continue;
                object = (StandardThreadExecutor)executor;
                ((StandardThreadExecutor)object).contextStopping();
            }
        }
    }
}

