/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import jakarta.el.ELException;
import jakarta.el.MethodInfo;
import jakarta.el.MethodReference;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueReference;
import java.util.Arrays;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.ELParserTreeConstants;
import org.apache.el.parser.Node;
import org.apache.el.parser.NodeVisitor;
import org.apache.el.util.MessageFactory;

public abstract class SimpleNode
implements Node {
    protected SimpleNode parent;
    protected SimpleNode[] children;
    protected final int id;
    protected String image;

    public SimpleNode(int n) {
        this.id = n;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = (SimpleNode)node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new SimpleNode[n + 1];
        } else if (n >= this.children.length) {
            SimpleNode[] simpleNodeArray = new SimpleNode[n + 1];
            System.arraycopy(this.children, 0, simpleNodeArray, 0, this.children.length);
            this.children = simpleNodeArray;
        }
        this.children[n] = (SimpleNode)node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        if (this.image != null) {
            return ELParserTreeConstants.jjtNodeName[this.id] + "[" + this.image + "]";
        }
        return ELParserTreeConstants.jjtNodeName[this.id];
    }

    @Override
    public String getImage() {
        return this.image;
    }

    public void setImage(String string) {
        this.image = string;
    }

    @Override
    public Class<?> getType(EvaluationContext evaluationContext) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getValue(EvaluationContext evaluationContext) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReadOnly(EvaluationContext evaluationContext) throws ELException {
        return true;
    }

    @Override
    public void setValue(EvaluationContext evaluationContext, Object object) throws ELException {
        throw new PropertyNotWritableException(MessageFactory.get("error.syntax.set"));
    }

    @Override
    public void accept(NodeVisitor nodeVisitor) throws Exception {
        nodeVisitor.visit(this);
        if (this.children != null) {
            for (SimpleNode simpleNode : this.children) {
                simpleNode.accept(nodeVisitor);
            }
        }
    }

    @Override
    public Object invoke(EvaluationContext evaluationContext, Class<?>[] classArray, Object[] objectArray) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext evaluationContext, Class<?>[] classArray) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodReference getMethodReference(EvaluationContext evaluationContext) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.children);
        n = 31 * n + this.id;
        n = 31 * n + (this.image == null ? 0 : this.image.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleNode)) {
            return false;
        }
        SimpleNode simpleNode = (SimpleNode)object;
        if (this.id != simpleNode.id) {
            return false;
        }
        if (this.image == null ? simpleNode.image != null : !this.image.equals(simpleNode.image)) {
            return false;
        }
        return Arrays.equals(this.children, simpleNode.children);
    }

    @Override
    public ValueReference getValueReference(EvaluationContext evaluationContext) {
        return null;
    }

    @Override
    public boolean isParametersProvided() {
        return false;
    }
}

