/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CopyableThrowable;
import kotlinx.coroutines.internal.ClassValueCtorCache;
import kotlinx.coroutines.internal.CtorCache;
import kotlinx.coroutines.internal.ExceptionsConstructorKt;
import kotlinx.coroutines.internal.FastServiceLoaderKt;
import kotlinx.coroutines.internal.WeakMapCtorCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a2\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005j\u0002`\u0007\"\b\b\u0000\u0010\b*\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0002\u001a*\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005j\u0004\u0018\u0001`\u00072\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u001a1\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005j\u0002`\u00072\u0014\b\u0004\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0082\b\u001a!\u0010\u0010\u001a\u0004\u0018\u0001H\b\"\b\b\u0000\u0010\b*\u00020\u00062\u0006\u0010\u0011\u001a\u0002H\bH\u0000\u00a2\u0006\u0002\u0010\u0012\u001a\u001b\u0010\u0013\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\n2\b\b\u0002\u0010\u0014\u001a\u00020\u0003H\u0082\u0010\u001a\u0018\u0010\u0015\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000*(\b\u0002\u0010\u0017\"\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a8\u0006\u0018"}, d2={"ctorCache", "Lkotlinx/coroutines/internal/CtorCache;", "throwableFields", "", "createConstructor", "Lkotlin/Function1;", "", "Lkotlinx/coroutines/internal/Ctor;", "E", "clz", "Ljava/lang/Class;", "createSafeConstructor", "constructor", "Ljava/lang/reflect/Constructor;", "safeCtor", "block", "tryCopyException", "exception", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "fieldsCount", "accumulator", "fieldsCountOrDefault", "defaultValue", "Ctor", "kotlinx-coroutines-core"})
public final class ExceptionsConstructorKt {
    private static final int throwableFields;
    @NotNull
    private static final CtorCache ctorCache;

    @Nullable
    public static final <E extends Throwable> E tryCopyException(@NotNull E exception) {
        if (exception instanceof CopyableThrowable) {
            Object object;
            try {
                boolean bl = false;
                object = Result.constructor-impl(((CopyableThrowable)((Object)exception)).createCopy());
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            return (E)((Throwable)(Result.isFailure-impl(object) ? null : object));
        }
        return (E)ctorCache.get(exception.getClass()).invoke(exception);
    }

    private static final <E extends Throwable> Function1<Throwable, Throwable> createConstructor(Class<E> clz) {
        Function1 nullResult2 = createConstructor.nullResult.1.INSTANCE;
        if (throwableFields != ExceptionsConstructorKt.fieldsCountOrDefault(clz, 0)) {
            return nullResult2;
        }
        Constructor<?>[] $this$sortedByDescending$iv = clz.getConstructors();
        boolean $i$f$sortedByDescending = false;
        List<Constructor<?>> constructors2 = ArraysKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Constructor it = (Constructor)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getParameterTypes().length);
                it = (Constructor)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getParameterTypes().length);
            }
        });
        for (Constructor<?> constructor : constructors2) {
            Function1<Throwable, Throwable> result2 = ExceptionsConstructorKt.createSafeConstructor(constructor);
            if (result2 == null) continue;
            return result2;
        }
        return nullResult2;
    }

    private static final Function1<Throwable, Throwable> createSafeConstructor(Constructor<?> constructor) {
        Function1 function1;
        Class<?>[] p = constructor.getParameterTypes();
        switch (p.length) {
            case 2: {
                if (Intrinsics.areEqual(p[0], String.class) && Intrinsics.areEqual(p[1], Throwable.class)) {
                    boolean $i$f$safeCtor = false;
                    function1 = new Function1<Throwable, Throwable>(constructor){
                        final /* synthetic */ Constructor $constructor$inlined;
                        {
                            this.$constructor$inlined = constructor;
                            super(1);
                        }

                        @Nullable
                        public final Throwable invoke(@NotNull Throwable e) {
                            Object object;
                            try {
                                boolean bl = false;
                                Throwable e2 = e;
                                boolean bl2 = false;
                                Object[] objectArray = new Object[]{e2.getMessage(), e2};
                                T t = this.$constructor$inlined.newInstance(objectArray);
                                if (t == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                                }
                                object = Result.constructor-impl((Throwable)t);
                            }
                            catch (Throwable throwable) {
                                object = Result.constructor-impl(ResultKt.createFailure(throwable));
                            }
                            Object object2 = object;
                            return (Throwable)(Result.isFailure-impl(object2) ? null : object2);
                        }
                    };
                    break;
                }
                function1 = null;
                break;
            }
            case 1: {
                Class<?> $i$f$safeCtor = p[0];
                if (Intrinsics.areEqual($i$f$safeCtor, Throwable.class)) {
                    boolean $i$f$safeCtor2 = false;
                    function1 = new Function1<Throwable, Throwable>(constructor){
                        final /* synthetic */ Constructor $constructor$inlined;
                        {
                            this.$constructor$inlined = constructor;
                            super(1);
                        }

                        @Nullable
                        public final Throwable invoke(@NotNull Throwable e) {
                            Object object;
                            try {
                                boolean bl = false;
                                Throwable e2 = e;
                                boolean bl2 = false;
                                Object[] objectArray = new Object[]{e2};
                                T t = this.$constructor$inlined.newInstance(objectArray);
                                if (t == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                                }
                                object = Result.constructor-impl((Throwable)t);
                            }
                            catch (Throwable throwable) {
                                object = Result.constructor-impl(ResultKt.createFailure(throwable));
                            }
                            Object object2 = object;
                            return (Throwable)(Result.isFailure-impl(object2) ? null : object2);
                        }
                    };
                    break;
                }
                if (Intrinsics.areEqual($i$f$safeCtor, String.class)) {
                    boolean $i$f$safeCtor3 = false;
                    function1 = new Function1<Throwable, Throwable>(constructor){
                        final /* synthetic */ Constructor $constructor$inlined;
                        {
                            this.$constructor$inlined = constructor;
                            super(1);
                        }

                        @Nullable
                        public final Throwable invoke(@NotNull Throwable e) {
                            Object object;
                            try {
                                Throwable throwable;
                                boolean bl = false;
                                Throwable e2 = e;
                                boolean bl2 = false;
                                Object[] objectArray = new Object[]{e2.getMessage()};
                                T t = this.$constructor$inlined.newInstance(objectArray);
                                if (t == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                                }
                                Throwable it = throwable = (Throwable)t;
                                boolean bl3 = false;
                                it.initCause(e2);
                                object = Result.constructor-impl(throwable);
                            }
                            catch (Throwable throwable) {
                                object = Result.constructor-impl(ResultKt.createFailure(throwable));
                            }
                            Object object2 = object;
                            return (Throwable)(Result.isFailure-impl(object2) ? null : object2);
                        }
                    };
                    break;
                }
                function1 = null;
                break;
            }
            case 0: {
                boolean $i$f$safeCtor = false;
                function1 = new Function1<Throwable, Throwable>(constructor){
                    final /* synthetic */ Constructor $constructor$inlined;
                    {
                        this.$constructor$inlined = constructor;
                        super(1);
                    }

                    @Nullable
                    public final Throwable invoke(@NotNull Throwable e) {
                        Object object;
                        try {
                            Throwable throwable;
                            boolean bl = false;
                            Throwable e2 = e;
                            boolean bl2 = false;
                            T t = this.$constructor$inlined.newInstance(new Object[0]);
                            if (t == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                            }
                            Throwable it = throwable = (Throwable)t;
                            boolean bl3 = false;
                            it.initCause(e2);
                            object = Result.constructor-impl(throwable);
                        }
                        catch (Throwable throwable) {
                            object = Result.constructor-impl(ResultKt.createFailure(throwable));
                        }
                        Object object2 = object;
                        return (Throwable)(Result.isFailure-impl(object2) ? null : object2);
                    }
                };
                break;
            }
            default: {
                function1 = null;
            }
        }
        return function1;
    }

    private static final Function1<Throwable, Throwable> safeCtor(Function1<? super Throwable, ? extends Throwable> block) {
        boolean $i$f$safeCtor = false;
        return new Function1<Throwable, Throwable>(block){
            final /* synthetic */ Function1<Throwable, Throwable> $block;
            {
                this.$block = $block;
                super(1);
            }

            @Nullable
            public final Throwable invoke(@NotNull Throwable e) {
                Object object;
                Object object2 = this.$block;
                try {
                    boolean bl = false;
                    object = Result.constructor-impl(object2.invoke((Throwable)e));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                object2 = object;
                return (Throwable)(Result.isFailure-impl(object2) ? null : object2);
            }
        };
    }

    private static final int fieldsCountOrDefault(Class<?> $this$fieldsCountOrDefault, int defaultValue) {
        Object object;
        Object object2 = JvmClassMappingKt.getKotlinClass($this$fieldsCountOrDefault);
        try {
            KClass<?> $this$fieldsCountOrDefault_u24lambda_u2d8 = object2;
            boolean bl = false;
            object = Result.constructor-impl(ExceptionsConstructorKt.fieldsCount$default($this$fieldsCountOrDefault, 0, 1, null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        object = defaultValue;
        return ((Number)(Result.isFailure-impl(object2) ? object : object2)).intValue();
    }

    private static final int fieldsCount(Class<?> $this$fieldsCount, int accumulator) {
        Class<?> clazz = $this$fieldsCount;
        int n = accumulator;
        while (true) {
            Class<?> superClass;
            Class<?> clazz2 = clazz;
            int n2 = n;
            Field[] $this$count$iv = clazz2.getDeclaredFields();
            boolean $i$f$count = false;
            int count$iv = 0;
            for (Field element$iv : $this$count$iv) {
                Field it = element$iv;
                boolean bl = false;
                if (!(!Modifier.isStatic(it.getModifiers()))) continue;
                ++count$iv;
            }
            int fieldsCount = count$iv;
            int totalFields = n2 + fieldsCount;
            if (clazz2.getSuperclass() == null) {
                return totalFields;
            }
            clazz = superClass;
            n = totalFields;
        }
    }

    static /* synthetic */ int fieldsCount$default(Class clazz, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ExceptionsConstructorKt.fieldsCount(clazz, n);
    }

    public static final /* synthetic */ Function1 access$createConstructor(Class clz) {
        return ExceptionsConstructorKt.createConstructor(clz);
    }

    static {
        CtorCache ctorCache;
        throwableFields = ExceptionsConstructorKt.fieldsCountOrDefault(Throwable.class, -1);
        try {
            ctorCache = FastServiceLoaderKt.getANDROID_DETECTED() ? (CtorCache)WeakMapCtorCache.INSTANCE : (CtorCache)ClassValueCtorCache.INSTANCE;
        }
        catch (Throwable e) {
            ctorCache = WeakMapCtorCache.INSTANCE;
        }
        ExceptionsConstructorKt.ctorCache = ctorCache;
    }
}

