# https://github.com/advisories/GHSA-qcm3-vfq5-wfr2
# https://github.com/e23e/CVE-2023-31606#readme
# https://github.com/jgarber/redcloth/issues/73
# https://github.com/jgarber/redcloth/pull/75

require 'redcloth'

describe 'CVE-2023-31606' do

  it 'process malicious html without delay' do
    # INFO (Helio): inside RedCloth repo, running `$ bundle exec rspec .`, with the test below, I can't replicate,
    # on my development machine, the time spent on this sample text.
    # However, on the same development machine, when I run this test this code, in a test-redcloth-regexp.rb script, in a rails app
    # with `gem 'RedCloth'` in it, I was able to get the results indicated in the issue (https://github.com/jgarber/redcloth/issues/73),
    # by https://github.com/e23e
    # Here are the outputs:
    # hac@MBP tcard % time ruby test-redcloth-regexp.rb
    # 0.158047
    # ruby test-redcloth-regexp.rb  0.12s user 0.11s system 82% cpu 0.279 total
    # hac@MBP tcard % time ruby test-redcloth-regexp.rb
    # 18.457945
    # ruby test-redcloth-regexp.rb  18.32s user 0.22s system 99% cpu 18.556 total
    # hac@MBP tcard % cat !$
    # cat test-redcloth-regexp.rb
    # require 'RedCloth'
    # text = '<A' + 'A' * (54773)
    # t1 = Time.now
    # text = RedCloth.new(text, [:sanitize_html]).to_html
    # t2 = Time.now
    # puts (t2-t1)
    # hac@MBP tcard %

    text = '<A' + 'A' * (54773)

    t1 = Time.now
    res = RedCloth.new(text, [:sanitize_html]).to_html
    t2 = Time.now

    expect(t2-t1).to be <= 3
  end

  it 'should keep the generated HTML the same' do
    text = "<a href=https://example.com> Example </a>"
    result = RedCloth.new(text, [:sanitize_html]).to_html

    expect(result).to eq("<p><a href=\"https://example.com\"> Example </a></p>")
  end

end
