# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the GherkinDocument message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # *
    #  The [AST](https://en.wikipedia.org/wiki/Abstract_syntax_tree) of a Gherkin document.
    #  Cucumber implementations should *not* depend on `GherkinDocument` or any of its
    #  children for execution - use [Pickle](#io.cucumber.messages.Pickle) instead.
    #
    #  The only consumers of `GherkinDocument` should only be formatters that produce
    #  "rich" output, resembling the original Gherkin document.
    ##
    class GherkinDocument < Message
      ##
      # *
      #  The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
      #  of the source, typically a file path relative to the root directory
      ##
      attr_reader :uri

      attr_reader :feature

      ##
      # All the comments in the Gherkin document
      ##
      attr_reader :comments

      def initialize(
        uri: nil,
        feature: nil,
        comments: []
      )
        @uri = uri
        @feature = feature
        @comments = comments
        super()
      end

      ##
      # Returns a new GherkinDocument from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::GherkinDocument.from_h(some_hash) # => #<Cucumber::Messages::GherkinDocument:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          uri: hash[:uri],
          feature: Feature.from_h(hash[:feature]),
          comments: hash[:comments]&.map { |item| Comment.from_h(item) }
        )
      end
    end
  end
end
