/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredAxiomGenerator;

public abstract class InferredEntityAxiomGenerator<E extends OWLEntity, A extends OWLAxiom>
implements InferredAxiomGenerator<A> {
    @Override
    public Set<A> createAxioms(@Nonnull OWLDataFactory df, @Nonnull OWLReasoner reasoner) {
        HashSet<OWLEntity> processedEntities = new HashSet<OWLEntity>();
        HashSet result = new HashSet();
        for (OWLOntology ont : reasoner.getRootOntology().getImportsClosure()) {
            assert (ont != null);
            for (OWLEntity entity : this.getEntities(ont)) {
                assert (entity != null);
                if (processedEntities.contains(entity)) continue;
                processedEntities.add(entity);
                this.addAxioms(entity, reasoner, df, result);
            }
        }
        return result;
    }

    protected abstract void addAxioms(@Nonnull E var1, @Nonnull OWLReasoner var2, @Nonnull OWLDataFactory var3, @Nonnull Set<A> var4);

    @Nonnull
    protected abstract Set<E> getEntities(@Nonnull OWLOntology var1);

    protected Set<E> getAllEntities(OWLReasoner reasoner) {
        HashSet<E> results = new HashSet<E>();
        for (OWLOntology ont : reasoner.getRootOntology().getImportsClosure()) {
            assert (ont != null);
            results.addAll(this.getEntities(ont));
        }
        return results;
    }

    public String toString() {
        return this.getLabel();
    }
}

