/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import java.awt.Color;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.eclipse.core.runtime.IExtension;
import org.protege.editor.core.PropertyUtil;
import org.protege.editor.core.plugin.ExtensionInstantiator;
import org.protege.editor.core.plugin.JPFUtil;
import org.protege.editor.core.plugin.PluginProperties;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.workspace.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewComponentPluginJPFImpl
implements ViewComponentPlugin {
    private static final Logger logger = LoggerFactory.getLogger(ViewComponentPluginJPFImpl.class);
    public static final String ID = "ViewComponent";
    public static final String LABEL_PARAM = "label";
    public static final String LOCATION_PARAM = "location";
    public static final String WORKSPACE_TAB_ID_PARAM = "workspaceTabId";
    public static final String HEADER_COLOR_PARAM = "headerColor";
    public static final String USER_CREATABLE_PARAM = "userCreatable";
    public static final String CATEGORY = "category";
    public static final String NAVIGATES = "navigates";
    private IExtension extension;
    private Workspace workspace;
    private static final Color DEFAULT_COLOR = Color.LIGHT_GRAY;

    public ViewComponentPluginJPFImpl(Workspace workspace, IExtension extension) {
        this.extension = extension;
        this.workspace = workspace;
    }

    @Override
    public String getId() {
        return this.extension.getUniqueIdentifier();
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public String getDocumentation() {
        return JPFUtil.getDocumentation(this.extension);
    }

    @Override
    public String getLabel() {
        return PluginProperties.getParameterValue(this.extension, LABEL_PARAM, "<Error! No label defined>");
    }

    @Override
    public boolean isUserCreatable() {
        return PluginProperties.getBooleanParameterValue(this.extension, USER_CREATABLE_PARAM, true);
    }

    @Override
    public Color getBackgroundColor() {
        String val = PluginProperties.getParameterValue(this.extension, HEADER_COLOR_PARAM, null);
        if (val != null) {
            return PropertyUtil.getColor(val, DEFAULT_COLOR);
        }
        return DEFAULT_COLOR;
    }

    @Override
    public Set<String> getCategorisations() {
        return PluginProperties.getParameterValues(this.extension, CATEGORY);
    }

    @Override
    public Set<String> getNavigates() {
        return PluginProperties.getParameterValues(this.extension, NAVIGATES);
    }

    @Override
    @Nonnull
    public Optional<URI> getHelpLink() {
        return Optional.ofNullable(PluginProperties.getParameterValue(this.extension, "help", null)).flatMap(u -> {
            try {
                return Optional.of(new URI((String)u));
            }
            catch (URISyntaxException e) {
                logger.warn("Malformed help URL ({}): {}", u, (Object)e.getMessage());
                return Optional.empty();
            }
        });
    }

    @Override
    public ViewComponent newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ExtensionInstantiator instantiator = new ExtensionInstantiator(this.extension);
        ViewComponent viewComponent = (ViewComponent)instantiator.instantiate();
        viewComponent.setup(this);
        return viewComponent;
    }
}

