/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.identifiers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.protege.editor.owl.model.identifiers.IdoNamespace;
import org.protege.editor.owl.model.identifiers.IdoResolvedResource;
import org.protege.editor.owl.model.identifiers.IdoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifiersDotOrg {
    private static Logger logger = LoggerFactory.getLogger(IdentifiersDotOrg.class);
    @Nonnull
    private final HttpClient client;
    @Nonnull
    private final ObjectMapper objectMapper;
    private Multimap<String, IdoNamespace> byPrefix = HashMultimap.create();

    private IdentifiersDotOrg(@Nonnull HttpClient client, @Nonnull ObjectMapper objectMapper) {
        this.client = client;
        this.objectMapper = objectMapper;
    }

    public static IdentifiersDotOrg create() {
        HttpClient client = IdentifiersDotOrg.createClient();
        ObjectMapper objectMapper = IdentifiersDotOrg.createObjectMapper();
        IdentifiersDotOrg identifiersDotOrg = new IdentifiersDotOrg(client, objectMapper);
        identifiersDotOrg.buildCache();
        return identifiersDotOrg;
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new GuavaModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    private void buildCache() {
        this.getCollections().forEach(c -> {
            String lowerCasePrefix = c.getPrefix().toLowerCase();
            this.byPrefix.put((Object)lowerCasePrefix, c);
        });
    }

    @Nonnull
    public Optional<IdoNamespace> getCollection(@Nonnull String compactId) {
        String[] split = compactId.split(":");
        if (split.length != 2) {
            return Optional.empty();
        }
        String prefix = split[0];
        String id = split[1];
        return this.byPrefix.get((Object)prefix.toLowerCase()).stream().filter(c -> id.matches(c.getPattern()) || compactId.matches(c.getPattern())).findFirst();
    }

    @Nonnull
    public Optional<IdoResolvedResource> resolveCompactId(@Nonnull String compactId) {
        String url = String.format("https://resolver.api.identifiers.org/%s", compactId);
        HttpGet httpGet = new HttpGet(url);
        try {
            HttpResponse response = this.client.execute(httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                InputStream contentInputStream = response.getEntity().getContent();
                IdoResponse idoResponse = this.objectMapper.readValue(contentInputStream, IdoResponse.class);
                JsonNode payload = idoResponse.getPayload();
                JsonNode resolvedResourcesNode = payload.path("resolvedResources");
                List resolvedResources = (List)this.objectMapper.convertValue((Object)resolvedResourcesNode, new TypeReference<List<IdoResolvedResource>>(){});
                return resolvedResources.stream().findFirst();
            }
            logger.debug("[IdentifiersDotOrg] Error code returned by identifiers.org {}", (Object)response.getStatusLine());
            return Optional.empty();
        }
        catch (IOException e) {
            logger.warn("Error resolving compact id at identifiers.org", (Throwable)e);
            return Optional.empty();
        }
    }

    @Nonnull
    public List<IdoNamespace> getCollections() {
        try {
            HttpGet httpGet;
            HttpResponse response;
            ImmutableList.Builder builder = ImmutableList.builder();
            int pageSize = 1000;
            String url = String.format("https://registry.api.identifiers.org/restApi/namespaces?page=0&size=%s", pageSize);
            while (url != null && (response = this.client.execute(httpGet = new HttpGet(url))).getStatusLine().getStatusCode() == 200) {
                InputStream contentInputStream = response.getEntity().getContent();
                JsonNode idoResponse = this.objectMapper.readValue(contentInputStream, JsonNode.class);
                JsonNode namespaces = idoResponse.path("_embedded").path("namespaces");
                List collections = (List)this.objectMapper.convertValue((Object)namespaces, new TypeReference<List<IdoNamespace>>(){});
                builder.addAll((Iterable)collections);
                url = this.objectMapper.convertValue((Object)idoResponse.path("_links").path("next").path("href"), String.class);
            }
            return builder.build();
        }
        catch (IOException e) {
            logger.warn("[IdentifiersDotOrg] Error retrieving identifiers.org namespaces: {}", (Object)e.getMessage());
            return ImmutableList.of();
        }
    }

    @Nonnull
    private static HttpClient createClient() {
        return HttpClientBuilder.create().build();
    }
}

