"use strict";
/* eslint-disable valid-jsdoc */
/**
 * penguins-eggs-v7
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = tslib_1.__importDefault(require("chalk"));
const pjson = require('../../package.json');
/**
 * Utils: general porpourse utils
 * @remarks all the utilities
 */
class Utils {
    /**
     *
     * @param verbose
     */
    static setEcho(verbose = false) {
        let echo = { echo: false, ignore: true };
        if (verbose) {
            echo = { echo: true, ignore: false };
        }
        return echo;
    }
    /**
      *
      * @param command
      */
    static titles(command = '') {
        console.clear();
        // font: console, block, simpleBlock, simple, 3d, simple3d, chrome, huge, shade, slick, grid, pallet, tiny
        // cfonts.say('Perri\'s brewery', { font: 'tiny' })
        console.log('===========================');
        console.log('>>> P E R R I\'s brewery <<<');
        console.log('===========================');
        console.log(chalk_1.default.bgGreen.whiteBright('      ' + pjson.name + '      ')
            + chalk_1.default.bgWhite.blue('  man & scripts in .deb  ')
            + chalk_1.default.bgRed.whiteBright('       ver. ' + pjson.version + '       '));
        console.log('command: ' + chalk_1.default.bgBlack.white(command) + '\n');
    }
}
exports.default = Utils;
