/*!
 * ${copyright}
 */

sap.ui.define([], function() {
	"use strict";
	return {
			context: "sap.card",
			properties: {
				title: {
					label: "Title",
					type: "string",
					path: "header/title",
					maxLength: 40
				},
				subTitle: {
					label: "Description",
					type: "string",
					path: "header/subTitle",
					maxLength: 40
				},
				icon: {
					label: "Icon",
					type: "icon",
					path: "header/icon/src"
				},
				city: {
					label: "City",
					type: "enum",
					path: "configuration/parameters/city",
					enum: [
						"Singapore",
						"Shanghai",
						"Walldorf",
						"Philadelphia",
						"Montreal",
						"Vancouver",
						"San Francisco",
						"Beijing"
					],
					default: "None"
				}
			},
			propertyEditors: {
				"string" : "sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor",
				"icon" : "sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IconEditor",
				"enum" : "sap/ui/integration/designtime/baseEditor/propertyEditor/enumStringEditor/EnumStringEditor"
			}
		};
	}
);
