/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.profile.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.FaultString;
import org.slf4j.Logger;

public class AddSOAPFault
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddSOAPFault.class);
    @Nullable
    private Function<ProfileRequestContext, Fault> contextFaultStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> detailedErrorsCondition = PredicateSupport.alwaysFalse();
    @Nullable
    private Function<ProfileRequestContext, QName> faultCodeLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> faultStringLookupStrategy;
    @Nonnull
    private QName defaultFaultCode = FaultCode.SERVER;
    @Nullable
    private String faultString;
    private boolean detailedErrors = false;
    private boolean nullifyOutboundMessage = true;

    public AddSOAPFault() {
        this.contextFaultStrategy = new MessageContextFaultStrategy();
    }

    public void setNullifyOutboundMessage(boolean flag) {
        this.nullifyOutboundMessage = flag;
    }

    public void setContextFaultStrategy(@Nullable Function<ProfileRequestContext, Fault> strategy) {
        this.checkSetterPreconditions();
        this.contextFaultStrategy = strategy;
    }

    public void setDetailedErrorsCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.detailedErrorsCondition = (Predicate)Constraint.isNotNull(condition, (String)"Detailed errors condition cannot be null");
    }

    public void setFaultCodeLookupStrategy(@Nullable Function<ProfileRequestContext, QName> strategy) {
        this.checkSetterPreconditions();
        this.faultCodeLookupStrategy = strategy;
    }

    public void setFaultStringLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.faultStringLookupStrategy = strategy;
    }

    public void setFaultCode(@Nonnull QName code) {
        this.checkSetterPreconditions();
        this.defaultFaultCode = (QName)Constraint.isNotNull((Object)code, (String)"Faultcode cannot be null");
    }

    public void setFaultString(@Nullable String message) {
        this.checkSetterPreconditions();
        this.faultString = StringSupport.trimOrNull((String)message);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.checkComponentActive();
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.detailedErrors = this.detailedErrorsCondition.test(profileRequestContext);
        this.log.debug("{} Detailed errors are {}", (Object)this.getLogPrefix(), (Object)(this.detailedErrors ? "enabled" : "disabled"));
        MessageContext mc = profileRequestContext.getOutboundMessageContext();
        if (mc != null && this.nullifyOutboundMessage) {
            mc.setMessage(null);
        } else {
            profileRequestContext.setOutboundMessageContext(new MessageContext());
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Fault fault = this.resolveContextFault(profileRequestContext);
        if (fault == null) {
            fault = this.buildNewMappedFault(profileRequestContext);
        }
        SOAPMessagingSupport.registerSOAP11Fault((MessageContext)profileRequestContext.ensureOutboundMessageContext(), (Fault)fault);
    }

    @Nullable
    private Fault resolveContextFault(ProfileRequestContext profileRequestContext) {
        if (this.contextFaultStrategy == null) {
            return null;
        }
        assert (this.contextFaultStrategy != null);
        Fault fault = this.contextFaultStrategy.apply(profileRequestContext);
        if (fault != null) {
            this.log.debug("{} Resolved Fault instance via context strategy", (Object)this.getLogPrefix());
            if (fault.getCode() == null) {
                this.log.debug("{} Resolved Fault contained no FaultCode, using configured default", (Object)this.getLogPrefix());
                XMLObjectBuilder faultCodeBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(FaultCode.DEFAULT_ELEMENT_NAME);
                FaultCode code = (FaultCode)faultCodeBuilder.buildObject(FaultCode.DEFAULT_ELEMENT_NAME);
                code.setValue(this.defaultFaultCode);
                fault.setCode(code);
            }
            if (!this.detailedErrors) {
                this.log.debug("{} Removing any detailed error info from context Fault instance", (Object)this.getLogPrefix());
                if (this.faultString != null) {
                    this.buildFaultString(fault, this.faultString);
                } else {
                    fault.setMessage(null);
                }
                fault.setDetail(null);
                fault.setActor(null);
            }
        } else {
            this.log.debug("{} Failed to resolve any Fault instance via context strategy", (Object)this.getLogPrefix());
        }
        return fault;
    }

    @Nonnull
    private Fault buildNewMappedFault(ProfileRequestContext profileRequestContext) {
        XMLObjectBuilder faultBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Fault.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder faultCodeBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(FaultCode.DEFAULT_ELEMENT_NAME);
        Fault fault = (Fault)faultBuilder.buildObject(Fault.DEFAULT_ELEMENT_NAME);
        FaultCode code = (FaultCode)faultCodeBuilder.buildObject(FaultCode.DEFAULT_ELEMENT_NAME);
        if (this.faultCodeLookupStrategy != null) {
            QName fc = this.faultCodeLookupStrategy.apply(profileRequestContext);
            if (fc == null) {
                code.setValue(this.defaultFaultCode);
            } else {
                code.setValue(fc);
            }
        } else {
            code.setValue(this.defaultFaultCode);
        }
        fault.setCode(code);
        if (!this.detailedErrors || this.faultStringLookupStrategy == null) {
            if (this.faultString != null) {
                this.buildFaultString(fault, this.faultString);
                this.log.debug("{} Setting faultstring to defaulted value", (Object)this.getLogPrefix());
            }
        } else if (this.faultStringLookupStrategy != null) {
            String message = this.faultStringLookupStrategy.apply(profileRequestContext);
            if (message != null) {
                this.log.debug("{} Current state of request was mappable, setting faultstring to mapped value", (Object)this.getLogPrefix());
                this.buildFaultString(fault, message);
            } else if (this.faultString != null) {
                this.buildFaultString(fault, this.faultString);
                this.log.debug("{} Current state of request was not mappable, setting faultstring to defaulted value", (Object)this.getLogPrefix());
            }
        }
        return fault;
    }

    private void buildFaultString(@Nonnull Fault fault, @Nonnull @NotEmpty String message) {
        XMLObjectBuilder faultStringBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(FaultString.DEFAULT_ELEMENT_NAME);
        FaultString fs = (FaultString)faultStringBuilder.buildObject(FaultString.DEFAULT_ELEMENT_NAME);
        fs.setValue(message);
        fault.setMessage(fs);
    }

    public static class MessageContextFaultStrategy
    implements Function<ProfileRequestContext, Fault> {
        @Nonnull
        private Logger log = LoggerFactory.getLogger(MessageContextFaultStrategy.class);

        @Override
        @Nullable
        public Fault apply(@Nullable ProfileRequestContext input) {
            if (input == null) {
                return null;
            }
            Fault fault = null;
            MessageContext outbound = input.getOutboundMessageContext();
            if (outbound != null && (fault = SOAPMessagingSupport.getSOAP11Fault((MessageContext)outbound)) != null) {
                this.log.debug("Found registered SOAP fault in outbound message context");
                return fault;
            }
            MessageContext inbound = input.getInboundMessageContext();
            if (inbound != null && (fault = SOAPMessagingSupport.getSOAP11Fault((MessageContext)inbound)) != null) {
                this.log.debug("Found registered SOAP fault in inbound message context");
                return fault;
            }
            return null;
        }
    }

    public static class FaultCodeMappingFunction
    implements Function<ProfileRequestContext, QName> {
        @Nonnull
        private Map<String, QName> codeMappings;
        @Nonnull
        private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy;

        public FaultCodeMappingFunction(@Nonnull Map<String, QName> mappings) {
            Constraint.isNotNull(mappings, (String)"Faultcode mappings cannot be null");
            this.codeMappings = new HashMap<String, QName>(mappings.size());
            for (Map.Entry<String, QName> entry : mappings.entrySet()) {
                String event = StringSupport.trimOrNull((String)entry.getKey());
                if (event == null || entry.getValue() == null) continue;
                this.codeMappings.put(event, entry.getValue());
            }
            this.eventContextLookupStrategy = new CurrentOrPreviousEventLookup();
        }

        public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
            this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
        }

        @Override
        @Nullable
        public QName apply(@Nullable ProfileRequestContext input) {
            Object event;
            EventContext eventCtx = this.eventContextLookupStrategy.apply(input);
            Object object = event = eventCtx != null ? eventCtx.getEvent() : null;
            if (event != null) {
                return this.codeMappings.get(event.toString());
            }
            return null;
        }
    }
}

