/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.NamedRoute;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.filter.SecurityRequestFactory;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.ssl.util.SSLRequestHelper;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.node.NodeClient;

public class SecurityWhoAmIAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/whoami"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/whoami"), (Object)new NamedRoute.Builder().method(RestRequest.Method.GET).path("/whoamiprotected").uniqueName("security:whoamiprotected").legacyActionNames(Set.of("cluster:admin/opendistro_security/whoamiprotected")).build()), "/_plugins/_security");
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final AdminDNs adminDns;
    private final Settings settings;
    private final Path configPath;
    private final PrincipalExtractor principalExtractor;
    private final List<String> nodesDn;

    public SecurityWhoAmIAction(Settings settings, RestController controller, ThreadPool threadPool, AdminDNs adminDns, Path configPath, PrincipalExtractor principalExtractor) {
        this.adminDns = adminDns;
        this.settings = settings;
        this.configPath = configPath;
        this.principalExtractor = principalExtractor;
        this.nodesDn = settings.getAsList("plugins.security.nodes_dn", Collections.emptyList());
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(SecurityWhoAmIAction.this.settings, SecurityWhoAmIAction.this.configPath, SecurityRequestFactory.from(request), SecurityWhoAmIAction.this.principalExtractor);
                    if (sslInfo == null) {
                        response = new BytesRestResponse(RestStatus.FORBIDDEN, "No security data");
                    } else {
                        String dn = sslInfo.getPrincipal();
                        boolean isAdmin = SecurityWhoAmIAction.this.adminDns.isAdminDN(dn);
                        boolean isNodeCertificateRequest = dn != null && WildcardMatcher.from(SecurityWhoAmIAction.this.nodesDn, true).matchAny(dn);
                        builder.startObject();
                        builder.field("dn", dn);
                        builder.field("is_admin", isAdmin);
                        builder.field("is_node_certificate_request", isNodeCertificateRequest);
                        builder.endObject();
                        response = new BytesRestResponse(RestStatus.OK, builder);
                    }
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "Security Plugin Who am i";
    }
}

