/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.neuralsearch.query.HybridBulkScorer;

public class HybridQueryDocIdStream
extends DocIdStream {
    private static final int BLOCK_SHIFT = 6;
    private final HybridBulkScorer hybridBulkScorer;
    private int base;
    private int upTo;

    public void forEach(int upTo, CheckedIntConsumer<IOException> consumer) throws IOException {
        upTo = Math.min(upTo, this.hybridBulkScorer.getMaxDoc());
        FixedBitSet matchingBitSet = this.hybridBulkScorer.getMatching();
        long[] bitArray = matchingBitSet.getBits();
        for (int idx = 0; idx < bitArray.length; ++idx) {
            int numberOfTrailingZeros;
            for (long bits = bitArray[idx]; bits != 0L; bits ^= 1L << numberOfTrailingZeros) {
                numberOfTrailingZeros = Long.numberOfTrailingZeros(bits);
                int docIndexInWindow = idx << 6 | numberOfTrailingZeros;
                float[][] windowScores = this.hybridBulkScorer.getWindowScores();
                for (int subQueryIndex = 0; subQueryIndex < windowScores.length; ++subQueryIndex) {
                    float scoreOfDocIdForSubQuery;
                    if (Objects.isNull(windowScores[subQueryIndex])) continue;
                    this.hybridBulkScorer.getHybridSubQueryScorer().getSubQueryScores()[subQueryIndex] = scoreOfDocIdForSubQuery = windowScores[subQueryIndex][docIndexInWindow];
                }
                int doc = this.base | docIndexInWindow;
                if (doc < upTo + this.base) {
                    consumer.accept(doc);
                    ++this.upTo;
                }
                this.hybridBulkScorer.getHybridSubQueryScorer().resetScores();
            }
        }
    }

    public int count(int upTo) throws IOException {
        int[] count = new int[1];
        this.forEach(upTo, (CheckedIntConsumer<IOException>)((CheckedIntConsumer)doc -> {
            count[0] = count[0] + 1;
        }));
        return count[0];
    }

    public boolean mayHaveRemaining() {
        return this.upTo + 1 < this.hybridBulkScorer.getMaxDoc();
    }

    public void setBase(int base) {
        this.base = base;
        this.upTo = base;
    }

    @Generated
    public HybridQueryDocIdStream(HybridBulkScorer hybridBulkScorer) {
        this.hybridBulkScorer = hybridBulkScorer;
    }
}

