/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss.binary;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.store.IndexInput;
import org.opensearch.knn.memoryoptsearch.faiss.FaissHNSW;
import org.opensearch.knn.memoryoptsearch.faiss.FaissHNSWProvider;
import org.opensearch.knn.memoryoptsearch.faiss.FaissIndex;
import org.opensearch.knn.memoryoptsearch.faiss.FaissIndexLoadUtils;
import org.opensearch.knn.memoryoptsearch.faiss.binary.FaissBinaryIndex;

public class FaissBinaryHnswIndex
extends FaissBinaryIndex
implements FaissHNSWProvider {
    public static final String IBHF = "IBHf";
    private FaissHNSW faissHnsw = new FaissHNSW();
    private FaissBinaryIndex storage;

    public FaissBinaryHnswIndex() {
        super(IBHF);
    }

    @Override
    protected void doLoad(IndexInput input) throws IOException {
        this.readBinaryCommonHeader(input);
        this.faissHnsw.load(input, this.getTotalNumberOfVectors());
        this.storage = FaissIndexLoadUtils.toBinaryIndex(FaissIndex.load(input));
    }

    @Override
    public VectorEncoding getVectorEncoding() {
        return this.storage.getVectorEncoding();
    }

    @Override
    public FloatVectorValues getFloatValues(IndexInput indexInput) throws IOException {
        throw new UnsupportedOperationException(FaissBinaryHnswIndex.class.getSimpleName() + " doees not support FloatVectorValues.");
    }

    @Override
    public ByteVectorValues getByteValues(IndexInput indexInput) throws IOException {
        return this.storage.getByteValues(indexInput);
    }

    @Override
    @Generated
    public FaissHNSW getFaissHnsw() {
        return this.faissHnsw;
    }
}

