/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.opensearch.knn.index.KNNVectorSimilarityFunction;

public final class FlatVectorsScorerProvider {
    private static final FlatVectorsScorer DELEGATE_VECTOR_SCORER = FlatVectorScorerUtil.getLucene99FlatVectorsScorer();
    private static final FlatVectorsScorer HAMMING_VECTOR_SCORER = new HammingFlatVectorsScorer();

    public static FlatVectorsScorer getFlatVectorsScorer(KNNVectorSimilarityFunction similarityFunction) {
        if (similarityFunction == KNNVectorSimilarityFunction.HAMMING) {
            return HAMMING_VECTOR_SCORER;
        }
        return DELEGATE_VECTOR_SCORER;
    }

    @Generated
    private FlatVectorsScorerProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class HammingFlatVectorsScorer
    implements FlatVectorsScorer {
        private HammingFlatVectorsScorer() {
        }

        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction vectorSimilarityFunction, KnnVectorValues knnVectorValues, final byte[] target) {
            if (knnVectorValues instanceof ByteVectorValues) {
                final ByteVectorValues byteVectorValues = (ByteVectorValues)knnVectorValues;
                return new RandomVectorScorer.AbstractRandomVectorScorer(this, knnVectorValues){

                    public float score(int internalVectorId) throws IOException {
                        byte[] quantizedByteVector = byteVectorValues.vectorValue(internalVectorId);
                        return KNNVectorSimilarityFunction.HAMMING.compare(target, quantizedByteVector);
                    }
                };
            }
            throw new IllegalArgumentException("Expected " + ByteVectorValues.class.getSimpleName() + " for hamming vector scorer, got " + knnVectorValues.getClass().getSimpleName());
        }

        public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction vectorSimilarityFunction, KnnVectorValues knnVectorValues) {
            throw new UnsupportedOperationException();
        }

        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction vectorSimilarityFunction, KnnVectorValues knnVectorValues, float[] target) {
            throw new UnsupportedOperationException();
        }
    }
}

