/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.api.resthandler;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.SMActions;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.index.IndexSMPolicyRequest;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.index.IndexSMPolicyResponse;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;
import org.opensearch.indexmanagement.snapshotmanagement.util.RestHandlerUtilsKt;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0004\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/api/resthandler/RestBaseIndexSMPolicyHandler;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "prepareIndexRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "create", "", "opensearch-index-management"})
public abstract class RestBaseIndexSMPolicyHandler
extends BaseRestHandler {
    @NotNull
    protected final BaseRestHandler.RestChannelConsumer prepareIndexRequest(@NotNull RestRequest request, @NotNull NodeClient client, boolean create) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String policyName = RestHandlerUtilsKt.getValidSMPolicyName(request);
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        XContentParser xcp = request.contentParser();
        Intrinsics.checkNotNull((Object)xcp);
        SMPolicy sMPolicy = SMPolicy.Companion.parse(xcp, SMUtilsKt.smPolicyNameToDocId(policyName), seqNo, primaryTerm);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        SMPolicy policy2 = SMPolicy.copy$default(sMPolicy, null, null, 0L, null, null, null, false, instant, null, null, 0L, 0L, null, null, 16255, null);
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        return arg_0 -> RestBaseIndexSMPolicyHandler.prepareIndexRequest$lambda$0(client, policy2, create, refreshPolicy, arg_0);
    }

    private static final void prepareIndexRequest$lambda$0(NodeClient $client, SMPolicy $policy, boolean $create, WriteRequest.RefreshPolicy $refreshPolicy, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$policy, (String)"$policy");
        ActionType<IndexSMPolicyResponse> actionType = SMActions.INSTANCE.getINDEX_SM_POLICY_ACTION_TYPE();
        Intrinsics.checkNotNull((Object)$refreshPolicy);
        $client.execute(actionType, (ActionRequest)new IndexSMPolicyRequest($policy, $create, $refreshPolicy), (ActionListener)new RestResponseListener<IndexSMPolicyResponse>(it){

            @NotNull
            public RestResponse buildResponse(@NotNull IndexSMPolicyResponse response2) {
                Intrinsics.checkNotNullParameter((Object)((Object)response2), (String)"response");
                RestStatus restStatus = response2.getStatus();
                XContentBuilder xContentBuilder = this.channel.newBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"newBuilder(...)");
                ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                BytesRestResponse restResponse = new BytesRestResponse(restStatus, response2.toXContent(xContentBuilder, params));
                if (response2.getStatus() == RestStatus.CREATED || response2.getStatus() == RestStatus.OK) {
                    String location = "/_plugins/_sm/policies/" + response2.getPolicy().getPolicyName();
                    restResponse.addHeader("Location", location);
                }
                return (RestResponse)restResponse;
            }
        });
    }
}

