/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.transform;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.indexmanagement.indexstatemanagement.action.TransformAction;
import org.opensearch.indexmanagement.indexstatemanagement.step.transform.AttemptCreateTransformJobStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.TransformActionProperties;
import org.opensearch.indexmanagement.transform.action.index.IndexTransformAction;
import org.opensearch.indexmanagement.transform.action.index.IndexTransformRequest;
import org.opensearch.indexmanagement.transform.action.index.IndexTransformResponse;
import org.opensearch.indexmanagement.transform.action.start.StartTransformAction;
import org.opensearch.indexmanagement.transform.action.start.StartTransformRequest;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u0001H\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bJ\u001e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0082@\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/transform/AttemptCreateTransformJobStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/TransformAction;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/TransformAction;)V", "info", "", "", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "transformId", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "isIdempotent", "", "processFailure", "", "indexName", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "startTransformJob", "context", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "(Ljava/lang/String;Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "opensearch-index-management"})
public final class AttemptCreateTransformJobStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransformAction action;
    private final Logger logger;
    @NotNull
    private Step.StepStatus stepStatus;
    @Nullable
    private Map<String, ? extends Object> info;
    @Nullable
    private String transformId;
    @NotNull
    public static final String name = "attempt_create_transform";

    public AttemptCreateTransformJobStep(@NotNull TransformAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false, 2, null);
        this.action = action;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> var1_1) {
        block16: {
            if (!(var1_1 instanceof execute.1)) ** GOTO lbl-1000
            var11_2 = var1_1;
            if ((var11_2.label & -2147483648) != 0) {
                var11_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    final /* synthetic */ AttemptCreateTransformJobStep this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = this.getContext();
                    if (v0 == null) {
                        return this;
                    }
                    context = v0;
                    indexName = context.getMetadata().getIndex();
                    managedIndexMetadata = context.getMetadata();
                    v1 = managedIndexMetadata.getActionMetaData();
                    startedTransformId = v1 != null && (v1 = v1.getActionProperties()) != null && (v1 = v1.getTransformActionProperties()) != null ? v1.getTransformId() : null;
                    transform = this.action.getIsmTransform().toTransform(indexName, context.getUser());
                    this.transformId = transform.getId();
                    this.logger.info("Attempting to create a transform job " + this.transformId + " for index " + indexName);
                    indexTransformRequest = new IndexTransformRequest(transform, WriteRequest.RefreshPolicy.IMMEDIATE);
                    $continuation.L$0 = this;
                    $continuation.L$1 = context;
                    $continuation.L$2 = indexName;
                    $continuation.L$3 = startedTransformId;
                    $continuation.L$4 = transform;
                    $continuation.label = 1;
                    v2 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient(), (Function2)new Function2<Client, ActionListener<IndexTransformResponse>, Unit>(indexTransformRequest){
                        final /* synthetic */ IndexTransformRequest $indexTransformRequest;
                        {
                            this.$indexTransformRequest = $indexTransformRequest;
                            super(2);
                        }

                        public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndexTransformResponse> it) {
                            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            $this$suspendUntil.execute((ActionType)IndexTransformAction.Companion.getINSTANCE(), (ActionRequest)this.$indexTransformRequest, it);
                        }
                    }, $continuation);
                    ** if (v2 != var12_4) goto lbl35
lbl34:
                    // 1 sources

                    return var12_4;
lbl35:
                    // 1 sources

                    ** GOTO lbl46
                }
                case 1: {
                    transform = (Transform)$continuation.L$4;
                    startedTransformId = (String)$continuation.L$3;
                    indexName = (String)$continuation.L$2;
                    context = (StepContext)$continuation.L$1;
                    this = (AttemptCreateTransformJobStep)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl46:
                        // 2 sources

                        response = (IndexTransformResponse)v2;
                        this.logger.info("Received status " + response.getStatus().getStatus() + " on trying to create transform job " + this.transformId);
                        this.stepStatus = Step.StepStatus.COMPLETED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptCreateTransformJobStep.Companion.getSuccessMessage(transform.getId(), indexName)));
                    }
                    catch (VersionConflictEngineException response) {
                        message = AttemptCreateTransformJobStep.Companion.getTransformJobAlreadyExistsMessage(transform.getId(), indexName);
                        this.logger.info(message);
                        if (startedTransformId != null) break;
                        $continuation.L$0 = this;
                        $continuation.L$1 = null;
                        $continuation.L$2 = null;
                        $continuation.L$3 = null;
                        $continuation.L$4 = null;
                        $continuation.label = 2;
                        v3 = this.startTransformJob(transform.getId(), context, (Continuation<? super Unit>)$continuation);
                        if (v3 == var12_4) {
                            return var12_4;
                        }
                        break block16;
                    }
                }
                case 2: {
                    this = (AttemptCreateTransformJobStep)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                    break block16;
                }
            }
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"info", (Object)message));
            break block16;
            catch (RemoteTransportException e) {
                v4 = transform.getId();
                var9_17 = ExceptionsHelper.unwrapCause((Throwable)e);
                Intrinsics.checkNotNull((Object)var9_17, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                this.processFailure(v4, indexName, (Exception)var9_17);
                break block16;
            }
            catch (OpenSearchException e) {
                this.processFailure(transform.getId(), indexName, (Exception)e);
                break block16;
            }
            catch (Exception e) {
                this.processFailure(transform.getId(), indexName, e);
            }
        }
        return this;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void processFailure(@NotNull String transformId, @NotNull String indexName, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)transformId, (String)"transformId");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String message = Companion.getFailedMessage(transformId, indexName);
        this.logger.error(message, (Throwable)e);
        this.transformId = null;
        this.stepStatus = Step.StepStatus.FAILED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message), TuplesKt.to((Object)"cause", (Object)String.valueOf(e.getMessage()))};
        this.info = MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * Unable to fully structure code
     */
    private final Object startTransformJob(String var1_1, StepContext var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof startTransformJob.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptCreateTransformJobStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptCreateTransformJobStep.access$startTransformJob(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                indexName = context.getMetadata().getIndex();
                client = context.getClient();
                this.logger.info("Attempting to re-start the transform job " + transformId);
                startTransformRequest = new StartTransformRequest(transformId);
                $continuation.L$0 = this;
                $continuation.L$1 = transformId;
                $continuation.L$2 = indexName;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client, (Function2)new Function2<Client, ActionListener<AcknowledgedResponse>, Unit>(startTransformRequest){
                    final /* synthetic */ StartTransformRequest $startTransformRequest;
                    {
                        this.$startTransformRequest = $startTransformRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.execute((ActionType)StartTransformAction.Companion.getINSTANCE(), (ActionRequest)this.$startTransformRequest, it);
                    }
                }, $continuation);
                ** if (v0 != var10_6) goto lbl25
lbl24:
                // 1 sources

                return var10_6;
lbl25:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                indexName = (String)$continuation.L$2;
                transformId = (String)$continuation.L$1;
                this = (AttemptCreateTransformJobStep)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl34:
                    // 2 sources

                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptCreateTransformJobStep.Companion.getSuccessRestartMessage(transformId, indexName)));
                }
                catch (Exception e) {
                    message = AttemptCreateTransformJobStep.Companion.getFailedToStartMessage(transformId, indexName);
                    this.logger.error(message, (Throwable)e);
                    this.stepStatus = Step.StepStatus.FAILED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        ActionMetaData currentActionMetaData = currentMetadata.getActionMetaData();
        TransformActionProperties transformActionProperties = new TransformActionProperties(this.transformId);
        ActionMetaData actionMetaData = currentActionMetaData;
        ActionMetaData actionMetaData2 = actionMetaData != null ? ActionMetaData.copy$default((ActionMetaData)actionMetaData, null, null, (int)0, (boolean)false, (int)0, null, (ActionProperties)new ActionProperties(null, null, null, null, null, transformActionProperties, 31, null), (int)63, null) : null;
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, (ActionMetaData)actionMetaData2, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, null, (int)250623, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    public static final /* synthetic */ Object access$startTransformJob(AttemptCreateTransformJobStep $this, String transformId, StepContext context, Continuation $completion) {
        return $this.startTransformJob(transformId, context, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/transform/AttemptCreateTransformJobStep$Companion;", "", "()V", "name", "", "getFailedMessage", "transformId", "index", "getFailedToStartMessage", "getSuccessMessage", "getSuccessRestartMessage", "getTransformJobAlreadyExistsMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String transformId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)transformId, (String)"transformId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to create the transform job [" + transformId + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getTransformJobAlreadyExistsMessage(@NotNull String transformId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)transformId, (String)"transformId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Transform job [" + transformId + "] already exists, skipping creation [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedToStartMessage(@NotNull String transformId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)transformId, (String)"transformId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to start the transform job [" + transformId + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String transformId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)transformId, (String)"transformId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully created the transform job [" + transformId + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessRestartMessage(@NotNull String transformId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)transformId, (String)"transformId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully restarted the transform job [" + transformId + "] [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

