function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiPanel } from '../panel';
import { useIsWithinBreakpoints } from '../../../services/hooks';

/**
 * Consumed via `OuiSplitPanel.Inner`.
 * Extends most `OuiPanelProps`.
 */
export var _OuiSplitPanelInner = function _OuiSplitPanelInner(_ref) {
  var children = _ref.children,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["children", "className"]);

  var classes = classNames('ouiSplitPanel__inner', className);
  var panelProps = {
    hasShadow: false,
    color: 'transparent',
    borderRadius: 'none',
    hasBorder: false
  };
  return /*#__PURE__*/React.createElement(OuiPanel, _extends({
    element: "div",
    className: classes
  }, panelProps, rest), children);
};
_OuiSplitPanelInner.propTypes = {
  /**
     * Padding for all four sides
     */
  paddingSize: PropTypes.any,

  /**
     * When true the panel will grow in height to match `OuiFlexItem`
     */
  grow: PropTypes.bool,
  panelRef: PropTypes.any,

  /**
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  color: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};

/**
 * Consumed via `OuiSplitPanel.Outer`.
 * Extends most `OuiPanelProps`.
 */
export var _OuiSplitPanelOuter = function _OuiSplitPanelOuter(_ref2) {
  var children = _ref2.children,
      className = _ref2.className,
      _ref2$direction = _ref2.direction,
      direction = _ref2$direction === void 0 ? 'column' : _ref2$direction,
      _ref2$responsive = _ref2.responsive,
      responsive = _ref2$responsive === void 0 ? ['xs', 's'] : _ref2$responsive,
      rest = _objectWithoutProperties(_ref2, ["children", "className", "direction", "responsive"]);

  var isResponsive = useIsWithinBreakpoints(responsive, !!responsive);
  var classes = classNames('ouiSplitPanel', {
    'ouiSplitPanel--row': direction === 'row',
    'ouiSplitPanel-isResponsive': isResponsive
  }, className);
  return /*#__PURE__*/React.createElement(OuiPanel, _extends({
    paddingSize: "none",
    grow: false,
    className: classes
  }, rest), children);
};
_OuiSplitPanelOuter.propTypes = {
  /**
     * Any number of _OuiSplitPanelInner components
     */
  children: PropTypes.node,

  /**
     * Changes the flex-direction
     */
  direction: PropTypes.oneOf(["column", "row"]),

  /**
     * Stacks row display on small screens.
     * Remove completely with `false` or provide your own list of breakpoint sizes to stack on.
     */
  responsive: PropTypes.oneOfType([PropTypes.oneOf([false]), PropTypes.arrayOf(PropTypes.oneOf(["xs", "s", "m", "l", "xl", "xxl", "xxxl"]).isRequired).isRequired])
};
export var OuiSplitPanel = {
  Outer: _OuiSplitPanelOuter,
  Inner: _OuiSplitPanelInner
};
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */
export { _EuiSplitPanelInner, _EuiSplitPanelOuter, EuiSplitPanel } from '../../../eui_components/panel/split_panel/split_panel';